/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web;

import java.util.Arrays;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Check;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.CheckGroup;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.geoserver.gwc.config.GWCConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingOptionsPanel
extends Panel {
    private static final long serialVersionUID = 1L;

    public CachingOptionsPanel(String id, IModel<GWCConfig> gwcConfigModel) {
        super(id, gwcConfigModel);
        PropertyModel autoCacheLayersModel = new PropertyModel(gwcConfigModel, "cacheLayersByDefault");
        CheckBox autoCacheLayers = new CheckBox("cacheLayersByDefault", (IModel)autoCacheLayersModel);
        this.add(new Component[]{autoCacheLayers});
        PropertyModel nonDefaultStylesModel = new PropertyModel(gwcConfigModel, "cacheNonDefaultStyles");
        CheckBox cacheNonDefaultStyles = new CheckBox("cacheNonDefaultStyles", (IModel)nonDefaultStylesModel);
        this.add(new Component[]{cacheNonDefaultStyles});
        List<Integer> metaTilingChoices = Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 9, 10);
        PropertyModel metaTilingXModel = new PropertyModel(gwcConfigModel, "metaTilingX");
        DropDownChoice metaTilingX = new DropDownChoice("metaTilingX", (IModel)metaTilingXModel, metaTilingChoices);
        this.add(new Component[]{metaTilingX});
        PropertyModel metaTilingYModel = new PropertyModel(gwcConfigModel, "metaTilingY");
        DropDownChoice metaTilingY = new DropDownChoice("metaTilingY", (IModel)metaTilingYModel, metaTilingChoices);
        this.add(new Component[]{metaTilingY});
        PropertyModel gutterModel = new PropertyModel(gwcConfigModel, "gutter");
        List<Integer> gutterChoices = Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 15, 20, 50);
        DropDownChoice gutterChoice = new DropDownChoice("gutter", (IModel)gutterModel, gutterChoices);
        this.add(new Component[]{gutterChoice});
        List<String> formats = Arrays.asList("image/png", "image/png8", "image/jpeg", "image/gif");
        PropertyModel vectorFormatsModel = new PropertyModel(gwcConfigModel, "defaultVectorCacheFormats");
        CheckGroup vectorFormatsGroup = new CheckGroup("vectorFormatsGroup", (IModel)vectorFormatsModel);
        this.add(new Component[]{vectorFormatsGroup});
        vectorFormatsGroup.add(new Component[]{new ListView<String>("vectorFromats", formats){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<String> item) {
                item.add(new Component[]{new Check("vectorFormatsOption", item.getModel())});
                item.add(new Component[]{new Label("name", item.getModel())});
            }
        }});
        PropertyModel rasterFormatsModel = new PropertyModel(gwcConfigModel, "defaultCoverageCacheFormats");
        CheckGroup rasterFormatsGroup = new CheckGroup("rasterFormatsGroup", (IModel)rasterFormatsModel);
        this.add(new Component[]{rasterFormatsGroup});
        rasterFormatsGroup.add(new Component[]{new ListView<String>("rasterFromats", formats){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<String> item) {
                item.add(new Component[]{new Check("rasterFormatsOption", item.getModel())});
                item.add(new Component[]{new Label("name", item.getModel())});
            }
        }});
        PropertyModel otherFormatsModel = new PropertyModel(gwcConfigModel, "defaultOtherCacheFormats");
        CheckGroup otherFormatsGroup = new CheckGroup("otherFormatsGroup", (IModel)otherFormatsModel);
        this.add(new Component[]{otherFormatsGroup});
        otherFormatsGroup.add(new Component[]{new ListView<String>("otherFromats", formats){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<String> item) {
                item.add(new Component[]{new Check("otherFormatsOption", item.getModel())});
                item.add(new Component[]{new Label("name", item.getModel())});
            }
        }});
    }
}

