/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.apache.wicket.model.LoadableDetachableModel;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.gwc.web.CachedLayerInfo;
import org.geotools.util.logging.Logging;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.wms.WMSLayer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedLayerDetachableModel
extends LoadableDetachableModel<CachedLayerInfo> {
    private static final Logger LOGGER = Logging.getLogger(CachedLayerDetachableModel.class);
    private String name;

    public CachedLayerDetachableModel(CachedLayerInfo layer) {
        super((Object)layer);
        this.name = layer.getName();
    }

    protected CachedLayerInfo load() {
        GWC facade = GWC.get();
        return CachedLayerDetachableModel.create(this.name, facade);
    }

    static CachedLayerInfo create(String name, GWC gwc) {
        TileLayer layer = gwc.getTileLayerByName(name);
        CachedLayerInfo info = new CachedLayerInfo();
        info.setName(name);
        info.setType(CachedLayerDetachableModel.getType(layer));
        boolean enabled = layer.isEnabled();
        info.setEnabled(enabled);
        if (gwc.isDiskQuotaAvailable()) {
            info.setQuotaLimit(gwc.getQuotaLimit(name));
            info.setQuotaUsed(gwc.getUsedQuota(name));
        }
        if (!enabled && layer instanceof GeoServerTileLayer) {
            String error = ((GeoServerTileLayer)layer).getConfigErrorMessage();
            info.setConfigErrorMessage(error);
        }
        return info;
    }

    private static CachedLayerInfo.TYPE getType(TileLayer layer) {
        if (layer instanceof WMSLayer) {
            return CachedLayerInfo.TYPE.WMS;
        }
        if (layer instanceof GeoServerTileLayer) {
            GeoServerTileLayer gtl = (GeoServerTileLayer)layer;
            LayerInfo li = gtl.getLayerInfo();
            if (li != null) {
                ResourceInfo resource = li.getResource();
                if (resource instanceof FeatureTypeInfo) {
                    return CachedLayerInfo.TYPE.VECTOR;
                }
                if (resource instanceof CoverageInfo) {
                    return CachedLayerInfo.TYPE.RASTER;
                }
                if (resource instanceof WMSLayerInfo) {
                    return CachedLayerInfo.TYPE.WMS;
                }
            } else if (gtl.getLayerGroupInfo() != null) {
                return CachedLayerInfo.TYPE.LAYERGROUP;
            }
        }
        LOGGER.info("Unknown TileLayer type, returning OTHER: " + layer.getClass().getName());
        return CachedLayerInfo.TYPE.OTHER;
    }

    public static List<CachedLayerInfo> getItems(GWC gwc) {
        LazyCachedLayerInfoList lazyList = new LazyCachedLayerInfoList(gwc);
        return lazyList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LazyCachedLayerInfoList
    extends AbstractList<CachedLayerInfo> {
        private final GWC gwc;
        private final List<String> layerNames;

        public LazyCachedLayerInfoList(GWC gwc) {
            this.gwc = gwc;
            ArrayList<String> names = new ArrayList<String>(gwc.getTileLayerNames());
            Collections.sort(names);
            this.layerNames = names;
        }

        @Override
        public CachedLayerInfo get(int index) {
            String name = this.layerNames.get(index);
            return CachedLayerDetachableModel.create(name, this.gwc);
        }

        @Override
        public int size() {
            return this.layerNames.size();
        }
    }
}

