/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.web;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.Radio;
import org.apache.wicket.markup.html.form.RadioGroup;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.MinimumValidator;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.web.services.BaseServiceAdminPage;
import org.geoserver.web.util.MapModel;
import org.geoserver.wfs.GMLInfo;
import org.geoserver.wfs.WFSInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WFSAdminPage
extends BaseServiceAdminPage<WFSInfo> {
    protected Class<WFSInfo> getServiceClass() {
        return WFSInfo.class;
    }

    protected void build(final IModel info, Form form) {
        form.add(new Component[]{new TextField("maxFeatures").add((IValidator)new MinimumValidator((Comparable)Integer.valueOf(0)))});
        form.add(new Component[]{new CheckBox("featureBounding")});
        RadioGroup sl = new RadioGroup("serviceLevel");
        form.add(new Component[]{sl});
        sl.add(new Component[]{new Radio("basic", (IModel)new Model((Serializable)WFSInfo.ServiceLevel.BASIC))});
        sl.add(new Component[]{new Radio("transactional", (IModel)new Model((Serializable)WFSInfo.ServiceLevel.TRANSACTIONAL))});
        sl.add(new Component[]{new Radio("complete", (IModel)new Model((Serializable)WFSInfo.ServiceLevel.COMPLETE))});
        LoadableDetachableModel gml2Model = new LoadableDetachableModel(){

            public Object load() {
                return ((WFSInfo)info.getObject()).getGML().get(WFSInfo.Version.V_10);
            }
        };
        LoadableDetachableModel gml3Model = new LoadableDetachableModel(){

            public Object load() {
                return ((WFSInfo)info.getObject()).getGML().get(WFSInfo.Version.V_11);
            }
        };
        form.add(new Component[]{new GMLPanel("gml2", (IModel)gml2Model)});
        form.add(new Component[]{new GMLPanel("gml3", (IModel)gml3Model)});
        form.add(new Component[]{new CheckBox("canonicalSchemaLocation")});
        RadioGroup eo = new RadioGroup("encodeFeatureMember");
        form.add(new Component[]{eo});
        eo.add(new Component[]{new Radio("featureMembers", (IModel)new Model((Serializable)Boolean.FALSE))});
        eo.add(new Component[]{new Radio("featureMember", (IModel)new Model((Serializable)Boolean.TRUE))});
        PropertyModel metadataModel = new PropertyModel((Object)info, "metadata");
        MapModel prjFormatModel = new MapModel((IModel)metadataModel, "SHAPE-ZIP_DEFAULT_PRJ_IS_ESRI");
        CheckBox defaultPrjFormat = new CheckBox("shapeZipPrjFormat", (IModel)prjFormatModel);
        form.add(new Component[]{defaultPrjFormat});
        try {
            GeoServerResourceLoader resourceLoader = (GeoServerResourceLoader)GeoServerExtensions.bean(GeoServerResourceLoader.class);
            File esriProjs = resourceLoader.find(new String[]{"user_projections", "esri.properties"});
            if (esriProjs == null) {
                defaultPrjFormat.setEnabled(false);
                defaultPrjFormat.getModel().setObject((Object)Boolean.FALSE);
                defaultPrjFormat.add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new Model((Serializable)((Object)"No esri.properties file found in the data directory's user_projections folder. This option is not available")))});
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, e.getMessage(), e);
        }
    }

    protected String getServiceName() {
        return "WFS";
    }

    static class GMLPanel
    extends Panel {
        public GMLPanel(String id, IModel gmlModel) {
            super(id, (IModel)new CompoundPropertyModel((Object)gmlModel));
            List<GMLInfo.SrsNameStyle> choices = Arrays.asList(GMLInfo.SrsNameStyle.values());
            DropDownChoice srsNameStyle = new DropDownChoice("srsNameStyle", choices);
            this.add(new Component[]{srsNameStyle});
            this.add(new Component[]{new CheckBox("overrideGMLAttributes")});
        }
    }
}

