/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml.v1_0_0;

import java.net.URI;
import java.util.Collection;
import javax.xml.namespace.QName;
import net.opengis.wfs.InsertElementType;
import net.opengis.wfs.WfsFactory;
import org.eclipse.emf.ecore.EFactory;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.xml.v1_0_0.WFS;
import org.geotools.gml2.bindings.GML2ParsingUtils;
import org.geotools.gml3.GML;
import org.geotools.xml.AbstractComplexEMFBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.picocontainer.MutablePicoContainer;

public class InsertElementTypeBinding
extends AbstractComplexEMFBinding {
    WfsFactory wfsfactory;

    public InsertElementTypeBinding(WfsFactory wfsfactory) {
        super((EFactory)wfsfactory);
        this.wfsfactory = wfsfactory;
    }

    public QName getTarget() {
        return WFS.INSERTELEMENTTYPE;
    }

    public Class getType() {
        return InsertElementTypeBinding.class;
    }

    public void initializeChildContext(ElementInstance childInstance, Node node, MutablePicoContainer context) {
        if (node.hasAttribute("srsName")) {
            try {
                CoordinateReferenceSystem crs = GML2ParsingUtils.crs((Node)node);
                if (crs != null) {
                    context.registerComponentInstance(CoordinateReferenceSystem.class, (Object)crs);
                }
            }
            catch (Exception e) {
                throw new WFSException(e, "InvalidParameterValue");
            }
        }
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        InsertElementType insertElement = this.wfsfactory.createInsertElementType();
        insertElement.getFeature().addAll((Collection)node.getChildValues(SimpleFeature.class));
        if (node.hasAttribute("handle")) {
            insertElement.setHandle((String)node.getAttributeValue("handle"));
        }
        if (node.hasAttribute("srsName")) {
            String srsName = (String)node.getAttributeValue("srsName");
            insertElement.setSrsName(new URI(srsName));
        }
        return insertElement;
    }

    public Object getProperty(Object object, QName name) throws Exception {
        InsertElementType insert = (InsertElementType)object;
        if (GML._Feature.equals(name)) {
            return insert.getFeature();
        }
        return super.getProperty(object, name);
    }
}

