/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.describelayer;

import java.io.StringWriter;
import java.io.Writer;
import javax.xml.transform.TransformerException;
import junit.framework.TestCase;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.CatalogImpl;
import org.geoserver.catalog.impl.CoverageInfoImpl;
import org.geoserver.catalog.impl.CoverageStoreInfoImpl;
import org.geoserver.catalog.impl.DataStoreInfoImpl;
import org.geoserver.catalog.impl.FeatureTypeInfoImpl;
import org.geoserver.catalog.impl.LayerInfoImpl;
import org.geoserver.catalog.impl.NamespaceInfoImpl;
import org.geoserver.catalog.impl.WorkspaceInfoImpl;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.impl.GeoServerImpl;
import org.geoserver.wms.DescribeLayerRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSInfoImpl;
import org.geoserver.wms.WMSTestSupport;
import org.geoserver.wms.describelayer.DescribeLayerTransformer;
import org.geotools.xml.transform.TransformerBase;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DescribeLayerTransformerTest
extends TestCase {
    private static final String TEST_NS_PREFIX = "geos";
    private static final String TEST_NAMESPACE = "http//www.geoserver.org/test";
    private DescribeLayerRequest request;
    private DescribeLayerTransformer transformer;
    private XpathEngine XPATH;
    private CatalogImpl catalog;
    private FeatureTypeInfoImpl featureTypeInfo;
    private CoverageInfoImpl coverageInfo;
    private LayerInfoImpl vectorLayerInfo;
    private LayerInfoImpl coverageLayerInfo;

    protected void setUp() throws Exception {
        this.XPATH = XMLUnit.newXpathEngine();
        GeoServerImpl geoServerImpl = new GeoServerImpl();
        this.catalog = new CatalogImpl();
        geoServerImpl.setCatalog((Catalog)this.catalog);
        NamespaceInfoImpl ns = new NamespaceInfoImpl();
        ns.setPrefix(TEST_NS_PREFIX);
        ns.setURI(TEST_NAMESPACE);
        WorkspaceInfoImpl workspace = new WorkspaceInfoImpl();
        workspace.setId("fakeWs");
        workspace.setName("fakeWs");
        DataStoreInfoImpl dataStoreInfo = new DataStoreInfoImpl((Catalog)this.catalog);
        dataStoreInfo.setName("fakeDs");
        dataStoreInfo.setId("fakeDs");
        dataStoreInfo.setWorkspace((WorkspaceInfo)workspace);
        this.featureTypeInfo = new FeatureTypeInfoImpl((Catalog)this.catalog);
        this.featureTypeInfo.setNamespace((NamespaceInfo)ns);
        this.featureTypeInfo.setName("states");
        this.featureTypeInfo.setStore((StoreInfo)dataStoreInfo);
        this.vectorLayerInfo = new LayerInfoImpl();
        this.vectorLayerInfo.setResource((ResourceInfo)this.featureTypeInfo);
        this.vectorLayerInfo.setId("states");
        this.vectorLayerInfo.setName("states");
        this.catalog.add((NamespaceInfo)ns);
        this.catalog.add((WorkspaceInfo)workspace);
        this.catalog.add((StoreInfo)dataStoreInfo);
        this.catalog.add((ResourceInfo)this.featureTypeInfo);
        this.catalog.add((LayerInfo)this.vectorLayerInfo);
        CoverageStoreInfoImpl coverageStoreInfo = new CoverageStoreInfoImpl((Catalog)this.catalog);
        coverageStoreInfo.setId("coverageStore");
        coverageStoreInfo.setName("coverageStore");
        coverageStoreInfo.setWorkspace((WorkspaceInfo)workspace);
        this.coverageInfo = new CoverageInfoImpl((Catalog)this.catalog);
        this.coverageInfo.setNamespace((NamespaceInfo)ns);
        this.coverageInfo.setName("fakeCoverage");
        this.coverageInfo.setStore((StoreInfo)coverageStoreInfo);
        this.coverageLayerInfo = new LayerInfoImpl();
        this.coverageLayerInfo.setResource((ResourceInfo)this.coverageInfo);
        this.coverageLayerInfo.setId("fakeCoverage");
        this.coverageLayerInfo.setName("fakeCoverage");
        this.catalog.add((StoreInfo)coverageStoreInfo);
        this.catalog.add((ResourceInfo)this.coverageInfo);
        this.catalog.add((LayerInfo)this.coverageLayerInfo);
        geoServerImpl.add((ServiceInfo)new WMSInfoImpl());
        WMS wms = new WMS((GeoServer)geoServerImpl);
        this.request = new DescribeLayerRequest();
        this.request.setBaseUrl("http://localhost:8080/geoserver");
        this.request.setVersion(WMS.VERSION_1_1_1.toString());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testPreconditions() throws TransformerException {
        try {
            new DescribeLayerTransformer(null);
            DescribeLayerTransformerTest.fail((String)"expected NPE on null base url");
        }
        catch (NullPointerException e) {
            DescribeLayerTransformerTest.assertTrue((boolean)true);
        }
        this.transformer = new DescribeLayerTransformer("http://geoserver.org");
        try {
            this.transformer.transform(null);
            DescribeLayerTransformerTest.fail((String)"expected IAE on null request");
        }
        catch (TransformerException e) {
            DescribeLayerTransformerTest.assertTrue((boolean)(e.getCause() instanceof IllegalArgumentException));
        }
        try {
            this.transformer.transform(new Object());
            DescribeLayerTransformerTest.fail((String)"expected IAE on argument non a DescribeLayerRequest instance");
        }
        catch (TransformerException e) {
            DescribeLayerTransformerTest.assertTrue((boolean)(e.getCause() instanceof IllegalArgumentException));
        }
    }

    public void testRootElement() throws Exception {
        this.transformer = new DescribeLayerTransformer("http://geoserver.org");
        Document dom = WMSTestSupport.transform(this.request, (TransformerBase)this.transformer);
        Element root = dom.getDocumentElement();
        DescribeLayerTransformerTest.assertEquals((String)"WMS_DescribeLayerResponse", (String)root.getNodeName());
        DescribeLayerTransformerTest.assertEquals((String)"1.1.1", (String)root.getAttribute("version"));
    }

    public void testDTDLocation() throws Exception {
        String expected = "!DOCTYPE WMS_DescribeLayerResponse SYSTEM \"http://geoserver.org/schemas/wms/1.1.1/WMS_DescribeLayerResponse.dtd\"";
        this.transformer = new DescribeLayerTransformer("http://geoserver.org");
        StringWriter writer = new StringWriter();
        this.transformer.transform((Object)this.request, (Writer)writer);
        DescribeLayerTransformerTest.assertTrue((writer.getBuffer().indexOf("!DOCTYPE WMS_DescribeLayerResponse SYSTEM \"http://geoserver.org/schemas/wms/1.1.1/WMS_DescribeLayerResponse.dtd\"") > 0 ? 1 : 0) != 0);
    }

    public void testSingleVectorLayer() throws Exception {
        MapLayerInfo mapLayerInfo = new MapLayerInfo((LayerInfo)this.vectorLayerInfo);
        this.request.addLayer(mapLayerInfo);
        String serverBaseUrl = "http://geoserver.org";
        this.transformer = new DescribeLayerTransformer("http://geoserver.org");
        Document dom = WMSTestSupport.transform(this.request, (TransformerBase)this.transformer);
        String layerDescPath = "/WMS_DescribeLayerResponse/LayerDescription";
        XMLAssert.assertXpathExists((String)"/WMS_DescribeLayerResponse/LayerDescription", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"geos:states", (String)"/WMS_DescribeLayerResponse/LayerDescription/@name", (Document)dom);
        String expectedWfsAtt = "http://geoserver.org/wfs/WfsDispatcher?";
        XMLAssert.assertXpathExists((String)"/WMS_DescribeLayerResponse/LayerDescription/@wfs", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"http://geoserver.org/wfs/WfsDispatcher?", (String)"/WMS_DescribeLayerResponse/LayerDescription/@wfs", (Document)dom);
        XMLAssert.assertXpathExists((String)"/WMS_DescribeLayerResponse/LayerDescription/@owsURL", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"http://geoserver.org/wfs/WfsDispatcher?", (String)"/WMS_DescribeLayerResponse/LayerDescription/@owsURL", (Document)dom);
        XMLAssert.assertXpathExists((String)"/WMS_DescribeLayerResponse/LayerDescription/@owsType", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"WFS", (String)"/WMS_DescribeLayerResponse/LayerDescription/@owsType", (Document)dom);
        XMLAssert.assertXpathExists((String)"/WMS_DescribeLayerResponse/LayerDescription/Query", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"geos:states", (String)"/WMS_DescribeLayerResponse/LayerDescription/Query/@typeName", (Document)dom);
    }

    public void testSingleRasterLayer() throws Exception {
        MapLayerInfo mapLayerInfo = new MapLayerInfo((LayerInfo)this.coverageLayerInfo);
        this.request.addLayer(mapLayerInfo);
        String serverBaseUrl = "http://geoserver.org";
        this.transformer = new DescribeLayerTransformer("http://geoserver.org");
        Document dom = WMSTestSupport.transform(this.request, (TransformerBase)this.transformer);
        String layerDescPath = "/WMS_DescribeLayerResponse/LayerDescription";
        XMLAssert.assertXpathExists((String)"/WMS_DescribeLayerResponse/LayerDescription", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"geos:fakeCoverage", (String)"/WMS_DescribeLayerResponse/LayerDescription/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"", (String)"/WMS_DescribeLayerResponse/LayerDescription/@wfs", (Document)dom);
        XMLAssert.assertXpathExists((String)"/WMS_DescribeLayerResponse/LayerDescription/@owsURL", (Document)dom);
        String expectedOWSURLAtt = "http://geoserver.org/wcs?";
        XMLAssert.assertXpathEvaluatesTo((String)"http://geoserver.org/wcs?", (String)"/WMS_DescribeLayerResponse/LayerDescription/@owsURL", (Document)dom);
        XMLAssert.assertXpathExists((String)"/WMS_DescribeLayerResponse/LayerDescription/@owsType", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"WCS", (String)"/WMS_DescribeLayerResponse/LayerDescription/@owsType", (Document)dom);
        XMLAssert.assertXpathExists((String)"/WMS_DescribeLayerResponse/LayerDescription/Query", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"geos:fakeCoverage", (String)"/WMS_DescribeLayerResponse/LayerDescription/Query/@typeName", (Document)dom);
    }

    public void testMultipleLayers() throws Exception {
        this.request.addLayer(new MapLayerInfo((LayerInfo)this.vectorLayerInfo));
        this.request.addLayer(new MapLayerInfo((LayerInfo)this.coverageLayerInfo));
        String serverBaseUrl = "http://geoserver.org";
        this.transformer = new DescribeLayerTransformer("http://geoserver.org");
        Document dom = WMSTestSupport.transform(this.request, (TransformerBase)this.transformer);
        String layerDescPath1 = "/WMS_DescribeLayerResponse/LayerDescription[1]";
        String layerDescPath2 = "/WMS_DescribeLayerResponse/LayerDescription[2]";
        XMLAssert.assertXpathExists((String)"/WMS_DescribeLayerResponse/LayerDescription[1]", (Document)dom);
        XMLAssert.assertXpathExists((String)"/WMS_DescribeLayerResponse/LayerDescription[2]", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"geos:states", (String)"/WMS_DescribeLayerResponse/LayerDescription[1]/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"geos:fakeCoverage", (String)"/WMS_DescribeLayerResponse/LayerDescription[2]/@name", (Document)dom);
    }
}

