/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.jndi;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import org.geotools.arcsde.session.ArcSDEConnectionConfig;
import org.geotools.arcsde.session.ISession;
import org.geotools.arcsde.session.ISessionPool;
import org.geotools.arcsde.session.ISessionPoolFactory;
import org.geotools.arcsde.session.UnavailableConnectionException;

final class SharedSessionPool
implements ISessionPool {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.arcsde.session");
    private static int instanceCounter;
    private final int instanceNumber;
    private final ISessionPool delegate;
    private static final Map<ArcSDEConnectionConfig, SharedSessionPool> instances;

    protected SharedSessionPool(ISessionPool delegate) throws IOException {
        this.delegate = delegate;
        this.instanceNumber = ++instanceCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ISessionPool getInstance(ArcSDEConnectionConfig config, ISessionPoolFactory factory) throws IOException {
        LOGGER.info("Getting shared session pool for " + config);
        if (!instances.containsKey(config)) {
            Map<ArcSDEConnectionConfig, SharedSessionPool> map = instances;
            synchronized (map) {
                if (!instances.containsKey(config)) {
                    LOGGER.info("Creating shared session pool for " + config);
                    ISessionPool pool = factory.createPool(config);
                    SharedSessionPool sharedPool = new SharedSessionPool(pool);
                    instances.put(config, sharedPool);
                    LOGGER.info("Created shared pool " + sharedPool);
                }
            }
        }
        SharedSessionPool sharedPool = instances.get(config);
        LOGGER.info("Returning shared session pool " + sharedPool);
        return sharedPool;
    }

    protected void finalize() {
        LOGGER.info("Destroying session pool for " + this.getConfig());
        this.delegate.close();
    }

    public void close() {
        LOGGER.info("Ignoring SessionPool close, this is a shared pool");
    }

    public int getAvailableCount() {
        return this.delegate.getAvailableCount();
    }

    public ArcSDEConnectionConfig getConfig() {
        return this.delegate.getConfig();
    }

    public int getInUseCount() {
        return this.delegate.getInUseCount();
    }

    public int getPoolSize() {
        return this.delegate.getPoolSize();
    }

    public ISession getSession() throws IOException, UnavailableConnectionException {
        return this.delegate.getSession();
    }

    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("[(").append(this.instanceNumber).append("), ");
        sb.append("delegate=").append(this.delegate).append("]");
        return sb.toString();
    }

    static {
        instances = Collections.synchronizedMap(new WeakHashMap());
    }
}

