/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.session;

import com.esri.sde.sdk.client.SeColumnDefinition;
import com.esri.sde.sdk.client.SeConnection;
import com.esri.sde.sdk.client.SeDBMSInfo;
import com.esri.sde.sdk.client.SeDelete;
import com.esri.sde.sdk.client.SeError;
import com.esri.sde.sdk.client.SeException;
import com.esri.sde.sdk.client.SeInsert;
import com.esri.sde.sdk.client.SeLayer;
import com.esri.sde.sdk.client.SeObjectId;
import com.esri.sde.sdk.client.SeQuery;
import com.esri.sde.sdk.client.SeRasterColumn;
import com.esri.sde.sdk.client.SeRegistration;
import com.esri.sde.sdk.client.SeRelease;
import com.esri.sde.sdk.client.SeRow;
import com.esri.sde.sdk.client.SeSqlConstruct;
import com.esri.sde.sdk.client.SeState;
import com.esri.sde.sdk.client.SeStreamOp;
import com.esri.sde.sdk.client.SeTable;
import com.esri.sde.sdk.client.SeUpdate;
import com.esri.sde.sdk.client.SeVersion;
import com.esri.sde.sdk.geom.GeometryFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.pool.ObjectPool;
import org.geotools.arcsde.ArcSdeException;
import org.geotools.arcsde.session.ArcSDEConnectionConfig;
import org.geotools.arcsde.session.Command;
import org.geotools.arcsde.session.Commands;
import org.geotools.arcsde.session.ISession;
import org.geotools.arcsde.session.SdeRow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Session
implements ISession {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.arcsde.pool");
    protected static final long TEST_SERVER_ROUNDTRIP_INTERVAL_SECONDS = 5L;
    private final SeConnection connection;
    private final ObjectPool pool;
    private final ArcSDEConnectionConfig config;
    private static int sessionCounter;
    private final int sessionId;
    private boolean transactionInProgress;
    private boolean isPassivated;
    private Map<String, SeTable> cachedTables = new WeakHashMap<String, SeTable>();
    private Map<String, SeLayer> cachedLayers = new WeakHashMap<String, SeLayer>();
    private final ExecutorService taskExecutor;
    private Thread commandThread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Session(ObjectPool pool, ArcSDEConnectionConfig config) throws IOException {
        this.config = config;
        this.pool = pool;
        this.taskExecutor = Executors.newSingleThreadExecutor();
        this.updateCommandThread();
        try {
            this.connection = this.issue(new CreateSessionCommand(config));
        }
        catch (IOException e) {
            this.taskExecutor.shutdownNow();
            throw e;
        }
        catch (RuntimeException shouldntHappen) {
            this.taskExecutor.shutdownNow();
            throw shouldntHappen;
        }
        Class<Session> clazz = Session.class;
        synchronized (Session.class) {
            this.sessionId = ++sessionCounter;
            // ** MonitorExit[var3_5] (shouldn't be in output)
            return;
        }
    }

    @Override
    public <T> T issue(final Command<T> command) throws IOException {
        Object result;
        Thread callingThread = Thread.currentThread();
        if (callingThread == this.commandThread) {
            try {
                return command.execute(this, this.connection);
            }
            catch (SeException e) {
                Throwable cause = e.getCause();
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                throw new ArcSdeException(e);
            }
        }
        FutureTask task = new FutureTask(new Callable<T>(){

            @Override
            public T call() throws Exception {
                Thread currentThread = Thread.currentThread();
                if (Session.this.commandThread != currentThread) {
                    LOGGER.fine("updating command thread from " + Session.this.commandThread + " to " + currentThread);
                    Session.this.commandThread = currentThread;
                }
                if (currentThread != Session.this.commandThread) {
                    throw new IllegalStateException("currentThread != commandThread");
                }
                try {
                    return command.execute(Session.this, Session.this.connection);
                }
                catch (Exception e) {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "Command execution failed for Session " + Session.this.sessionId + " in thread " + currentThread.getId(), e);
                    } else if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Command execution failed for Session " + Session.this.sessionId + " in thread " + currentThread.getId());
                    }
                    if (e instanceof SeException) {
                        throw new ArcSdeException((SeException)((Object)e));
                    }
                    if (e instanceof IOException) {
                        throw e;
                    }
                    throw new RuntimeException("Command execution failed for Session " + Session.this.sessionId + " in thread " + currentThread.getId(), e);
                }
            }
        });
        this.taskExecutor.execute(task);
        try {
            result = task.get();
        }
        catch (InterruptedException e) {
            this.updateCommandThread();
            throw new RuntimeException("Command execution abruptly interrupted", e);
        }
        catch (ExecutionException e) {
            this.updateCommandThread();
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof SeException) {
                throw new ArcSdeException((SeException)cause);
            }
            throw (IOException)new IOException().initCause(cause);
        }
        return (T)result;
    }

    private void updateCommandThread() {
        FutureTask<Object> task = new FutureTask<Object>(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Thread currentThread = Thread.currentThread();
                if (currentThread != Session.this.commandThread) {
                    LOGGER.fine("updating command thread from " + Session.this.commandThread + " to " + currentThread);
                    Session.this.commandThread = currentThread;
                }
                return null;
            }
        });
        this.taskExecutor.execute(task);
        try {
            task.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final void testServer() throws IOException {
        long secondsSinceLastServerRoundTrip = this.connection.getTimeSinceLastRT();
        if (5L < secondsSinceLastServerRoundTrip) {
            this.issue(new Command<Void>(){

                @Override
                public Void execute(ISession session, SeConnection connection) throws SeException, IOException {
                    connection.testServer(5L);
                    return null;
                }
            });
        }
    }

    @Override
    public final boolean isClosed() {
        return this.connection.isClosed();
    }

    void markActive() {
        this.isPassivated = false;
    }

    void markInactive() {
        this.isPassivated = true;
    }

    @Override
    public boolean isDisposed() {
        return this.isPassivated;
    }

    private void checkActive() {
        if (this.isDisposed()) {
            throw new IllegalStateException("Unrecoverable error: " + this.toString() + " is passivated, shall not be used!");
        }
    }

    @Override
    public SeLayer getLayer(final String layerName) throws IOException {
        SeLayer seLayer;
        this.checkActive();
        if (!this.cachedLayers.containsKey(layerName)) {
            this.issue(new Command<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void execute(ISession session, SeConnection connection) throws SeException, IOException {
                    Map map = Session.this.cachedLayers;
                    synchronized (map) {
                        if (!Session.this.cachedLayers.containsKey(layerName)) {
                            SeTable table = Session.this.getTable(layerName);
                            String shapeColumn = Session.this.getShapeColumn(table);
                            if (shapeColumn == null) {
                                return null;
                            }
                            SeLayer layer = new SeLayer(connection, layerName, shapeColumn);
                            Session.this.cachedLayers.put(layerName, layer);
                        }
                    }
                    return null;
                }
            });
        }
        if ((seLayer = this.cachedLayers.get(layerName)) == null) {
            throw new NoSuchElementException("Layer '" + layerName + "' not found");
        }
        return seLayer;
    }

    private String getShapeColumn(SeTable table) throws ArcSdeException {
        try {
            for (SeColumnDefinition aDef : table.describe()) {
                if (aDef.getType() != SeColumnDefinition.TYPE_SHAPE) continue;
                return aDef.getName();
            }
        }
        catch (SeException e) {
            throw new ArcSdeException("Exception describing table " + table.getName(), e);
        }
        return null;
    }

    @Override
    public synchronized SeRasterColumn getRasterColumn(String rasterName) throws IOException {
        throw new UnsupportedOperationException("Waiting for a proper implementation");
    }

    @Override
    public List<String> getRasterColumns() throws IOException {
        this.checkActive();
        List<String> rasterNames = this.issue(new Command<List<String>>(){

            @Override
            public List<String> execute(ISession session, SeConnection connection) throws SeException, IOException {
                Vector rasterColumns = connection.getRasterColumns();
                ArrayList<String> names = new ArrayList<String>(rasterColumns.size());
                for (SeRasterColumn col : rasterColumns) {
                    names.add(col.getQualifiedTableName());
                }
                return names;
            }
        });
        return rasterNames;
    }

    @Override
    public SeTable getTable(final String tableName) throws IOException {
        SeTable seTable;
        this.checkActive();
        if (!this.cachedTables.containsKey(tableName)) {
            this.issue(new Command<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void execute(ISession session, SeConnection connection) throws SeException, IOException {
                    Map map = Session.this.cachedTables;
                    synchronized (map) {
                        if (!Session.this.cachedTables.containsKey(tableName)) {
                            SeTable table = new SeTable(connection, tableName);
                            try {
                                table.describe();
                            }
                            catch (SeException e) {
                                throw new NoSuchElementException("Table '" + tableName + "' not found");
                            }
                            Session.this.cachedTables.put(tableName, table);
                        }
                    }
                    return null;
                }
            });
        }
        if ((seTable = this.cachedTables.get(tableName)) == null) {
            throw new NoSuchElementException("Table '" + tableName + "' not found");
        }
        return seTable;
    }

    @Override
    public void startTransaction() throws IOException {
        this.checkActive();
        this.issue(new Command<Void>(){

            @Override
            public Void execute(ISession session, SeConnection connection) throws SeException, IOException {
                connection.setTransactionAutoCommit(0);
                connection.startTransaction();
                Session.this.transactionInProgress = true;
                return null;
            }
        });
    }

    @Override
    public void commitTransaction() throws IOException {
        this.checkActive();
        this.issue(new Command<Void>(){

            @Override
            public Void execute(ISession session, SeConnection connection) throws SeException, IOException {
                connection.commitTransaction();
                return null;
            }
        });
        this.transactionInProgress = false;
    }

    @Override
    public boolean isTransactionActive() {
        this.checkActive();
        return this.transactionInProgress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollbackTransaction() throws IOException {
        this.checkActive();
        try {
            this.issue(new Command<Void>(){

                @Override
                public Void execute(ISession session, SeConnection connection) throws SeException, IOException {
                    connection.rollbackTransaction();
                    return null;
                }
            });
        }
        finally {
            this.transactionInProgress = false;
        }
    }

    @Override
    public void dispose() throws IllegalStateException {
        this.checkActive();
        if (this.transactionInProgress) {
            throw new IllegalStateException("Transaction is in progress, should commit or rollback before closing");
        }
        try {
            this.pool.returnObject((Object)this);
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("<-- " + this.toString() + " retured to pool. Active: " + this.pool.getNumActive() + ", idle: " + this.pool.getNumIdle());
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public String toString() {
        return "Session[" + this.sessionId + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy() {
        LOGGER.fine("Destroying connection " + this.toString());
        try {
            this.issue(new Command<Void>(){

                @Override
                public Void execute(ISession session, SeConnection connection) throws SeException, IOException {
                    connection.close();
                    LOGGER.fine(session.toString() + " successfully closed");
                    return null;
                }
            });
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "closing connection " + this.toString(), e);
        }
        finally {
            this.taskExecutor.shutdown();
        }
    }

    @Override
    public boolean equals(Object other) {
        return other == this;
    }

    @Override
    public int hashCode() {
        return 0x11 ^ this.config.hashCode();
    }

    @Override
    public List<SeLayer> getLayers() throws IOException {
        return this.issue(new Command<List<SeLayer>>(){

            @Override
            public List<SeLayer> execute(ISession session, SeConnection connection) throws SeException, IOException {
                return connection.getLayers();
            }
        });
    }

    @Override
    public String getUser() throws IOException {
        return this.issue(new Command<String>(){

            @Override
            public String execute(ISession session, SeConnection connection) throws SeException, IOException {
                return connection.getUser();
            }
        });
    }

    @Override
    public SeRelease getRelease() throws IOException {
        return this.issue(new Command<SeRelease>(){

            @Override
            public SeRelease execute(ISession session, SeConnection connection) throws SeException, IOException {
                return connection.getRelease();
            }
        });
    }

    @Override
    public String getDatabaseName() throws IOException {
        return this.issue(new Command<String>(){

            @Override
            public String execute(ISession session, SeConnection connection) throws SeException, IOException {
                return connection.getDatabaseName();
            }
        });
    }

    @Override
    public SeDBMSInfo getDBMSInfo() throws IOException {
        return this.issue(new Command<SeDBMSInfo>(){

            @Override
            public SeDBMSInfo execute(ISession session, SeConnection connection) throws SeException, IOException {
                return connection.getDBMSInfo();
            }
        });
    }

    @Override
    public SeLayer createSeLayer() throws IOException {
        return this.issue(new Command<SeLayer>(){

            @Override
            public SeLayer execute(ISession session, SeConnection connection) throws SeException, IOException {
                return new SeLayer(connection);
            }
        });
    }

    @Override
    public SeRegistration createSeRegistration(final String typeName) throws IOException {
        return this.issue(new Command<SeRegistration>(){

            @Override
            public SeRegistration execute(ISession session, SeConnection connection) throws SeException, IOException {
                return new SeRegistration(connection, typeName);
            }
        });
    }

    @Override
    public SeTable createSeTable(final String qualifiedName) throws IOException {
        return this.issue(new Command<SeTable>(){

            @Override
            public SeTable execute(ISession session, SeConnection connection) throws SeException, IOException {
                return new SeTable(connection, qualifiedName);
            }
        });
    }

    @Override
    public SeInsert createSeInsert() throws IOException {
        return this.issue(new Command<SeInsert>(){

            @Override
            public SeInsert execute(ISession session, SeConnection connection) throws SeException, IOException {
                return new SeInsert(connection);
            }
        });
    }

    @Override
    public SeUpdate createSeUpdate() throws IOException {
        return this.issue(new Command<SeUpdate>(){

            @Override
            public SeUpdate execute(ISession session, SeConnection connection) throws SeException, IOException {
                return new SeUpdate(connection);
            }
        });
    }

    @Override
    public SeDelete createSeDelete() throws IOException {
        return this.issue(new Command<SeDelete>(){

            @Override
            public SeDelete execute(ISession session, SeConnection connection) throws SeException, IOException {
                return new SeDelete(connection);
            }
        });
    }

    @Override
    public SeRasterColumn createSeRasterColumn() throws IOException {
        return this.issue(new Command<SeRasterColumn>(){

            @Override
            public SeRasterColumn execute(ISession session, SeConnection connection) throws SeException, IOException {
                return new SeRasterColumn(connection);
            }
        });
    }

    @Override
    public SeRasterColumn createSeRasterColumn(final SeObjectId rasterColumnId) throws IOException {
        return this.issue(new Command<SeRasterColumn>(){

            @Override
            public SeRasterColumn execute(ISession session, SeConnection connection) throws SeException, IOException {
                return new SeRasterColumn(connection, rasterColumnId);
            }
        });
    }

    @Override
    public SeColumnDefinition[] describe(String tableName) throws IOException {
        SeTable table = this.getTable(tableName);
        return this.describe(table);
    }

    @Override
    public SeColumnDefinition[] describe(final SeTable table) throws IOException {
        return this.issue(new Command<SeColumnDefinition[]>(){

            @Override
            public SeColumnDefinition[] execute(ISession session, SeConnection connection) throws SeException, IOException {
                return table.describe();
            }
        });
    }

    @Override
    public SdeRow fetch(SeQuery query) throws IOException {
        return this.fetch(query, new SdeRow((GeometryFactory)null));
    }

    @Override
    public SdeRow fetch(final SeQuery query, final SdeRow currentRow) throws IOException {
        return this.issue(new Command<SdeRow>(){

            @Override
            public SdeRow execute(ISession session, SeConnection connection) throws SeException, IOException {
                SeRow row = query.fetch();
                if (row == null) {
                    return null;
                }
                currentRow.setRow(row);
                return currentRow;
            }
        });
    }

    @Override
    public void close(final SeState state) throws IOException {
        this.issue(new Command<Void>(){

            @Override
            public Void execute(ISession session, SeConnection connection) throws SeException, IOException {
                state.close();
                return null;
            }
        });
    }

    @Override
    public void close(final SeStreamOp stream) throws IOException {
        this.issue(new Command<Void>(){

            @Override
            public Void execute(ISession session, SeConnection connection) throws SeException, IOException {
                stream.close();
                return null;
            }
        });
    }

    @Override
    public SeState createState(final SeObjectId stateId) throws IOException {
        return this.issue(new Command<SeState>(){

            @Override
            public SeState execute(ISession session, SeConnection connection) throws SeException, IOException {
                return new SeState(connection, stateId);
            }
        });
    }

    @Override
    public SeQuery createSeQuery() throws IOException {
        return this.issue(new Command<SeQuery>(){

            @Override
            public SeQuery execute(ISession session, SeConnection connection) throws SeException, IOException {
                return new SeQuery(connection);
            }
        });
    }

    @Override
    public SeQuery createSeQuery(final String[] propertyNames, final SeSqlConstruct sql) throws IOException {
        return this.issue(new Command<SeQuery>(){

            @Override
            public SeQuery execute(ISession session, SeConnection connection) throws SeException, IOException {
                return new SeQuery(connection, propertyNames, sql);
            }
        });
    }

    @Override
    public SeQuery createAndExecuteQuery(final String[] propertyNames, final SeSqlConstruct sql) throws IOException {
        return this.issue(new Command<SeQuery>(){

            @Override
            public SeQuery execute(ISession session, SeConnection connection) throws SeException, IOException {
                SeQuery query = new SeQuery(connection, propertyNames, sql);
                query.prepareQuery();
                query.execute();
                return query;
            }
        });
    }

    @Override
    public SeVersion getDefaultVersion() throws IOException {
        return this.issue(new Commands.GetVersionCommand(SeVersion.SE_QUALIFIED_DEFAULT_VERSION_NAME));
    }

    @Override
    public SeState createChildState(final long parentStateId) throws IOException {
        return this.issue(new Command<SeState>(){

            @Override
            public SeState execute(ISession session, SeConnection connection) throws SeException, IOException {
                SeState parentState = new SeState(connection, new SeObjectId(parentStateId));
                SeState realParent = null;
                boolean mergeParentToRealParent = false;
                if (parentState.isOpen()) {
                    try {
                        parentState.close();
                        realParent = parentState;
                    }
                    catch (SeException e) {
                        int errorCode = e.getSeError().getSdeError();
                        if (SeError.SE_STATE_INUSE == errorCode || SeError.SE_NO_PERMISSIONS == errorCode) {
                            realParent = new SeState(connection, parentState.getParentId());
                            mergeParentToRealParent = true;
                        }
                        throw e;
                    }
                } else {
                    realParent = parentState;
                }
                SeState newState = new SeState(connection);
                newState.create(realParent.getId());
                if (mergeParentToRealParent) {
                    newState.merge(realParent.getId(), parentState.getId());
                }
                return newState;
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CreateSessionCommand
    extends Command<SeConnection> {
        private final ArcSDEConnectionConfig config;

        private CreateSessionCommand(ArcSDEConnectionConfig config) {
            this.config = config;
        }

        @Override
        public SeConnection execute(ISession session, SeConnection connection) throws SeException, IOException {
            SeConnection conn;
            String serverName = this.config.getServerName();
            int portNumber = this.config.getPortNumber();
            String databaseName = this.config.getDatabaseName();
            String userName = this.config.getUserName();
            String userPassword = this.config.getPassword();
            try {
                conn = new SeConnection(serverName, portNumber, databaseName, userName, userPassword);
            }
            catch (SeException e) {
                throw new ArcSdeException("Can't create connection to " + serverName, e);
            }
            catch (RuntimeException e) {
                throw (IOException)new IOException("Can't create connection to " + serverName).initCause(e);
            }
            conn.setConcurrency(SeConnection.SE_ONE_THREAD_POLICY);
            return conn;
        }
    }
}

