package org.tecgraf.tdk.cache;

import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.tecgraf.tdk.cache.query.QueryAnalyzer;

/**
 * 
 * @author fmoura
 *
 * @param <T>
 * @param <F>
 */
public interface CachingFeatureAccessFactory<T extends FeatureType, F extends Feature> 
{
	
	FeatureCacher<T,F> createFeatureCacher(T schema);
	
	CachingFeatureSource<T,F> createFeatureSource(FeatureSource<T,F> featureSource, FeatureCacher<T,F> featureCacher);
	
	CachingFeatureStore<T,F> createFeatureStore(FeatureStore<T,F> featureStore, FeatureCacher<T,F> featureCacher);
	
	QueryAnalyzer createQueryAnalyzer(Query query);

	CachingFeatureReader<T,F> createFeatureReader(Query query, FeatureCacher<T,F> featureCacher);
	
	FeatureWriter<SimpleFeatureType, SimpleFeature> createFeatureWriter(FeatureWriter<SimpleFeatureType, SimpleFeature> wrappedFeatureWriter, FeatureCacher<SimpleFeatureType,SimpleFeature> featureCacher);
}
