/**
 * Tecgraf - GIS development team
 * 
 * Tdk Framework
 * Copyright TecGraf 2009(c).
 * 
 * file: CachingFeatureSource.java
 * created: May 21, 2009
 */
package org.tecgraf.tdk.cache;

import java.awt.RenderingHints.Key;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

import org.apache.log4j.Logger;
import org.geotools.data.DataAccess;
import org.geotools.data.DataSourceException;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.ResourceInfo;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.tecgraf.tdk.cache.query.DefaultQueryAnalyzer;
import org.tecgraf.tdk.cache.query.QueryAnalyzer;

/**
 * Caching feature source is a FeatureSorce decorator that implements a memory cache.
 * It caches all feature accessed using a JTS SpatialIndex, and when it is read again 
 * tries first to locate it within the memory cached feature for fast access.
 * Forward the methods that do not involve feature access to the decorated FeatureSource, 
 * @author fabiomano, milton, fmoura
 * @since TDK3.0.0
 */
public class SimpleCachingFeatureSource implements CachingFeatureSource<SimpleFeatureType,SimpleFeature>
{
    private static Logger _logger = Logger.getLogger(SimpleCachingFeatureSource.class);
    
    private FeatureSource<SimpleFeatureType, SimpleFeature> _wrapped;
    
    private ReferencedEnvelope _wrappedFeatureSourceBounds;
    
    //private SimpleFeatureType _cachedSchema;
    
    //private SpatialIndex _index;
    
    //private boolean _dirty;  //flag to check if the cache is dirty (and needs to be filled again)
    
    //private Query _cachedQuery;
    
    //private ReferencedEnvelope _cachedBounds;

	private FeatureCacher<SimpleFeatureType, SimpleFeature> _cacher;
    
    //TODO: FilterFactory2?
    //private static FilterFactory ff = CommonFactoryFinder.getFilterFactory(GeoTools.getDefaultHints());
 
    public SimpleCachingFeatureSource(FeatureSource<SimpleFeatureType, SimpleFeature> original,FeatureCacher<SimpleFeatureType, SimpleFeature> cacher) 
    {
    	if(original == null) throw new IllegalArgumentException("original can't be null");
    	if(cacher == null) throw new IllegalArgumentException("cacher can't be null");
        _wrapped = original;
        _cacher = cacher;
       // _wrappedFeatureSourceBounds = original.getBounds();
        
//        if (_wrappedFeatureSourceBounds == null)
//            _wrappedFeatureSourceBounds = new ReferencedEnvelope(-Double.MAX_VALUE, Double.MAX_VALUE
//                    , -Double.MAX_VALUE, Double.MAX_VALUE
//                    ,original.getSchema().getCoordinateReferenceSystem());
    }
    
    /* (non-Javadoc)
     * @see org.geotools.data.FeatureSource#addFeatureListener(org.geotools.data.FeatureListener)
     */
    @Override
    public void addFeatureListener(FeatureListener listener)
    {
        _wrapped.addFeatureListener(listener);
    }
    
    /* (non-Javadoc)
     * @see org.geotools.data.FeatureSource#removeFeatureListener(org.geotools.data.FeatureListener)
     */
    @Override
    public void removeFeatureListener(FeatureListener listener)
    {
        _wrapped.removeFeatureListener(listener);
    }
    
    /* (non-Javadoc)
     * @see org.geotools.data.FeatureSource#getDataStore()
     */
    @Override
    public DataAccess<SimpleFeatureType, SimpleFeature> getDataStore()
    {
        return _wrapped.getDataStore();
    }
    
    /* (non-Javadoc)
     * @see org.geotools.data.FeatureSource#getBounds()
     */
    @Override
    public ReferencedEnvelope getBounds() throws IOException
    {
        return _wrapped.getBounds();
    }
    
    /* (non-Javadoc)
     * @see org.geotools.data.FeatureSource#getBounds(org.geotools.data.Query)
     */
    @Override
    public ReferencedEnvelope getBounds(Query query) throws IOException
    {
        return _wrapped.getBounds(query);
    }
    
    /* (non-Javadoc)
     * @see org.geotools.data.FeatureSource#getCount(org.geotools.data.Query)
     */
    @Override
    public int getCount(Query query) throws IOException
    {
        return _wrapped.getCount(query);
    }
    
    /* (non-Javadoc)
     * @see org.geotools.data.FeatureSource#getSchema()
     */
    @Override
    public SimpleFeatureType getSchema()
    {
        return _wrapped.getSchema();
    }
    
    /* (non-Javadoc)
     * @see org.geotools.data.FeatureSource#getFeatures()
     */
    @Override
    public FeatureCollection<SimpleFeatureType, SimpleFeature> getFeatures() throws IOException
    {
        return getFeatures(Filter.INCLUDE);
    }
    
    /* (non-Javadoc)
     * @see org.geotools.data.FeatureSource#getFeatures(org.opengis.filter.Filter)
     */
    @Override
    public FeatureCollection<SimpleFeatureType, SimpleFeature> getFeatures(Filter filter) throws IOException
    {
        return getFeatures(new DefaultQuery(_wrapped.getSchema().getName().getLocalPart(), filter));
    }
    
    /* (non-Javadoc)
     * @see org.geotools.data.FeatureSource#getFeatures(org.geotools.data.Query)
     */
    @Override
    public FeatureCollection<SimpleFeatureType, SimpleFeature> getFeatures(Query query) throws IOException
    {
    	QueryAnalyzer queryAnalyzer = new DefaultQueryAnalyzer(_cacher.getCachedQuery());
        if (query.getTypeName() != null
                && !_wrapped.getSchema().getTypeName().equals(query.getTypeName())) 
        {
            throw new DataSourceException("Typename mismatch, query asks for '"
                    + query.getTypeName() + " but this feature source provides '"
                    + _wrapped.getSchema().getTypeName() + "'");
        }

//        if (_index == null || _dirty || !isSubQuery(query)) 
//        {
//            fillCache(query);
//        }
        
        if(!queryAnalyzer.isSubQuery(query))
        {
        	fillCacher(query);
        }
        
        return _cacher.get(query);

        //return getFeatureCollection(query, getEnvelope(query.getFilter()));        
    }
    
//    private FeatureCollection<SimpleFeatureType, SimpleFeature> getFeatureCollection(Query query, Envelope bounds) throws IOException 
//    {
//        try 
//        {
//            SimpleFeatureType alternate = _cachedSchema;
//            if (query.getPropertyNames() != Query.ALL_NAMES) 
//            {
//                alternate = DataUtilities.createSubType(_cachedSchema, query.getPropertyNames());
//                if (alternate.equals(_cachedSchema))
//                    alternate = _cachedSchema;
//            }
//
//            Filter f = query.getFilter();
//            if (f != null && f.equals(Filter.INCLUDE))
//                f = null;
//
//            List<SimpleFeature> featureList = _index.query(bounds);
//            SimpleFeature[] features = (SimpleFeature[]) featureList.toArray(new SimpleFeature[featureList.size()]);
//            FeatureCollection<SimpleFeatureType, SimpleFeature> collection = FeatureCollections.newCollection();
//            
//            for (int i = 0; i < features.length; i++) 
//            {
//                SimpleFeature curr = features[i];
//                
//                if (f != null && !f.evaluate(curr)) 
//                    continue;
//
//                if (alternate != _cachedSchema)
//                    curr = DataUtilities.reType(alternate, curr);
//
//                collection.add(curr);
//            }
//            
//            if (collection.size() == 0)
//                return new EmptyFeatureCollection( _cachedSchema );
////            FeatureCollection<SimpleFeatureType, SimpleFeature> collection = new DefaultFeatureResults(this, query);
//            return collection;
//        } 
//        catch (Exception e) 
//        {
//            throw new DataSourceException(
//                    "Error occurred extracting features from the spatial index", e);
//        }
//    }    
    
//    private void fillCache(Query query) throws IOException 
//    {
//        _logger.debug("Refilling cache from " + query);
////        System.out.println("Refilling cache from " + query);
//        FeatureCollection<SimpleFeatureType, SimpleFeature> features = _wrapped.getFeatures(query);
//        FeatureIterator<SimpleFeature> fi = features.features();
//        _index = null;
//        Quadtree newIndex = new Quadtree();
//        while (fi.hasNext()) 
//        {
//            // consider turning all geometries into packed ones, to save space
//            Feature f = fi.next();
//            newIndex.insert(new ReferencedEnvelope(f.getBounds()), f);
//        }
//        fi.close();
//        _index = newIndex;
//        _cachedQuery = query;
//        _cachedSchema = features.getSchema();
//        _cachedBounds = getEnvelope(query.getFilter());
//        _dirty = false;
//    }
    
//    protected boolean isSubQuery(Query query)
//    {
//        // no cached data?
//        if (_cachedQuery == null)
//            return false;
//
//        // do we miss some properties?
//        String[] cachedPropNames = _cachedQuery.getPropertyNames();
//        String[] propNames = query.getPropertyNames();
//        if (cachedPropNames != Query.ALL_NAMES
//                && (propNames == Query.ALL_NAMES || !Arrays.asList(cachedPropNames).containsAll(
//                        Arrays.asList(propNames))))
//            return false;
//
//        Filter[] filters = splitFilters(query);
//        Filter[] cachedFilters = splitFilters(_cachedQuery);
//        
//        if ((_cachedQuery.getFilter() != Filter.INCLUDE)
//        && (!filters[0].equals(cachedFilters[0])))
//            return false;
//
//        Envelope envelope = getEnvelope(filters[1]);
//        
//        if (_wrappedFeatureSourceBounds.contains(envelope))
//            return _cachedBounds.contains(envelope);
//        else
//            return true;
//    }    
    
//    /**
//     * Splits a query into two parts, a spatial component that can be turned into a bbox filter (by
//     * including some more feature in the result) and a residual component that we cannot address
//     * with the spatial index
//     *
//     * @param query
//     */
//    protected Filter[] splitFilters(Query query) 
//    {
//        Filter filter = query.getFilter();
//        if (filter == null || filter.equals(Filter.EXCLUDE)) {
//            return new Filter[] { Filter.EXCLUDE, bboxFilter(_wrappedFeatureSourceBounds) };
//        }
//
//        if (!(filter instanceof And)) {
//            ReferencedEnvelope envelope = getEnvelope(filter);
//            if (envelope == null)
//                return new Filter[] { Filter.EXCLUDE, bboxFilter(_wrappedFeatureSourceBounds) };
//            else
//                return new Filter[] { Filter.EXCLUDE, bboxFilter(envelope) };
//        }
//
//        And and = (And) filter;
//        List<Filter> residuals = new ArrayList<Filter>();
//        List<Filter> bboxBacked = new ArrayList<Filter>();
//        for (Iterator<Filter> it = and.getChildren().iterator(); it.hasNext();) {
//            Filter child = it.next();
//            if (getEnvelope(child) != null) {
//                bboxBacked.add(child);
//            } else {
//                residuals.add(child);
//            }
//        }
//
//        return new Filter[] { (Filter) ff.and(residuals), (Filter) ff.and(bboxBacked) };
//    }    
     
//    private BBOX bboxFilter(ReferencedEnvelope bbox) 
//    {
//        BBOX gf = ff.bbox(_wrapped.getSchema().getGeometryDescriptor().getLocalName()
//                , bbox.getMinX(), bbox.getMinY(), bbox.getMaxX(), bbox.getMaxY()
//                , CRS.toSRS(bbox.getCoordinateReferenceSystem()));
//
//        return gf;
//    }    
    
//    protected ReferencedEnvelope getEnvelope(Filter filter) 
//    {
//        Envelope result = _wrappedFeatureSourceBounds;
//        if (filter instanceof And) 
//        {
//            ReferencedEnvelope bounds = new ReferencedEnvelope();
//            for (Iterator<Filter> iter = ((And) filter).getChildren().iterator(); iter.hasNext();) 
//            {
//                Filter f = (Filter) iter.next();
//                ReferencedEnvelope e = getEnvelope(f);
//                if (e == null)
//                    return null;
//                else
//                    bounds.expandToInclude(e);
//            }
//            result = bounds;
//        } 
//        else if (filter instanceof BinarySpatialOperator) 
//        {
//            BinarySpatialOperator gf = (BinarySpatialOperator) filter;
//            if (filterIsSupported(gf))
//            {
//                Expression lg = gf.getExpression1();
//                Expression rg = gf.getExpression2();
//                if (lg instanceof Literal)
//                {
//                    Geometry g = (Geometry) ((Literal) lg).getValue();
//                    if (rg instanceof PropertyName)
//                        result = g.getEnvelopeInternal();
//                } 
//                else if (rg instanceof Literal) 
//                {
//                    Geometry g = (Geometry) ((Literal) rg).getValue();
//                    if (lg instanceof PropertyName)
//                        result = g.getEnvelopeInternal();
//                }
//            }
//        }
//        
//        return new ReferencedEnvelope(result.intersection(_wrappedFeatureSourceBounds),_wrappedFeatureSourceBounds.getCoordinateReferenceSystem());
//    }

//    /**
//     * Checks if the filter is within the supported types.
//     * @param f the filter to check.
//     * @return
//     */
//    private boolean filterIsSupported(BinarySpatialOperator f)
//    {
//        if ((f instanceof BBOX)
//            || (f instanceof Contains)
//            || (f instanceof Crosses)
//            || (f instanceof DWithin)
//            || (f instanceof Equals)
//            || (f instanceof Intersects)
//            || (f instanceof Overlaps)
//            || (f instanceof Touches)
//            || (f instanceof Within)
//            )
//            return true;
//        else
//            return false;
//    }

    /* (non-Javadoc)
     * @see org.geotools.data.FeatureSource#getInfo()
     */
    @Override
    public ResourceInfo getInfo()
    {
        return _wrapped.getInfo();
    }

    /* (non-Javadoc)
     * @see org.geotools.data.FeatureSource#getName()
     */
    @Override
    public Name getName()
    {
        return _wrapped.getName();
    }

    /* (non-Javadoc)
     * @see org.geotools.data.FeatureSource#getQueryCapabilities()
     */
    @Override
    public QueryCapabilities getQueryCapabilities()
    {
        return _wrapped.getQueryCapabilities();
    }

    /* (non-Javadoc)
     * @see org.geotools.data.FeatureSource#getSupportedHints()
     */
    @Override
    public Set<Key> getSupportedHints()
    {
    	Set<Key> cachingFeatureSourceHints = new HashSet<Key>(_wrapped.getSupportedHints());
    	cachingFeatureSourceHints.remove(Hints.FEATURE_DETACHED);
        return cachingFeatureSourceHints;
    }
    
//    /**
//     * Adds a new feature to this Feature Source internal cache.
//     * @param feature Feature to be added to cache.
//     */
//    protected void addFeature(Feature feature)
//    {
//    	//_index.insert(new ReferencedEnvelope(feature.getBounds()), feature);
//    }
    
//    /**
//     * Update a feature already in this Feature Source internal cache.
//     * @param feature Feature to be updated in cache.
//     */
//    protected void updateFeature(Feature feature,Envelope oldBounds)
//    {
//    	List<Feature> features = _index.query(oldBounds);
//    	for(Feature indexedFeature : features)
//    	{
//    		if(indexedFeature.getIdentifier().equals(feature.getIdentifier()))
//    		{
//    			//indexedFeature.setValue(feature.getProperties());
//    			//or 
//    			_index.remove(new ReferencedEnvelope(indexedFeature.getBounds()), indexedFeature);
//    			_index.insert(new ReferencedEnvelope(feature.getBounds()), feature);
//    			break;
//    		}
//    	}
//    }
    
//    /** 
//     * Removes a feature from this Feature Source internal cache.
//     * @param feature
//     */
//    protected void removeFeature(Feature feature)
//    {
//    	_index.remove(new ReferencedEnvelope(feature.getBounds()), feature);
//    }
//
	@Override
	public void clear() {
		_cacher.clear();
	}

	@Override
	public void reload() throws IOException {
//		try {
//			fillCache(_cachedQuery);
//		} catch (IOException e) {
//			e.printStackTrace();
//		}
		Query cachedQuery = _cacher.getCachedQuery();
		_cacher.clear();
		fillCacher(cachedQuery);
	}

	private void fillCacher(Query query) throws IOException {
		Query includeAllQuery = new DefaultQuery(query.getTypeName(),Filter.INCLUDE);
		_cacher.add(_wrapped.getFeatures(includeAllQuery),includeAllQuery);
	}
}
