/**
 * Tecgraf - GIS development team
 * 
 * Tdk Framework
 * Copyright TecGraf 2009(c).
 * 
 * file: SimpleCachingFeatureWriter.java
 * created: Jul 13, 2009
 */
package org.tecgraf.tdk.cache;

import java.io.IOException;

import org.geotools.data.FeatureWriter;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

/**
 * Feature Writer decorator for the cache. Let's the decorated feature
 * writer handles insert, remove or update, but update the cache  
 * when it happens 
 * @since TDK3.0.0
 * @author fabiomano
 */
public class SimpleCachingFeatureWriter implements CachingFeatureWriter<SimpleFeatureType, SimpleFeature>
{
    private FeatureWriter<SimpleFeatureType, SimpleFeature> _writer;
    private FeatureCacher<SimpleFeatureType, SimpleFeature> _cacher;
    
    private SimpleFeature _currentFeature;
    boolean _insert = false;
    
    public SimpleCachingFeatureWriter(FeatureWriter<SimpleFeatureType, SimpleFeature> writer, FeatureCacher<SimpleFeatureType, SimpleFeature> cacher)
    {
        if (writer == null)
            throw new IllegalArgumentException("writer can't be null");

        if (cacher == null)
            throw new IllegalArgumentException("cacher can't be null");
        
        _writer = writer;
        _cacher = cacher;
    }
    
    
    /* (non-Javadoc)
     * @see org.geotools.data.FeatureWriter#close()
     */
    @Override
    public void close() throws IOException
    {
        _writer.close();
    }

    /* (non-Javadoc)
     * @see org.geotools.data.FeatureWriter#getFeatureType()
     */
    @Override
    public SimpleFeatureType getFeatureType()
    {
        return _writer.getFeatureType();
    }

    /* (non-Javadoc)
     * @see org.geotools.data.FeatureWriter#hasNext()
     */
    @Override
    public boolean hasNext() throws IOException
    {
        return _writer.hasNext();
    }

    /* (non-Javadoc)
     * @see org.geotools.data.FeatureWriter#next()
     */
    @Override
    public SimpleFeature next() throws IOException
    {
        if (!hasNext())
            _insert = true;
        else
            _insert = false;
        _currentFeature = _writer.next(); 
        return _currentFeature;
    }

    /* (non-Javadoc)
     * @see org.geotools.data.FeatureWriter#remove()
     */
    @Override
    public void remove() throws IOException
    {
        _writer.remove();
        _cacher.remove(_currentFeature);
    }

    /* (non-Javadoc)
     * @see org.geotools.data.FeatureWriter#write()
     */
    @Override
    public void write() throws IOException
    {
        _writer.write();
        if (_insert)
            _cacher.add(_currentFeature);
        else
            _cacher.update(_currentFeature);
    }

}
