package org.tecgraf.tdk.cache.query;

import org.geotools.data.Query;

import com.vividsolutions.jts.geom.Envelope;

/**
 * This interface a set of classes that helps processing a {@link Query}.
 * @author fmoura
 *
 */
public interface QueryAnalyzer 
{
	/**
	 * Verifies if the given {@link Query} is a sub-query of the original query.
	 * @param query The {@link Query} to be tested against the original query.
	 * @return true if the given {@link Query} is a sub-query of the original one, and false otherwise.
	 */
	boolean isSubQuery(Query query);
	
	/**
	 * Returns a query representing the part of the given query that is not already covered by the original query.
	 * @param query The {@link Query} to be tested against the original query.
	 * @return A query representing the part of the given query that is not already covered by the original query.
	 */
	Query getResidue(Query query);
	
	/**
	 * Returns the envelope that represents the spatial part of the original query.
	 * @return
	 */
	Envelope getEnvelope();
	
	
	/**
	 * Returns the original query
	 * @return the original query.
	 */
	Query getQuery();
	
	/**
	 * Sets the original query.
	 * @param query The {@link Query} to be set as the original query.
	 */
	void setQuery(Query query);
	

}
