/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.tdk.cache;

import java.awt.RenderingHints;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.geotools.data.DataAccess;
import org.geotools.data.DataSourceException;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.ResourceInfo;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.tecgraf.tdk.cache.CachingFeatureSource;
import org.tecgraf.tdk.cache.FeatureCacher;
import org.tecgraf.tdk.cache.query.DefaultQueryAnalyzer;

public class SimpleCachingFeatureSource
implements CachingFeatureSource<SimpleFeatureType, SimpleFeature> {
    private static Logger _logger = Logger.getLogger(SimpleCachingFeatureSource.class);
    private FeatureSource<SimpleFeatureType, SimpleFeature> _wrapped;
    private ReferencedEnvelope _wrappedFeatureSourceBounds;
    private FeatureCacher<SimpleFeatureType, SimpleFeature> _cacher;

    public SimpleCachingFeatureSource(FeatureSource<SimpleFeatureType, SimpleFeature> original, FeatureCacher<SimpleFeatureType, SimpleFeature> cacher) {
        if (original == null) {
            throw new IllegalArgumentException("original can't be null");
        }
        if (cacher == null) {
            throw new IllegalArgumentException("cacher can't be null");
        }
        this._wrapped = original;
        this._cacher = cacher;
    }

    public void addFeatureListener(FeatureListener listener) {
        this._wrapped.addFeatureListener(listener);
    }

    public void removeFeatureListener(FeatureListener listener) {
        this._wrapped.removeFeatureListener(listener);
    }

    public DataAccess<SimpleFeatureType, SimpleFeature> getDataStore() {
        return this._wrapped.getDataStore();
    }

    public ReferencedEnvelope getBounds() throws IOException {
        return this._wrapped.getBounds();
    }

    public ReferencedEnvelope getBounds(Query query) throws IOException {
        return this._wrapped.getBounds(query);
    }

    public int getCount(Query query) throws IOException {
        return this._wrapped.getCount(query);
    }

    public SimpleFeatureType getSchema() {
        return (SimpleFeatureType)this._wrapped.getSchema();
    }

    public FeatureCollection<SimpleFeatureType, SimpleFeature> getFeatures() throws IOException {
        return this.getFeatures((Filter)Filter.INCLUDE);
    }

    public FeatureCollection<SimpleFeatureType, SimpleFeature> getFeatures(Filter filter) throws IOException {
        return this.getFeatures((Query)new DefaultQuery(((SimpleFeatureType)this._wrapped.getSchema()).getName().getLocalPart(), filter));
    }

    public FeatureCollection<SimpleFeatureType, SimpleFeature> getFeatures(Query query) throws IOException {
        DefaultQueryAnalyzer queryAnalyzer = new DefaultQueryAnalyzer(this._cacher.getCachedQuery());
        if (query.getTypeName() != null && !((SimpleFeatureType)this._wrapped.getSchema()).getTypeName().equals(query.getTypeName())) {
            throw new DataSourceException("Typename mismatch, query asks for '" + query.getTypeName() + " but this feature source provides '" + ((SimpleFeatureType)this._wrapped.getSchema()).getTypeName() + "'");
        }
        if (!queryAnalyzer.isSubQuery(query)) {
            this.fillCacher(query);
        }
        return this._cacher.get(query);
    }

    public ResourceInfo getInfo() {
        return this._wrapped.getInfo();
    }

    public Name getName() {
        return this._wrapped.getName();
    }

    public QueryCapabilities getQueryCapabilities() {
        return this._wrapped.getQueryCapabilities();
    }

    public Set<RenderingHints.Key> getSupportedHints() {
        HashSet<RenderingHints.Key> cachingFeatureSourceHints = new HashSet<RenderingHints.Key>(this._wrapped.getSupportedHints());
        cachingFeatureSourceHints.remove(Hints.FEATURE_DETACHED);
        return cachingFeatureSourceHints;
    }

    @Override
    public void clear() {
        this._cacher.clear();
    }

    @Override
    public void reload() throws IOException {
        Query cachedQuery = this._cacher.getCachedQuery();
        this._cacher.clear();
        this.fillCacher(cachedQuery);
    }

    private void fillCacher(Query query) throws IOException {
        DefaultQuery includeAllQuery = new DefaultQuery(query.getTypeName(), (Filter)Filter.INCLUDE);
        this._cacher.add((FeatureCollection<SimpleFeatureType, SimpleFeature>)this._wrapped.getFeatures((Query)includeAllQuery), (Query)includeAllQuery);
    }
}

