/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.caching.grid.featurecache.readers;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;
import org.geotools.caching.grid.spatialindex.GridData;
import org.geotools.caching.grid.spatialindex.GridNode;
import org.geotools.caching.grid.spatialindex.GridRootNode;
import org.geotools.caching.grid.spatialindex.GridSpatialIndex;
import org.geotools.caching.spatialindex.NodeIdentifier;
import org.geotools.data.FeatureReader;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridCacheFeatureReader
implements FeatureReader<SimpleFeatureType, SimpleFeature> {
    private Stack<NodeIdentifier> tovisit = new Stack();
    private Iterator<GridData> currentNodeIterator = null;
    private GridSpatialIndex grid;
    private SimpleFeature next;
    private HashSet<String> collectedFeatureIds;

    public GridCacheFeatureReader(Collection<NodeIdentifier> nodeids, GridSpatialIndex g) {
        this.grid = g;
        this.collectedFeatureIds = new HashSet();
        GridRootNode gn = g.getRootNode();
        this.tovisit.add(gn.getIdentifier());
        if (nodeids != null) {
            for (NodeIdentifier id : nodeids) {
                if (!id.isValid()) continue;
                this.tovisit.add(id);
            }
            this.init();
        }
    }

    public void close() throws IOException {
        this.tovisit.clear();
        this.tovisit = null;
        this.currentNodeIterator = null;
        this.next = null;
        this.grid = null;
    }

    public SimpleFeatureType getFeatureType() {
        if (this.grid.getStorage().getFeatureTypes().size() == 0) {
            return null;
        }
        return (SimpleFeatureType)this.grid.getStorage().getFeatureTypes().iterator().next();
    }

    public boolean hasNext() throws IOException {
        return this.next != null;
    }

    private void init() {
        this.currentNodeIterator = null;
        this.next = this.findNext();
    }

    private SimpleFeature findNext() {
        SimpleFeature sf = null;
        while (this.currentNodeIterator == null || !this.currentNodeIterator.hasNext() || this.collectedFeatureIds.contains((sf = (SimpleFeature)this.currentNodeIterator.next().getData()).getID())) {
            if (this.currentNodeIterator != null && this.currentNodeIterator.hasNext()) continue;
            if (this.tovisit.size() == 0) {
                return null;
            }
            NodeIdentifier nodeid = this.tovisit.pop();
            GridNode currentNode = (GridNode)this.grid.readNode(nodeid);
            this.currentNodeIterator = currentNode.getData().iterator();
        }
        if (sf != null) {
            this.collectedFeatureIds.add(sf.getID());
        }
        return sf;
    }

    public SimpleFeature next() throws IOException, IllegalArgumentException, NoSuchElementException {
        SimpleFeature current = this.next;
        this.next = this.findNext();
        if (current == null) {
            throw new NoSuchElementException("Invalid call; no more feature here.");
        }
        return current;
    }
}

