/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io.mosaic;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.image.io.mosaic.FilenameFormatter;
import org.geotools.image.io.mosaic.Tile;
import org.geotools.resources.UnmodifiableArrayList;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.FrequencySortedSet;
import org.geotools.util.IntegerList;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class OverviewLevel
implements Comparable<OverviewLevel>,
Serializable {
    private static final long serialVersionUID = -1441934881339348L;
    private static final Set<Class<?>> INPUT_TYPES = new HashSet(8);
    private OverviewLevel finer;
    private int ordinal;
    private int nx;
    private int ny;
    private final int xSubsampling;
    private final int ySubsampling;
    private final int xOffset;
    private final int yOffset;
    private final int dx;
    private final int dy;
    private final Rectangle mosaic;
    private List<Tile> tiles;
    private Tile[] patterns;
    private IntegerList patternUsed;
    private transient Tile sample;
    private transient int lastPattern;
    private transient FilenameFormatter formatter;

    OverviewLevel(Tile pattern, Rectangle region) throws IOException {
        Dimension subsampling = pattern.getSubsampling();
        Rectangle tile = pattern.getRegion();
        this.mosaic = region = new Rectangle(region);
        this.dx = tile.width;
        int x = tile.x % this.dx;
        this.dy = tile.height;
        int y = tile.y % this.dy;
        if (x < 0) {
            x += this.dx;
        }
        if (y < 0) {
            y += this.dy;
        }
        this.xOffset = x;
        this.yOffset = y;
        this.xSubsampling = subsampling.width;
        this.ySubsampling = subsampling.height;
        this.patterns = new Tile[]{pattern};
    }

    OverviewLevel(Tile tile, Dimension subsampling) throws IOException {
        this.mosaic = tile.getRegion();
        this.dx = this.mosaic.width;
        int x = this.mosaic.x % this.dx;
        this.dy = this.mosaic.height;
        int y = this.mosaic.y % this.dy;
        if (x < 0) {
            x += this.dx;
        }
        if (y < 0) {
            y += this.dy;
        }
        this.xOffset = x;
        this.yOffset = y;
        assert (subsampling.equals(tile.getSubsampling())) : subsampling;
        this.xSubsampling = subsampling.width;
        this.ySubsampling = subsampling.height;
        this.tiles = new ArrayList<Tile>();
        this.tiles.add(tile);
    }

    final void add(Tile tile, Dimension subsampling) throws IOException, IllegalArgumentException {
        assert (subsampling.equals(tile.getSubsampling())) : subsampling;
        assert (subsampling.width == this.xSubsampling && subsampling.height == this.ySubsampling) : subsampling;
        Rectangle toAdd = tile.getRegion();
        if (toAdd.width > this.dx || toAdd.height > this.dy) {
            throw new IllegalArgumentException(Errors.format((int)175));
        }
        int ox = toAdd.x % this.dx;
        int oy = toAdd.y % this.dy;
        if (ox < 0) {
            ox += this.dx;
        }
        if (oy < 0) {
            oy += this.dy;
        }
        if ((ox -= this.xOffset) < 0 || ox + toAdd.width > this.dx || (oy -= this.yOffset) < 0 || oy + toAdd.height > this.dy) {
            throw new IllegalArgumentException(Errors.format((int)121));
        }
        this.mosaic.add(toAdd);
        this.tiles.add(tile);
    }

    final void createLinkedList(int ordinal, OverviewLevel finer) throws MalformedURLException {
        this.ordinal = ordinal;
        this.finer = finer;
        assert (this.getFinerLevel() == finer);
        this.nx = (this.mosaic.width + (this.dx - 1)) / this.dx;
        this.ny = (this.mosaic.height + (this.dy - 1)) / this.dy;
        assert (this.tiles == null != (this.patterns == null));
        if (this.patterns != null) {
            return;
        }
        this.formatter = new FilenameFormatter();
        Rectangle size = new Rectangle(this.xOffset, this.yOffset, this.dx, this.dy);
        HashMap<Tile, ArrayList<Tile>> models = new HashMap<Tile, ArrayList<Tile>>();
        for (Tile tile : this.tiles) {
            String input = this.inputPattern(tile);
            Tile model = input != null ? new Tile(tile, input, size) : null;
            ArrayList<Tile> similar = (ArrayList<Tile>)models.get(model);
            if (similar == null) {
                similar = new ArrayList<Tile>();
                models.put(model, similar);
            }
            similar.add(tile);
        }
        this.tiles = (List)models.remove(null);
        Iterator it = models.values().iterator();
        while (it.hasNext()) {
            List similar = (List)it.next();
            if (similar.size() >= 4) continue;
            if (this.tiles == null) {
                this.tiles = similar;
            } else {
                this.tiles.addAll(similar);
            }
            it.remove();
        }
        if (this.tiles != null) {
            this.tiles = UnmodifiableArrayList.wrap((Object[])this.toArray(this.tiles));
        }
        this.formatter = null;
        if (models.isEmpty()) {
            return;
        }
        this.patterns = new Tile[models.size()];
        this.patternUsed = new IntegerList(this.nx * this.ny, this.patterns.length, true);
        int index = 0;
        for (Map.Entry entry : models.entrySet()) {
            this.patterns[index++] = (Tile)entry.getKey();
            for (Tile tile : (List)entry.getValue()) {
                Point pt = this.getIndex2D(tile);
                int i = this.getIndex(pt.x, pt.y);
                int p = this.patternUsed.getInteger(i);
                if (p != 0 && p != index || this.tiles != null && this.tiles.get(i) != null) {
                    throw OverviewLevel.duplicatedTile(pt);
                }
                this.patternUsed.setInteger(i, index);
            }
        }
        if (this.patterns.length == 1) {
            int i = this.patternUsed.size();
            while (--i >= 0) {
                if (this.patternUsed.getInteger(i) != 0 || this.tiles != null && this.tiles.get(i) != null) continue;
                return;
            }
            this.patternUsed = null;
        }
    }

    private String inputPattern(Tile tile) {
        if (!Tile.class.equals(tile.getClass()) || !tile.isSizeEquals(this.dx, this.dy)) {
            return null;
        }
        Object input = tile.getInput();
        Class<?> type = input.getClass();
        if (!INPUT_TYPES.contains(type)) {
            return null;
        }
        Point index = this.getIndex2D(tile);
        String pattern = input.toString();
        if ((pattern = this.formatter.guessPattern(this.ordinal, index.x, index.y, pattern)) != null) {
            pattern = type.getSimpleName() + ':' + pattern;
        }
        return pattern;
    }

    private static IllegalArgumentException duplicatedTile(Point pt) {
        return new IllegalArgumentException(Errors.format((int)44, (Object)("location=" + pt.x + ',' + pt.y)));
    }

    final void removeTile(int x, int y) {
        int i = this.getIndex(x, y);
        assert (this.tiles == null || this.tiles.get(i) == null);
        if (this.patternUsed == null) {
            this.patternUsed = new IntegerList(this.nx * this.ny, this.patterns.length, true);
            this.patternUsed.fill(1);
        }
        this.patternUsed.setInteger(i, 0);
    }

    private Tile[] toArray(Collection<Tile> tiles) {
        Tile[] array = new Tile[this.nx * this.ny];
        for (Tile tile : tiles) {
            Point pt = this.getIndex2D(tile);
            int index = this.getIndex(pt.x, pt.y);
            if (array[index] != null && !tile.equals(array[index])) {
                throw OverviewLevel.duplicatedTile(pt);
            }
            array[index] = tile;
        }
        return array;
    }

    private Rectangle toTileIndex(Rectangle search) {
        Rectangle index = new Rectangle(this.dx * this.xSubsampling, this.dy * this.ySubsampling);
        int x = search.x - this.mosaic.x * this.xSubsampling;
        int y = search.y - this.mosaic.y * this.ySubsampling;
        if (x >= 0) {
            index.x = x / index.width;
        }
        if (y >= 0) {
            index.y = y / index.height;
        }
        index.width = Math.min(this.nx, ((x += search.width) + (index.width - 1)) / index.width) - index.x;
        index.height = Math.min(this.ny, ((y += search.height) + (index.height - 1)) / index.height) - index.y;
        return index;
    }

    private Point getIndex2D(Tile tile) {
        Point location = tile.getLocation();
        location.x -= this.mosaic.x;
        location.y -= this.mosaic.y;
        assert (location.x % this.dx == 0 && location.y % this.dy == 0) : location;
        location.x /= this.dx;
        location.y /= this.dy;
        return location;
    }

    private int getIndex(int x, int y) throws IndexOutOfBoundsException {
        if (x < 0 || x >= this.nx || y < 0 || y >= this.ny) {
            throw new IndexOutOfBoundsException(Errors.format((int)79, (Object)("(" + x + ',' + y + ')')));
        }
        return y * this.nx + x;
    }

    public OverviewLevel getFinerLevel() {
        assert (this.finer == null ? this.ordinal == 0 : this.ordinal > 0) : this.ordinal;
        assert (this.finer == null || this.compareTo(this.finer) >= 0 && this.finer.ordinal == this.ordinal - 1) : this.finer;
        return this.finer;
    }

    public int getNumTiles() {
        int count = 0;
        if (this.patterns != null) {
            count = this.nx * this.ny;
            if (this.patternUsed != null) {
                count -= this.patternUsed.occurence(0);
            }
        } else if (this.tiles != null) {
            for (Tile tile : this.tiles) {
                if (tile == null) continue;
                ++count;
            }
        }
        return count;
    }

    public final int getNumXTiles() {
        return this.nx;
    }

    public final int getNumYTiles() {
        return this.ny;
    }

    public Dimension getTileSize() {
        if (this.mosaic.width > this.dx || this.mosaic.height > this.dy) {
            return new Dimension(this.dx, this.dy);
        }
        return null;
    }

    public Rectangle getAbsoluteRegion() {
        return new Rectangle(this.xSubsampling * this.mosaic.x, this.ySubsampling * this.mosaic.y, this.xSubsampling * this.mosaic.width, this.ySubsampling * this.mosaic.height);
    }

    private boolean isAbsoluteTilesRegion(Rectangle bounds) {
        int height;
        int width = this.dx * this.xSubsampling;
        if (bounds.width % width == 0 && bounds.height % (height = this.dy * this.ySubsampling) == 0) {
            return (bounds.x - this.xOffset * this.xSubsampling) % width == 0 && (bounds.y - this.yOffset * this.ySubsampling) % height == 0;
        }
        return false;
    }

    public Tile getSampleTile() {
        if (this.sample == null) {
            if (this.patterns != null) {
                int i = 0;
                do {
                    this.sample = this.patterns[i++];
                } while (this.sample == null);
            } else {
                int i = 0;
                do {
                    this.sample = this.tiles.get(i++);
                } while (this.sample == null);
            }
        }
        return this.sample;
    }

    final Tile getTile(int x, int y) throws IndexOutOfBoundsException, MalformedURLException {
        Object input;
        int index = this.getIndex(x, y);
        if (this.tiles != null) {
            Tile tile = this.tiles.get(index);
            if (tile != null) {
                assert (this.patternUsed == null || this.patternUsed.getInteger(index) == 0) : index;
                return tile;
            }
            if (this.patterns == null) {
                return null;
            }
        }
        int p = 0;
        if (this.patternUsed != null) {
            p = this.patternUsed.get(index);
            if (p == 0) {
                return null;
            }
            --p;
        }
        Tile tile = this.patterns[p];
        String pattern = tile.getInput().toString();
        if (this.formatter == null) {
            this.formatter = new FilenameFormatter();
            this.lastPattern = -1;
        }
        if (p != this.lastPattern) {
            this.formatter.applyPattern(pattern.substring(pattern.indexOf(58) + 1));
            this.lastPattern = p;
        }
        String filename = this.formatter.generateFilename(this.ordinal, x, y);
        if (pattern.startsWith("File")) {
            input = new File(filename);
        } else if (pattern.startsWith("URL")) {
            input = new URL(filename);
        } else if (pattern.startsWith("URI")) {
            try {
                input = new URI(filename);
            }
            catch (URISyntaxException cause) {
                MalformedURLException e = new MalformedURLException(cause.getLocalizedMessage());
                e.initCause(cause);
                throw e;
            }
        } else {
            input = filename;
        }
        assert (INPUT_TYPES.contains(input.getClass())) : input;
        Rectangle bounds = new Rectangle(this.mosaic.x + (x *= this.dx), this.mosaic.y + (y *= this.dy), Math.min(this.dx, this.mosaic.width - x), Math.min(this.dy, this.mosaic.height - y));
        return new Tile(tile, input, bounds);
    }

    final void getInternalTiles(FrequencySortedSet<? super Tile> addTo) {
        int count = 0;
        if (this.tiles != null) {
            for (Tile tile : this.tiles) {
                if (tile == null) continue;
                addTo.add((Object)tile);
                ++count;
            }
        }
        if (this.patterns != null) {
            int p = 0;
            while (p < this.patterns.length) {
                Tile tile;
                tile = this.patterns[p++];
                int n = this.patternUsed != null ? this.patternUsed.occurence(p) : this.nx * this.ny - count;
                addTo.add((Object)tile, n);
            }
        }
    }

    final long getTiles(ArrayList<Tile> addTo, Rectangle search, Dimension subsampling, long costLimit) throws IOException {
        Rectangle atr = this.toTileIndex(search);
        int xmin = atr.x;
        int ymin = atr.y;
        int xmax = atr.width + xmin;
        int ymax = atr.height + ymin;
        atr.width = this.dx * this.xSubsampling;
        atr.height = this.dy * this.ySubsampling;
        int size = addTo.size();
        if (size == 0) {
            int n = (xmax - xmin) * (ymax - ymin);
            addTo.ensureCapacity(n);
        }
        long totalCost = 0L;
        for (int y = ymin; y < ymax; ++y) {
            block1: for (int x = xmin; x < xmax; ++x) {
                Tile tile = this.getTile(x, y);
                if (tile == null) continue;
                long cost = tile.countUnwantedPixelsFromAbsolute(search, subsampling);
                if (cost != 0L) {
                    if ((totalCost += cost) >= costLimit) {
                        addTo.subList(size, addTo.size()).clear();
                        return -1L;
                    }
                    atr.x = atr.width * x;
                    atr.y = atr.height * y;
                    assert (atr.equals(tile.getAbsoluteRegion()) || !tile.getClass().equals(Tile.class)) : atr;
                    OverviewLevel previous = this;
                    while ((previous = previous.getFinerLevel()) != null) {
                        if (!previous.isAbsoluteTilesRegion(atr)) continue;
                        Rectangle clipped = atr.intersection(search);
                        long c = previous.getTiles(addTo, clipped, subsampling, cost);
                        if (c < 0L) break;
                        totalCost += c - cost;
                        continue block1;
                    }
                }
                addTo.add(tile);
            }
        }
        assert (addTo.size() > size == this.intersects(search));
        return totalCost;
    }

    final boolean intersects(Rectangle search) throws IOException {
        Rectangle index = this.toTileIndex(search);
        int xmin = index.x;
        int ymin = index.y;
        int xmax = index.width + xmin;
        int ymax = index.height + ymin;
        for (int y = ymin; y < ymax; ++y) {
            for (int x = xmin; x < xmax; ++x) {
                int i = this.getIndex(x, y);
                if (this.tiles != null) {
                    Tile tile = this.tiles.get(i);
                    if (tile != null) {
                        if (!search.intersects(tile.getAbsoluteRegion())) continue;
                        return true;
                    }
                    if (this.patterns == null) continue;
                }
                if (this.patternUsed != null && this.patternUsed.get(i) == 0) continue;
                return true;
            }
        }
        return false;
    }

    static final boolean contains(OverviewLevel level, Tile tile) {
        Dimension subsampling = tile.getSubsampling();
        while (level != null) {
            if (level.xSubsampling == subsampling.width && level.ySubsampling == subsampling.height) {
                Point index = level.getIndex2D(tile);
                if (index.x < 0 || index.x >= level.nx || index.y < 0 || index.y >= level.ny) break;
                try {
                    return tile.equals(level.getTile(index.x, index.y));
                }
                catch (MalformedURLException e) {
                    Logging.recoverableException(OverviewLevel.class, (String)"contains", (Throwable)e);
                    break;
                }
            }
            level = level.getFinerLevel();
        }
        return false;
    }

    @Override
    public int compareTo(Dimension subsampling) {
        int c = this.xSubsampling * this.ySubsampling - subsampling.width * subsampling.height;
        if (c == 0 && (c = this.xSubsampling - subsampling.width) == 0) {
            c = this.ySubsampling - subsampling.height;
        }
        return c;
    }

    @Override
    public int compareTo(OverviewLevel other) {
        int c = this.xSubsampling * this.ySubsampling - other.xSubsampling * other.ySubsampling;
        if (c == 0 && (c = this.xSubsampling - other.xSubsampling) == 0) {
            c = this.ySubsampling - other.ySubsampling;
        }
        return c;
    }

    public boolean equals(Object other) {
        if (other instanceof OverviewLevel) {
            OverviewLevel that = (OverviewLevel)other;
            return this.ordinal == that.ordinal && this.dx == that.dx && this.dy == that.dy && this.nx == that.nx && this.ny == that.ny && this.xSubsampling == that.xSubsampling && this.ySubsampling == that.ySubsampling && this.xOffset == that.xOffset && this.yOffset == that.yOffset && Utilities.equals((Object)this.mosaic, (Object)that.mosaic) && Utilities.equals(this.tiles, that.tiles) && Arrays.equals(this.patterns, that.patterns) && Utilities.equals((Object)this.patternUsed, (Object)that.patternUsed) && Utilities.equals((Object)this.finer, (Object)that.finer);
        }
        return false;
    }

    public int hashCode() {
        int code = this.ordinal + 37 * (this.xSubsampling + 37 * (this.ySubsampling + Arrays.hashCode(this.patterns)));
        if (this.finer != null) {
            code += 31 * this.finer.hashCode();
        }
        return code;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.ordinal + ", subsampling=(" + this.xSubsampling + ',' + this.ySubsampling + "), " + this.getNumTiles() + " tiles]";
    }

    static {
        INPUT_TYPES.add(String.class);
        INPUT_TYPES.add(File.class);
        INPUT_TYPES.add(URL.class);
        INPUT_TYPES.add(URI.class);
    }
}

