/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import javax.imageio.spi.ImageReaderSpi;
import org.geotools.image.io.StreamImageReader;

public abstract class FileImageReader
extends StreamImageReader {
    private File inputFile;
    private boolean isTemporary;

    public FileImageReader(ImageReaderSpi spi) {
        super(spi);
    }

    public String getURLEncoding() {
        return "UTF-8";
    }

    private void ensureFileExists(File file) throws FileNotFoundException {
        if (!file.isFile() || !file.canRead()) {
            throw new FileNotFoundException(this.getErrorResources().getString(50, (Object)file));
        }
    }

    protected File getInputFile() throws IOException {
        int length;
        String[] suffixes;
        URL sourceURL;
        URI sourceURI;
        if (this.inputFile != null) {
            this.ensureFileExists(this.inputFile);
            return this.inputFile;
        }
        if (this.input instanceof String) {
            this.inputFile = new File((String)this.input);
            this.ensureFileExists(this.inputFile);
            return this.inputFile;
        }
        if (this.input instanceof File) {
            this.inputFile = (File)this.input;
            this.ensureFileExists(this.inputFile);
            return this.inputFile;
        }
        if (this.input instanceof URI && (sourceURI = (URI)this.input).getScheme().equalsIgnoreCase("file")) {
            this.inputFile = new File(sourceURI.getPath());
            this.ensureFileExists(this.inputFile);
            return this.inputFile;
        }
        if (this.input instanceof URL && (sourceURL = (URL)this.input).getProtocol().equalsIgnoreCase("file")) {
            this.inputFile = new File(URLDecoder.decode(sourceURL.getPath(), this.getURLEncoding()));
            this.ensureFileExists(this.inputFile);
            return this.inputFile;
        }
        InputStream in = this.getInputStream();
        String suffix = "tmp";
        if (this.originatingProvider != null && (suffixes = this.originatingProvider.getFileSuffixes()) != null && suffixes.length != 0) {
            suffix = suffixes[0];
        }
        this.inputFile = File.createTempFile("Image", suffix);
        this.inputFile.deleteOnExit();
        this.isTemporary = true;
        FileOutputStream out = new FileOutputStream(this.inputFile);
        byte[] buffer = new byte[8192];
        while ((length = in.read(buffer)) >= 0) {
            ((OutputStream)out).write(buffer, 0, length);
        }
        in.close();
        ((OutputStream)out).close();
        return this.inputFile;
    }

    protected boolean isTemporaryFile() {
        return this.isTemporary;
    }

    public boolean isRandomAccessEasy(int imageIndex) throws IOException {
        return true;
    }

    protected void close() throws IOException {
        if (this.inputFile != null) {
            if (this.isTemporary) {
                this.inputFile.delete();
            }
            this.inputFile = null;
        }
        this.isTemporary = false;
        super.close();
    }
}

