/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import javax.imageio.ImageTypeSpecifier;
import javax.media.jai.widget.ImageCanvas;
import javax.swing.JFrame;
import org.geotools.image.io.PaletteDisposer;
import org.geotools.image.io.PaletteFactory;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Errors;

public abstract class Palette {
    final PaletteFactory factory;
    protected final String name;
    protected final int numBands;
    protected final int visibleBand;
    private transient SampleModel samples;
    private transient Reference<ColorModel> colors;
    private transient Reference<ImageTypeSpecifier> specifier;

    protected Palette(PaletteFactory factory, String name, int numBands, int visibleBand) {
        if (factory == null) {
            throw new IllegalArgumentException(Errors.format((int)143, (Object)"factory"));
        }
        if (name == null) {
            throw new IllegalArgumentException(factory.getErrorResources().getString(143, (Object)"name"));
        }
        this.ensureInsideBounds(numBands, 0, 255);
        this.ensureInsideBounds(visibleBand, 0, numBands - 1);
        this.factory = factory;
        this.name = name.trim();
        this.numBands = numBands;
        this.visibleBand = visibleBand;
    }

    final void ensureInsideBounds(int value, int min, int max) throws IllegalArgumentException {
        if (value < min || value > max) {
            throw new IllegalArgumentException(this.factory.getErrorResources().getString(201, (Object)value, (Object)min, (Object)max));
        }
    }

    double getScale() {
        return 1.0;
    }

    double getOffset() {
        return 0.0;
    }

    public synchronized ColorModel getColorModel() throws IOException {
        ColorModel candidate;
        if (this.colors != null && (candidate = this.colors.get()) != null) {
            return candidate;
        }
        return this.getImageTypeSpecifier().getColorModel();
    }

    public abstract ImageTypeSpecifier getImageTypeSpecifier() throws IOException;

    final ImageTypeSpecifier queryCache() {
        Object candidate;
        if (this.specifier != null && (candidate = this.specifier.get()) != null) {
            return candidate;
        }
        if (this.samples != null && this.colors != null && (candidate = this.colors.get()) != null) {
            ImageTypeSpecifier its = new ImageTypeSpecifier((ColorModel)candidate, this.samples);
            this.specifier = new WeakReference<ImageTypeSpecifier>(its);
            return its;
        }
        return null;
    }

    final void cache(ImageTypeSpecifier its) {
        this.samples = its.getSampleModel();
        this.colors = new PaletteDisposer.Reference(this, its.getColorModel());
        this.specifier = new WeakReference<ImageTypeSpecifier>(its);
    }

    public RenderedImage getImage(Dimension size) throws IOException {
        boolean horizontal;
        IndexColorModel colors = (IndexColorModel)this.getColorModel();
        WritableRaster raster = colors.createCompatibleWritableRaster(size.width, size.height);
        BufferedImage image = new BufferedImage(colors, raster, false, null);
        int xmin = raster.getMinX();
        int ymin = raster.getMinY();
        int width = raster.getWidth();
        int height = raster.getHeight();
        boolean bl = horizontal = size.width >= size.height;
        if (!horizontal) {
            int tmp = xmin;
            xmin = ymin;
            ymin = tmp;
            tmp = width;
            width = height;
            height = tmp;
        }
        int xmax = xmin + width;
        int ymax = ymin + height;
        double scale = this.getScale() / (double)width;
        double offset = this.getOffset();
        for (int x = xmin; x < xmax; ++x) {
            double value = offset + scale * (double)(x - xmin);
            for (int y = ymin; y < ymax; ++y) {
                if (horizontal) {
                    raster.setSample(x, y, 0, value);
                    continue;
                }
                raster.setSample(y, x, 0, value);
            }
        }
        return image;
    }

    public void show() throws IOException {
        JFrame frame = new JFrame(this.toString());
        frame.setDefaultCloseOperation(2);
        frame.add((Component)new ImageCanvas(this.getImage(new Dimension(256, 32))));
        frame.pack();
        frame.setVisible(true);
    }

    public int hashCode() {
        return this.name.hashCode() + 37 * this.numBands + 17 * this.visibleBand;
    }

    public boolean equals(Object object) {
        if (object != null && this.getClass().equals(object.getClass())) {
            Palette that = (Palette)object;
            return this.numBands == that.numBands && this.visibleBand == that.visibleBand && Utilities.equals((Object)this.name, (Object)that.name);
        }
        return false;
    }
}

