/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io.mosaic;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import org.geotools.factory.GeoTools;
import org.geotools.image.io.metadata.MetadataMerge;
import org.geotools.image.io.mosaic.ImageTypePolicy;
import org.geotools.image.io.mosaic.MosaicController;
import org.geotools.image.io.mosaic.MosaicImageReadParam;
import org.geotools.image.io.mosaic.ReaderInputPair;
import org.geotools.image.io.mosaic.Tile;
import org.geotools.image.io.mosaic.TileManager;
import org.geotools.image.io.mosaic.TileManagerFactory;
import org.geotools.io.TableWriter;
import org.geotools.resources.Classes;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Vocabulary;
import org.geotools.util.FrequencySortedSet;
import org.geotools.util.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MosaicImageReader
extends ImageReader {
    private static final boolean PRESERVE_DATA = true;
    private static final Class<?>[] INTEGER_ARGUMENTS = new Class[]{Integer.TYPE};
    private final Set<ImageReaderSpi> providers;
    private final Map<ImageReaderSpi, ImageReader> readers;
    private final Map<ImageReader, Object> readerInputs;
    private transient ImageReader reading;
    private Level level = Level.FINE;

    public MosaicImageReader() {
        this(null);
    }

    public MosaicImageReader(ImageReaderSpi spi) {
        super(spi != null ? spi : Spi.DEFAULT);
        this.readers = new HashMap<ImageReaderSpi, ImageReader>();
        this.readerInputs = new IdentityHashMap<ImageReader, Object>();
        this.providers = Collections.unmodifiableSet(this.readers.keySet());
    }

    public Level getLogLevel() {
        return this.level;
    }

    public void setLogLevel(Level level) {
        if (level == null) {
            level = Level.FINE;
        }
        this.level = level;
    }

    private TileManager getTileManager(int imageIndex) throws IOException {
        if (this.input instanceof TileManager[]) {
            TileManager[] tiles = (TileManager[])this.input;
            if (imageIndex < 0 || imageIndex >= tiles.length) {
                throw new IndexOutOfBoundsException(Errors.format((int)79, (Object)imageIndex));
            }
            return tiles[imageIndex];
        }
        throw new IllegalStateException(Errors.format((int)132));
    }

    public TileManager[] getInput() {
        TileManager[] managers = (TileManager[])super.getInput();
        return managers != null ? (TileManager[])managers.clone() : null;
    }

    @Override
    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) throws IllegalArgumentException {
        TileManager[] managers;
        try {
            managers = TileManagerFactory.DEFAULT.createFromObject(input);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getLocalizedMessage(), e);
        }
        int numImages = managers != null ? managers.length : 0;
        input = managers;
        super.setInput(managers, seekForwardOnly, ignoreMetadata);
        this.availableLocales = null;
        Set<Object> providers = Collections.emptySet();
        try {
            switch (numImages) {
                case 0: {
                    break;
                }
                case 1: {
                    providers = managers[0].getImageReaderSpis();
                    break;
                }
                default: {
                    providers = new HashSet<ImageReaderSpi>(managers[0].getImageReaderSpis());
                    for (int i = 1; i < numImages; ++i) {
                        providers.addAll(managers[i].getImageReaderSpis());
                    }
                    break;
                }
            }
        }
        catch (IOException e) {
            Logging.unexpectedException(MosaicImageReader.class, (String)"setInput", (Throwable)e);
        }
        Iterator<Map.Entry<ImageReaderSpi, ImageReader>> it = this.readers.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<ImageReaderSpi, ImageReader> entry = it.next();
            if (providers.contains(entry.getKey())) continue;
            ImageReader imageReader = entry.getValue();
            if (imageReader != null) {
                Object tileInput;
                Object rawInput = this.readerInputs.remove(imageReader);
                if (rawInput != (tileInput = imageReader.getInput())) {
                    try {
                        Tile.close(tileInput);
                    }
                    catch (IOException exception) {
                        Logging.unexpectedException(MosaicImageReader.class, (String)"setInput", (Throwable)exception);
                    }
                }
                imageReader.dispose();
            }
            it.remove();
        }
        for (ImageReaderSpi imageReaderSpi : providers) {
            if (this.readers.containsKey(imageReaderSpi)) continue;
            this.readers.put(imageReaderSpi, null);
        }
        assert (((Object)providers).equals(this.providers));
        assert (this.readers.values().containsAll(this.readerInputs.keySet()));
    }

    public Set<ImageReaderSpi> getTileReaderSpis() {
        return this.providers;
    }

    private ImageReader createReaderInstance(ImageReaderSpi provider) throws IOException {
        ImageReader reader = provider.createReaderInstance();
        if (this.locale != null) {
            try {
                reader.setLocale(this.locale);
            }
            catch (IllegalArgumentException e) {
                Logging.recoverableException(MosaicImageReader.class, (String)"getTileReader", (Throwable)e);
            }
        }
        return reader;
    }

    final ImageReader getTileReader(ImageReaderSpi provider) throws IOException {
        assert (this.readers.containsKey(provider));
        ImageReader reader = this.readers.get(provider);
        if (reader == null) {
            reader = this.createReaderInstance(provider);
            this.readers.put(provider, reader);
        }
        return reader;
    }

    final Set<ImageReader> getTileReaders() {
        for (Map.Entry<ImageReaderSpi, ImageReader> entry : this.readers.entrySet()) {
            ImageReader reader = entry.getValue();
            if (reader == null) {
                ImageReaderSpi provider = entry.getKey();
                try {
                    reader = this.createReaderInstance(provider);
                }
                catch (IOException exception) {
                    Logging.unexpectedException(MosaicImageReader.class, (String)"getTileReaders", (Throwable)exception);
                    continue;
                }
                entry.setValue(reader);
            }
            if (this.readerInputs.containsKey(reader)) continue;
            this.readerInputs.put(reader, null);
        }
        assert (this.readers.values().containsAll(this.readerInputs.keySet()));
        return this.readerInputs.keySet();
    }

    final ImageReader getTileReader() {
        Set<ImageReader> readers = this.getTileReaders();
        for (Class type = Classes.specializedClass(readers); type != null && ImageReader.class.isAssignableFrom(type); type = type.getSuperclass()) {
            for (ImageReader candidate : readers) {
                if (!type.equals(candidate.getClass())) continue;
                return candidate;
            }
        }
        return null;
    }

    private Tile getSpecificTile(Collection<Tile> tiles) {
        Tile fallback = null;
        Set<ImageReader> readers = this.getTileReaders();
        for (Class type = Classes.specializedClass(readers); type != null && ImageReader.class.isAssignableFrom(type); type = type.getSuperclass()) {
            for (ImageReader reader : readers) {
                if (!type.equals(reader.getClass())) continue;
                ImageReaderSpi provider = reader.getOriginatingProvider();
                for (Tile tile : tiles) {
                    ImageReaderSpi candidate = tile.getImageReaderSpi();
                    if (candidate.equals(provider)) {
                        return tile;
                    }
                    if (fallback != null || !candidate.isOwnReader(reader)) continue;
                    fallback = tile;
                }
            }
        }
        return fallback;
    }

    @Override
    public Locale[] getAvailableLocales() {
        if (this.availableLocales == null) {
            LinkedHashSet<Locale> locales = new LinkedHashSet<Locale>();
            for (ImageReader reader : this.getTileReaders()) {
                Locale[] additional = reader.getAvailableLocales();
                if (additional == null) continue;
                for (Locale locale : additional) {
                    locales.add(locale);
                }
            }
            if (locales.isEmpty()) {
                return null;
            }
            this.availableLocales = locales.toArray(new Locale[locales.size()]);
        }
        return (Locale[])this.availableLocales.clone();
    }

    @Override
    public void setLocale(Locale locale) throws IllegalArgumentException {
        super.setLocale(locale);
        for (ImageReader reader : this.readers.values()) {
            try {
                reader.setLocale(locale);
            }
            catch (IllegalArgumentException e) {
                Logging.recoverableException(MosaicImageReader.class, (String)"setLocale", (Throwable)e);
            }
        }
    }

    @Override
    public int getNumImages(boolean allowSearch) throws IOException {
        return this.input instanceof TileManager[] ? ((TileManager[])this.input).length : 0;
    }

    @Override
    public boolean isImageTiled(int imageIndex) throws IOException {
        return this.getTileManager(imageIndex).isImageTiled();
    }

    @Override
    public int getWidth(int imageIndex) throws IOException {
        return this.getTileManager((int)imageIndex).getRegion().width;
    }

    @Override
    public int getHeight(int imageIndex) throws IOException {
        return this.getTileManager((int)imageIndex).getRegion().height;
    }

    @Override
    public int getTileWidth(int imageIndex) throws IOException {
        return this.getTileManager((int)imageIndex).getTileSize().width;
    }

    @Override
    public int getTileHeight(int imageIndex) throws IOException {
        return this.getTileManager((int)imageIndex).getTileSize().height;
    }

    private boolean useDefaultImplementation(String methodName, Class<?>[] parameterTypes) {
        for (ImageReader reader : this.getTileReaders()) {
            Class<?> type = reader.getClass();
            try {
                type = type.getMethod(methodName, parameterTypes).getDeclaringClass();
            }
            catch (NoSuchMethodException e) {
                Logging.unexpectedException(MosaicImageReader.class, (String)"useDefaultImplementation", (Throwable)e);
                return false;
            }
            if (type.equals(ImageReader.class)) continue;
            return false;
        }
        return true;
    }

    private static boolean canDelegate(Collection<Tile> tiles, Rectangle sourceRegion) throws IOException {
        Iterator<Tile> it = tiles.iterator();
        if (it.hasNext()) {
            Tile tile = it.next();
            if (!it.hasNext()) {
                return tile.getRegion().contains(sourceRegion);
            }
        }
        return false;
    }

    @Override
    public boolean isRandomAccessEasy(int imageIndex) throws IOException {
        if (this.useDefaultImplementation("isRandomAccessEasy", INTEGER_ARGUMENTS)) {
            return super.isRandomAccessEasy(imageIndex);
        }
        for (Tile tile : this.getTileManager(imageIndex).getTiles()) {
            Object input = tile.getInput();
            if (!(input instanceof File)) {
                return false;
            }
            ImageReader reader = tile.getImageReader(this, true, true);
            if (reader.isRandomAccessEasy(tile.getImageIndex())) continue;
            return false;
        }
        return true;
    }

    @Override
    public float getAspectRatio(int imageIndex) throws IOException {
        if (!this.useDefaultImplementation("getAspectRatio", INTEGER_ARGUMENTS)) {
            float ratio = Float.NaN;
            for (Tile tile : this.getTileManager(imageIndex).getTiles()) {
                ImageReader reader = tile.getImageReader(this, true, true);
                float candidate = reader.getAspectRatio(tile.getImageIndex());
                if (candidate == ratio || Float.isNaN(candidate)) continue;
                if (!Float.isNaN(ratio)) {
                    return super.getAspectRatio(imageIndex);
                }
                ratio = candidate;
            }
            if (!Float.isNaN(ratio)) {
                return ratio;
            }
        }
        return super.getAspectRatio(imageIndex);
    }

    private ImageTypePolicy getImageTypePolicy(ImageReadParam param) {
        ImageTypePolicy policy;
        if (param instanceof MosaicImageReadParam && (policy = ((MosaicImageReadParam)param).getImageTypePolicy()) != null) {
            return policy;
        }
        return this.getDefaultImageTypePolicy();
    }

    public ImageTypePolicy getDefaultImageTypePolicy() {
        switch (this.providers.size()) {
            default: {
                return ImageTypePolicy.SUPPORTED_BY_ALL;
            }
            case 1: {
                return ImageTypePolicy.SUPPORTED_BY_ONE;
            }
            case 0: 
        }
        return ImageTypePolicy.ALWAYS_ARGB;
    }

    private static ImageTypeSpecifier getPredefinedImageType(ImageTypePolicy policy) {
        int type;
        switch (policy) {
            case ALWAYS_ARGB: {
                type = 2;
                break;
            }
            default: {
                throw new IllegalArgumentException(policy.toString());
            }
        }
        return ImageTypeSpecifier.createFromBufferedImageType(type);
    }

    @Override
    public ImageTypeSpecifier getRawImageType(int imageIndex) throws IOException {
        ImageTypeSpecifier type;
        ImageTypePolicy policy = this.getDefaultImageTypePolicy();
        switch (policy) {
            default: {
                type = MosaicImageReader.getPredefinedImageType(policy);
                break;
            }
            case SUPPORTED_BY_ONE: {
                Collection<Tile> tiles = this.getTileManager(imageIndex).getTiles();
                Tile tile = this.getSpecificTile(tiles);
                if (tile != null) {
                    type = tile.getImageReader(this, true, true).getRawImageType(imageIndex);
                    assert (type.equals(this.getRawImageType(tiles))) : MosaicImageReader.incompatibleImageType(tile);
                    break;
                }
                type = super.getRawImageType(imageIndex);
                break;
            }
            case SUPPORTED_BY_ALL: {
                Collection<Tile> tiles = this.getTileManager(imageIndex).getTiles();
                type = this.getRawImageType(tiles);
                if (type != null) break;
                type = super.getRawImageType(imageIndex);
                break;
            }
        }
        return type;
    }

    private ImageTypeSpecifier getRawImageType(Collection<Tile> tiles) throws IOException {
        FrequencySortedSet rawTypes = new FrequencySortedSet(true);
        Set<ImageTypeSpecifier> allowed = this.getImageTypes(tiles, (Collection<ImageTypeSpecifier>)rawTypes);
        rawTypes.retainAll(allowed);
        boolean transparent = true;
        do {
            for (ImageTypeSpecifier type : rawTypes) {
                if (transparent && !MosaicImageReader.isTransparent(type)) continue;
                return type;
            }
            for (ImageTypeSpecifier type : allowed) {
                if (transparent && !MosaicImageReader.isTransparent(type)) continue;
                return type;
            }
        } while (!(transparent = !transparent));
        return null;
    }

    private Set<ImageTypeSpecifier> getImageTypes(Collection<Tile> tiles, Collection<ImageTypeSpecifier> rawTypes) throws IOException {
        int pass = 0;
        LinkedHashMap<ImageTypeSpecifier, Integer> types = new LinkedHashMap<ImageTypeSpecifier, Integer>();
        for (Tile tile : tiles) {
            ImageReader reader = tile.getImageReader(this, true, true);
            int imageIndex = tile.getImageIndex();
            if (rawTypes != null) {
                rawTypes.add(reader.getRawImageType(imageIndex));
            }
            Iterator<ImageTypeSpecifier> toAdd = reader.getImageTypes(imageIndex);
            while (toAdd.hasNext()) {
                ImageTypeSpecifier type = toAdd.next();
                Integer old = types.put(type, pass);
                if (old != null || pass == 0) continue;
                types.remove(type);
            }
            Iterator it = types.values().iterator();
            while (it.hasNext()) {
                if ((Integer)it.next() == pass) continue;
                it.remove();
            }
            ++pass;
        }
        return types.keySet();
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IOException {
        Iterator<ImageTypeSpecifier> types;
        ImageTypePolicy policy = this.getDefaultImageTypePolicy();
        switch (policy) {
            default: {
                types = Collections.singleton(MosaicImageReader.getPredefinedImageType(policy)).iterator();
                break;
            }
            case SUPPORTED_BY_ONE: {
                Collection<Tile> tiles = this.getTileManager(imageIndex).getTiles();
                Tile tile = this.getSpecificTile(tiles);
                if (tile == null) {
                    Set t = Collections.emptySet();
                    return t.iterator();
                }
                types = tile.getImageReader(this, true, true).getImageTypes(imageIndex);
                assert ((types = MosaicImageReader.containsAll(this.getImageTypes(tiles, null), types)) != null) : MosaicImageReader.incompatibleImageType(tile);
                break;
            }
            case SUPPORTED_BY_ALL: {
                Collection<Tile> tiles = this.getTileManager(imageIndex).getTiles();
                types = this.getImageTypes(tiles, null).iterator();
                break;
            }
        }
        return types;
    }

    private static Iterator<ImageTypeSpecifier> containsAll(Collection<ImageTypeSpecifier> expected, Iterator<ImageTypeSpecifier> types) {
        ArrayList<ImageTypeSpecifier> asList = new ArrayList<ImageTypeSpecifier>(expected.size());
        while (types.hasNext()) {
            asList.add(types.next());
        }
        return expected.containsAll(asList) ? asList.iterator() : null;
    }

    private static boolean isTransparent(ImageTypeSpecifier type) {
        return type.getColorModel().getTransparency() != 1;
    }

    private static String incompatibleImageType(Tile tile) {
        return "Image type computed by " + (Object)((Object)ImageTypePolicy.SUPPORTED_BY_ONE) + " policy using " + tile + " is incompatible with type computed by " + (Object)((Object)ImageTypePolicy.SUPPORTED_BY_ALL) + " policy.";
    }

    @Override
    public MosaicImageReadParam getDefaultReadParam() {
        return new MosaicImageReadParam(this);
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        IIOMetadata metadata = null;
        if (this.input instanceof TileManager[]) {
            HashSet<ReaderInputPair> done = new HashSet<ReaderInputPair>();
            for (TileManager manager : (TileManager[])this.input) {
                for (Tile tile : manager.getTiles()) {
                    Object input;
                    ImageReader reader = tile.getImageReader(this, true, this.ignoreMetadata);
                    if (!done.add(new ReaderInputPair(reader, input = reader.getInput()))) continue;
                    IIOMetadata candidate = reader.getStreamMetadata();
                    metadata = MetadataMerge.merge(candidate, metadata);
                }
            }
        }
        return metadata;
    }

    @Override
    public IIOMetadata getStreamMetadata(String formatName, Set<String> nodeNames) throws IOException {
        IIOMetadata metadata = null;
        if (this.input instanceof TileManager[]) {
            HashSet<ReaderInputPair> done = new HashSet<ReaderInputPair>();
            for (TileManager manager : (TileManager[])this.input) {
                for (Tile tile : manager.getTiles()) {
                    Object input;
                    ImageReader reader = tile.getImageReader(this, true, this.ignoreMetadata);
                    if (!done.add(new ReaderInputPair(reader, input = reader.getInput()))) continue;
                    IIOMetadata candidate = reader.getStreamMetadata(formatName, nodeNames);
                    metadata = MetadataMerge.merge(candidate, metadata);
                }
            }
        }
        return metadata;
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        IIOMetadata metadata = null;
        for (Tile tile : this.getTileManager(imageIndex).getTiles()) {
            ImageReader reader = tile.getImageReader(this, true, this.ignoreMetadata);
            IIOMetadata candidate = reader.getImageMetadata(tile.getImageIndex());
            metadata = MetadataMerge.merge(candidate, metadata);
        }
        return metadata;
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex, String formatName, Set<String> nodeNames) throws IOException {
        IIOMetadata metadata = null;
        for (Tile tile : this.getTileManager(imageIndex).getTiles()) {
            ImageReader reader = tile.getImageReader(this, true, this.ignoreMetadata);
            IIOMetadata candidate = reader.getImageMetadata(tile.getImageIndex(), formatName, nodeNames);
            metadata = MetadataMerge.merge(candidate, metadata);
        }
        return metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        this.clearAbortRequest();
        this.processImageStarted(imageIndex);
        subsampling = new Dimension(1, 1);
        subsamplingChangeAllowed = false;
        mosaicParam = null;
        nullForEmptyImage = false;
        if (param != null) {
            subsampling.width = param.getSourceXSubsampling();
            subsampling.height = param.getSourceYSubsampling();
            if (param instanceof MosaicImageReadParam) {
                mosaicParam = (MosaicImageReadParam)param;
                subsamplingChangeAllowed = mosaicParam.isSubsamplingChangeAllowed();
                nullForEmptyImage = mosaicParam.getNullForEmptyImage();
            }
        }
        srcWidth = this.getWidth(imageIndex);
        srcHeight = this.getHeight(imageIndex);
        sourceRegion = MosaicImageReader.getSourceRegion(param, srcWidth, srcHeight);
        tiles = this.getTileManager(imageIndex).getTiles(sourceRegion, subsampling, subsamplingChangeAllowed);
        if (nullForEmptyImage && tiles.isEmpty()) {
            this.processImageComplete();
            return null;
        }
        xSubsampling = subsampling.width;
        ySubsampling = subsampling.height;
        if (subsamplingChangeAllowed) {
            if (param.getSourceXSubsampling() != xSubsampling || param.getSourceYSubsampling() != ySubsampling) {
                xOffset = param.getSubsamplingXOffset() % xSubsampling;
                yOffset = param.getSubsamplingYOffset() % ySubsampling;
                param.setSourceSubsampling(xSubsampling, ySubsampling, xOffset, yOffset);
            } else {
                subsamplingChangeAllowed = false;
            }
        }
        image = null;
        policy = null;
        if (!MosaicImageReader.canDelegate(tiles, sourceRegion)) ** GOTO lbl-1000
        policy = this.getImageTypePolicy(param);
        if (policy.canDelegate) {
            destRegion = null;
            if (subsamplingChangeAllowed) {
                sourceRegion.setBounds(MosaicImageReader.getSourceRegion(param, srcWidth, srcHeight));
            }
            destinationOffset = param != null ? param.getDestinationOffset() : new Point();
        } else lbl-1000:
        // 2 sources

        {
            if (param != null) {
                image = param.getDestination();
            }
            destRegion = new Rectangle();
            MosaicImageReader.computeRegions(param, srcWidth, srcHeight, image, sourceRegion, destRegion);
            if (image == null) {
                imageType = null;
                if (param != null) {
                    imageType = param.getDestinationType();
                }
                if (imageType == null) {
                    if (policy == null) {
                        policy = this.getImageTypePolicy(param);
                    }
                    switch (1.$SwitchMap$org$geotools$image$io$mosaic$ImageTypePolicy[policy.ordinal()]) {
                        default: {
                            imageType = MosaicImageReader.getPredefinedImageType(policy);
                            break;
                        }
                        case 2: {
                            tile = this.getSpecificTile(tiles);
                            if (tile == null) break;
                            imageType = tile.getImageReader(this, true, true).getRawImageType(imageIndex);
                            if (!MosaicImageReader.$assertionsDisabled && !imageType.equals(this.getRawImageType(tiles))) {
                                throw new AssertionError((Object)MosaicImageReader.incompatibleImageType(tile));
                            }
                            break;
                        }
                        case 3: {
                            imageType = this.getRawImageType(tiles);
                        }
                    }
                    if (imageType == null) {
                        imageType = this.getRawImageType(imageIndex);
                    }
                }
                width = destRegion.x + destRegion.width;
                height = destRegion.y + destRegion.height;
                image = imageType.createBufferedImage(width, height);
                MosaicImageReader.computeRegions(param, srcWidth, srcHeight, image, sourceRegion, destRegion);
            }
            destinationOffset = destRegion.getLocation();
        }
        controller = null;
        if (mosaicParam == null) {
            mosaicParam = new MosaicImageReadParam();
        } else if (mosaicParam.hasController() && (candidate = mosaicParam.getController()) instanceof MosaicController) {
            controller = (MosaicController)candidate;
        }
        logger = Logging.getLogger(MosaicImageReader.class);
        table = null;
        if (logger.isLoggable(this.level)) {
            table = new TableWriter(null, " \u2502 ");
            table.writeHorizontalSeparator();
            table.write("Reader\tTile\tIndex\tSize\tSource\tDestination\tSubsampling");
            table.writeHorizontalSeparator();
        }
        while (true) {
            for (Tile tile : tiles) {
                if (this.abortRequested()) {
                    this.processReadAborted();
                    break;
                }
                tileRegion = tile.getAbsoluteRegion();
                regionToRead = tileRegion.intersection(sourceRegion);
                xOffset = (regionToRead.x - sourceRegion.x) % xSubsampling;
                yOffset = (regionToRead.y - sourceRegion.y) % ySubsampling;
                if (xOffset != 0) {
                    regionToRead.x -= xOffset;
                    regionToRead.width += xOffset;
                    if (regionToRead.x < tileRegion.x) {
                        regionToRead.x = tileRegion.x;
                        if (regionToRead.width > tileRegion.width) {
                            regionToRead.width = tileRegion.width;
                        }
                    }
                }
                if (yOffset != 0) {
                    regionToRead.y -= yOffset;
                    regionToRead.height += yOffset;
                    if (regionToRead.y < tileRegion.y) {
                        regionToRead.y = tileRegion.y;
                        if (regionToRead.height > tileRegion.height) {
                            regionToRead.height = tileRegion.height;
                        }
                    }
                }
                if (regionToRead.isEmpty()) continue;
                if (destRegion != null) {
                    xOffset = (regionToRead.x - sourceRegion.x) / xSubsampling;
                    yOffset = (regionToRead.y - sourceRegion.y) / ySubsampling;
                    destinationOffset.x = destRegion.x + xOffset;
                    destinationOffset.y = destRegion.y + yOffset;
                }
                if (!MosaicImageReader.$assertionsDisabled && !tileRegion.contains(regionToRead)) {
                    throw new AssertionError(regionToRead);
                }
                regionToRead.translate(-tileRegion.x, -tileRegion.y);
                subsampling.setSize(tile.getSubsampling());
                if (!MosaicImageReader.$assertionsDisabled && xSubsampling % subsampling.width != 0) {
                    throw new AssertionError(subsampling);
                }
                if (!MosaicImageReader.$assertionsDisabled && ySubsampling % subsampling.height != 0) {
                    throw new AssertionError(subsampling);
                }
                xOffset = regionToRead.x % subsampling.width;
                yOffset = regionToRead.y % subsampling.height;
                regionToRead.x /= subsampling.width;
                regionToRead.y /= subsampling.height;
                if (xOffset < 0) {
                    --regionToRead.x;
                    xOffset = subsampling.width - xOffset;
                }
                if (yOffset < 0) {
                    --regionToRead.y;
                    yOffset = subsampling.height - yOffset;
                }
                regionToRead.width += xOffset;
                regionToRead.height += yOffset;
                regionToRead.width /= subsampling.width;
                regionToRead.height /= subsampling.height;
                subsampling.width = xSubsampling / subsampling.width;
                subsampling.height = ySubsampling / subsampling.height;
                tileIndex = tile.getImageIndex();
                if (table != null) {
                    table.write(Tile.toString(tile.getImageReaderSpi()));
                    table.nextColumn();
                    table.write(tile.getInputName());
                    table.nextColumn();
                    table.write(String.valueOf(tileIndex));
                    MosaicImageReader.format(table, regionToRead.width, regionToRead.height);
                    MosaicImageReader.format(table, regionToRead.x, regionToRead.y);
                    MosaicImageReader.format(table, destinationOffset.x, destinationOffset.y);
                    MosaicImageReader.format(table, subsampling.width, subsampling.height);
                    table.nextLine();
                    continue;
                }
                reader = tile.getImageReader(this, true, true);
                tileParam = mosaicParam.getCachedTileParameters(reader);
                tileParam.setDestinationType(null);
                tileParam.setDestination(image);
                tileParam.setDestinationOffset(destinationOffset);
                if (tileParam.canSetSourceRenderSize()) {
                    tileParam.setSourceRenderSize(null);
                }
                tileParam.setSourceRegion(regionToRead);
                tileParam.setSourceSubsampling(subsampling.width, subsampling.height, 0, 0);
                if (controller != null) {
                    controller.configure(tile, tileParam);
                }
                var30_36 = this;
                synchronized (var30_36) {
                    this.reading = reader;
                }
                try {
                    output = reader.read(tileIndex, tileParam);
                }
                finally {
                    var30_36 = this;
                    synchronized (var30_36) {
                        this.reading = null;
                    }
                }
                if (image == null) {
                    image = output;
                    continue;
                }
                if (output == image) continue;
                throw new IIOException("Incompatible data format.");
            }
            if (table == null) break;
            table.writeHorizontalSeparator();
            message = new StringBuilder();
            message.append('[').append(sourceRegion.x).append(',').append(sourceRegion.y).append(" - ").append(sourceRegion.x + sourceRegion.width).append(',').append(sourceRegion.y + sourceRegion.height).append(']');
            area = message.toString();
            message.setLength(0);
            message.append(Vocabulary.format((int)126, (Object)area)).append(System.getProperty("line.separator", "\n")).append(table);
            record = new LogRecord(this.level, message.toString());
            record.setSourceClassName(MosaicImageReader.class.getName());
            record.setSourceMethodName("read");
            record.setLoggerName(logger.getName());
            logger.log(record);
            table = null;
        }
        this.processImageComplete();
        return image;
    }

    @Override
    public BufferedImage readTile(int imageIndex, int tileX, int tileY) throws IOException {
        int width = this.getTileWidth(imageIndex);
        int height = this.getTileHeight(imageIndex);
        Rectangle sourceRegion = new Rectangle(tileX * width, tileY * height, width, height);
        MosaicImageReadParam param = this.getDefaultReadParam();
        param.setSourceRegion(sourceRegion);
        return this.read(imageIndex, param);
    }

    private static void format(TableWriter table, int x, int y) {
        table.nextColumn();
        table.write(40);
        table.write(String.valueOf(x));
        table.write(44);
        table.write(String.valueOf(y));
        table.write(41);
    }

    @Override
    public synchronized void abort() {
        super.abort();
        if (this.reading != null) {
            this.reading.abort();
        }
    }

    final Object getRawInput(ImageReader reader) {
        return this.readerInputs.get(reader);
    }

    final void setRawInput(ImageReader reader, Object input) {
        this.readerInputs.put(reader, input);
    }

    public void close() throws IOException {
        for (Map.Entry<ImageReader, Object> entry : this.readerInputs.entrySet()) {
            ImageReader reader = entry.getKey();
            Object rawInput = entry.getValue();
            Object input = reader.getInput();
            entry.setValue(null);
            reader.setInput(null);
            if (input == rawInput) continue;
            Tile.close(input);
        }
    }

    @Override
    public void dispose() {
        this.input = null;
        try {
            this.close();
        }
        catch (IOException e) {
            Logging.unexpectedException(MosaicImageReader.class, (String)"dispose", (Throwable)e);
        }
        this.readerInputs.clear();
        for (ImageReader reader : this.readers.values()) {
            reader.dispose();
        }
        this.readers.clear();
        super.dispose();
    }

    public static class Spi
    extends ImageReaderSpi {
        static final String[] NAMES = new String[]{"mosaic"};
        static final Class<?>[] INPUT_TYPES = new Class[]{TileManager[].class, TileManager.class, Tile[].class, Collection.class};
        public static final Spi DEFAULT = new Spi();

        public Spi() {
            this.vendorName = "GeoTools";
            this.version = GeoTools.getVersion().toString();
            this.names = NAMES;
            this.inputTypes = INPUT_TYPES;
            this.pluginClassName = "org.geotools.image.io.mosaic.MosaicImageReader";
        }

        public boolean canDecodeInput(Object source) throws IOException {
            if (source != null) {
                Class<?> type = source.getClass();
                for (Class inputType : this.inputTypes) {
                    if (!inputType.isAssignableFrom(type)) continue;
                    return true;
                }
            }
            return false;
        }

        public ImageReader createReaderInstance(Object extension) throws IOException {
            return new MosaicImageReader(this);
        }

        public String getDescription(Locale locale) {
            return "Mosaic Image Reader";
        }
    }
}

