/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.csv;

import com.csvreader.CsvReader;
import com.vividsolutions.jts.geom.Point;
import java.io.IOException;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.csv.CSVDataStore;
import org.geotools.data.csv.CSVFeatureReader;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVFeatureSource
extends ContentFeatureSource {
    public CSVFeatureSource(ContentEntry entry, Query query) {
        super(entry, query);
    }

    public CSVDataStore getDataStore() {
        return (CSVDataStore)super.getDataStore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ReferencedEnvelope getBoundsInternal(Query query) throws IOException {
        ReferencedEnvelope bounds = new ReferencedEnvelope(this.getSchema().getCoordinateReferenceSystem());
        FeatureReader<SimpleFeatureType, SimpleFeature> featureReader = this.getReaderInternal(query);
        try {
            while (featureReader.hasNext()) {
                SimpleFeature feature = (SimpleFeature)featureReader.next();
                bounds.include(feature.getBounds());
            }
        }
        finally {
            featureReader.close();
        }
        return bounds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getCountInternal(Query query) throws IOException {
        CsvReader reader = this.getDataStore().read();
        try {
            boolean connect = reader.readHeaders();
            if (!connect) {
                throw new IOException("Unable to connect");
            }
            int count = 0;
            while (reader.readRecord()) {
                ++count;
            }
            int n = count;
            return n;
        }
        finally {
            reader.close();
        }
    }

    protected FeatureReader<SimpleFeatureType, SimpleFeature> getReaderInternal(Query query) throws IOException {
        return new CSVFeatureReader(this.getState(), query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SimpleFeatureType buildFeatureType() throws IOException {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName(this.entry.getName());
        CsvReader reader = this.getDataStore().read();
        try {
            SimpleFeatureType SCHEMA;
            boolean success = reader.readHeaders();
            if (!success) {
                throw new IOException("Header of CSV file not available");
            }
            builder.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            builder.add("Location", Point.class);
            for (String column : reader.getHeaders()) {
                if ("lat".equalsIgnoreCase(column) || "lon".equalsIgnoreCase(column)) continue;
                builder.add(column, String.class);
            }
            SimpleFeatureType simpleFeatureType = SCHEMA = builder.buildFeatureType();
            return simpleFeatureType;
        }
        finally {
            reader.close();
        }
    }
}

