/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.db2;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.db2.DB2DataStore;
import org.geotools.data.db2.DB2SQLBuilder;
import org.geotools.data.jdbc.JDBC1DataStore;
import org.geotools.data.jdbc.JDBCFeatureStore;
import org.geotools.filter.SQLEncoderException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DB2FeatureStore
extends JDBCFeatureStore {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.db2");

    public DB2FeatureStore(DB2DataStore dataStore, SimpleFeatureType featureType) {
        super((JDBC1DataStore)dataStore, featureType);
    }

    public ReferencedEnvelope getBounds(Query query) throws IOException {
        ReferencedEnvelope env = new ReferencedEnvelope();
        CoordinateReferenceSystem crs = null;
        String typeName = "null";
        if (this.getSchema() != null) {
            typeName = this.getSchema().getTypeName();
            GeometryDescriptor geomType = this.getSchema().getGeometryDescriptor();
            if (query.getFilter() != Filter.EXCLUDE) {
                String sqlStmt = null;
                try {
                    DB2SQLBuilder builder = (DB2SQLBuilder)((DB2DataStore)this.getDataStore()).getSqlBuilder(typeName);
                    sqlStmt = builder.buildSQLBoundsQuery(typeName, (AttributeDescriptor)geomType, query.getFilter());
                }
                catch (SQLEncoderException e) {
                    throw new IOException("SQLEncoderException: " + (Object)((Object)e));
                }
                Connection conn = null;
                Transaction transaction = null;
                Statement statement = null;
                ResultSet results = null;
                try {
                    conn = this.getConnection();
                    transaction = this.getTransaction();
                    statement = conn.createStatement();
                    results = statement.executeQuery(sqlStmt);
                    if (results.next()) {
                        double minx = results.getDouble(1);
                        double miny = results.getDouble(2);
                        double maxx = results.getDouble(3);
                        double maxy = results.getDouble(4);
                        env = new ReferencedEnvelope(minx, maxx, miny, maxy, null);
                    } else {
                        env = new ReferencedEnvelope();
                    }
                }
                catch (SQLException e) {
                    this.closeAll(results, statement, conn, transaction, e);
                    System.out.println(e);
                    throw new DataSourceException("Could not get bounds " + query.getHandle(), (Throwable)e);
                }
                this.closeAll(results, statement, conn, transaction, null);
            }
            crs = geomType.getCoordinateReferenceSystem();
            env = new ReferencedEnvelope((Envelope)env, crs);
        }
        LOGGER.finer(String.valueOf(typeName) + " bounds: " + env.toString());
        return env;
    }

    protected void closeAll(ResultSet rs, Statement stmt, Connection conn, Transaction transaction, SQLException e) {
        this.close(rs);
        this.close(stmt);
        this.close(conn, transaction, e);
    }

    public int count(Query query, Transaction transaction) throws IOException {
        int count = 0;
        String typeName = "null";
        Filter filter = query.getFilter();
        if (this.getSchema() != null) {
            typeName = this.getSchema().getTypeName();
            GeometryDescriptor geomType = this.getSchema().getGeometryDescriptor();
            if (filter != Filter.EXCLUDE) {
                DB2SQLBuilder builder = (DB2SQLBuilder)((DB2DataStore)this.getDataStore()).getSqlBuilder(typeName);
                Connection conn = null;
                Statement statement = null;
                ResultSet results = null;
                try {
                    conn = this.getConnection();
                    StringBuffer sql = new StringBuffer();
                    sql.append("SELECT COUNT(*) as cnt");
                    builder.sqlFrom(sql, typeName);
                    builder.sqlWhere(sql, filter);
                    statement = conn.createStatement();
                    results = statement.executeQuery(sql.toString());
                    if (results.next()) {
                        count = results.getInt("cnt");
                    }
                }
                catch (SQLException e) {
                    this.closeAll(results, statement, conn, transaction, e);
                    System.out.println(e);
                    throw new DataSourceException("Could not get count " + query.getHandle(), (Throwable)e);
                }
                catch (SQLEncoderException e) {
                    this.closeAll(results, statement, conn, transaction, null);
                    System.out.println((Object)e);
                    throw new DataSourceException("Could not get count " + query.getHandle(), (Throwable)e);
                }
                this.closeAll(results, statement, conn, transaction, null);
            }
        }
        LOGGER.finer(String.valueOf(typeName) + " count: " + count);
        return count;
    }
}

