/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.epsg;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.geotools.factory.Hints;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.epsg.FactoryUsingOracleSQL;
import org.geotools.referencing.factory.epsg.ThreadedEpsgFactory;
import org.geotools.util.logging.Logging;

public class ThreadedOracleEpsgFactory
extends ThreadedEpsgFactory {
    public static final String CONFIGURATION_FILE = "EPSG-DataSource.properties";
    private String schema;

    public ThreadedOracleEpsgFactory() {
        this(null);
    }

    public ThreadedOracleEpsgFactory(Hints hints) {
        super(hints, 95);
    }

    private static Properties load() {
        Properties p = new Properties();
        File file = new File(CONFIGURATION_FILE);
        if (!file.isFile() && !(file = new File(System.getProperty("user.home", "."), CONFIGURATION_FILE)).isFile()) {
            return p;
        }
        try {
            FileInputStream in = new FileInputStream(file);
            p.load(in);
            ((InputStream)in).close();
        }
        catch (IOException exception) {
            Logging.unexpectedException((String)"org.geotools.referencing.factory", DataSource.class, (String)"<init>", (Throwable)exception);
        }
        return p;
    }

    protected DataSource createDataSource() throws SQLException {
        DataSource source = super.createDataSource();
        if (source != null) {
            return source;
        }
        Properties p = ThreadedOracleEpsgFactory.load();
        try {
            int portNumber = Integer.parseInt(p.getProperty("portNumber", "5432"));
        }
        catch (NumberFormatException exception) {
            int portNumber = 5432;
            Logging.unexpectedException((String)"org.geotools.referencing.factory", DataSource.class, (String)"<init>", (Throwable)exception);
        }
        String serverName = p.getProperty("serverName", "localhost");
        String databaseName = p.getProperty("databaseName", "EPSG");
        String user = p.getProperty("user", "Geotools");
        String password = p.getProperty("password", "Geotools");
        this.schema = p.getProperty("schema", null);
        return source;
    }

    protected AbstractAuthorityFactory createBackingStore(Hints hints) throws SQLException {
        Connection connection = this.getDataSource().getConnection();
        FactoryUsingOracleSQL factory = new FactoryUsingOracleSQL(hints, connection);
        if (this.schema != null) {
            factory.setSchema(this.schema);
        }
        return factory;
    }
}

