/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.util.algorithm2D;

import org.geotools.geometry.iso.topograph2D.Coordinate;
import org.geotools.geometry.iso.util.algorithm2D.NotRepresentableException;

public class HCoordinate {
    public double x;
    public double y;
    public double w;

    public static Coordinate intersection(Coordinate p1, Coordinate p2, Coordinate q1, Coordinate q2) throws NotRepresentableException {
        HCoordinate l1 = new HCoordinate(new HCoordinate(p1), new HCoordinate(p2));
        HCoordinate l2 = new HCoordinate(new HCoordinate(q1), new HCoordinate(q2));
        HCoordinate intHCoord = new HCoordinate(l1, l2);
        Coordinate intPt = intHCoord.getCoordinate();
        return intPt;
    }

    public HCoordinate() {
        this.x = 0.0;
        this.y = 0.0;
        this.w = 1.0;
    }

    public HCoordinate(double _x, double _y, double _w) {
        this.x = _x;
        this.y = _y;
        this.w = _w;
    }

    public HCoordinate(double _x, double _y) {
        this.x = _x;
        this.y = _y;
        this.w = 1.0;
    }

    public HCoordinate(Coordinate p) {
        this.x = p.x;
        this.y = p.y;
        this.w = 1.0;
    }

    public HCoordinate(HCoordinate p1, HCoordinate p2) {
        this.x = p1.y * p2.w - p2.y * p1.w;
        this.y = p2.x * p1.w - p1.x * p2.w;
        this.w = p1.x * p2.y - p2.x * p1.y;
    }

    public double getX() throws NotRepresentableException {
        double a = this.x / this.w;
        if (Double.isNaN(a) || Double.isInfinite(a)) {
            throw new NotRepresentableException();
        }
        return a;
    }

    public double getY() throws NotRepresentableException {
        double a = this.y / this.w;
        if (Double.isNaN(a) || Double.isInfinite(a)) {
            throw new NotRepresentableException();
        }
        return a;
    }

    public Coordinate getCoordinate() throws NotRepresentableException {
        Coordinate p = new Coordinate();
        p.x = this.getX();
        p.y = this.getY();
        return p;
    }
}

