/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.util.algorithmND;

import java.util.Iterator;
import org.geotools.geometry.iso.aggregate.MultiPointImpl;
import org.geotools.geometry.iso.complex.CompositePointImpl;
import org.geotools.geometry.iso.coordinate.DirectPositionImpl;
import org.geotools.geometry.iso.primitive.PointImpl;
import org.geotools.geometry.iso.root.GeometryImpl;
import org.opengis.geometry.primitive.Point;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class CentroidPoint {
    private CoordinateReferenceSystem crs = null;
    private int ptCount = 0;
    DirectPositionImpl centSum = null;

    public CentroidPoint(CoordinateReferenceSystem crs) {
        this.crs = crs;
        this.centSum = new DirectPositionImpl(crs);
    }

    public void add(GeometryImpl geom) {
        if (geom instanceof PointImpl) {
            this.add(((PointImpl)geom).getPosition());
        } else if (geom instanceof MultiPointImpl) {
            Iterator<Point> points = ((MultiPointImpl)geom).getElements().iterator();
            while (points.hasNext()) {
                this.add((DirectPositionImpl)points.next().getPosition());
            }
        } else if (geom instanceof CompositePointImpl) {
            this.add((DirectPositionImpl)((CompositePointImpl)geom).getGenerators().get(0));
        }
    }

    private void add(DirectPositionImpl pt) {
        ++this.ptCount;
        this.centSum.add(pt.getCoordinates());
    }

    public DirectPositionImpl getCentroid() {
        this.centSum.divideBy(this.ptCount);
        return this.centSum;
    }
}

