/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.util.elem2D;

import java.awt.geom.Point2D;
import java.util.HashSet;
import java.util.Vector;
import org.geotools.geometry.iso.util.elem2D.Edge2D;
import org.geotools.geometry.iso.util.elem2D.Simplex2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Node2D
extends Point2D.Double {
    public int id = -1;
    public Object link = null;
    public Object object = null;

    Node2D() {
    }

    public Node2D(Point2D point2D) {
        super(point2D.getX(), point2D.getY());
    }

    public Node2D(double x, double y) {
        super(x, y);
    }

    public Object getObject() {
        return this.object;
    }

    public boolean hasID() {
        return this.id != -1;
    }

    public boolean hasEdge() {
        return this.link instanceof Edge2D ? this.link != null : false;
    }

    public boolean hasSimplex() {
        return this.link instanceof Simplex2D ? this.link != null : false;
    }

    public Edge2D getEdge(Node2D n) {
        if (this.link instanceof Edge2D[] && this.link != null) {
            Edge2D[] e = (Edge2D[])this.link;
            for (int i = 0; i < e.length; ++i) {
                if (e[i].getNode1() != n && e[i].getNode2() != n) continue;
                return e[i];
            }
        }
        return null;
    }

    public Edge2D[] getEdges() {
        return this.link instanceof Edge2D[] ? (Edge2D[])this.link : null;
    }

    public Simplex2D[] getSimplices(Node2D node2D) {
        Simplex2D[] simplex2DArray;
        HashSet<Simplex2D> hs = this.getSimplices();
        Simplex2D s0 = null;
        Simplex2D s1 = null;
        for (Simplex2D s : hs) {
            if (!s.hasPoint(node2D)) continue;
            if (s0 == null) {
                s0 = s;
                continue;
            }
            if (s1 != null) continue;
            s1 = s;
            return new Simplex2D[]{s0, s1};
        }
        if (s0 == null) {
            simplex2DArray = null;
        } else {
            Simplex2D[] simplex2DArray2 = new Simplex2D[1];
            simplex2DArray = simplex2DArray2;
            simplex2DArray2[0] = s0;
        }
        return simplex2DArray;
    }

    public Simplex2D getSimplex() {
        return this.link instanceof Simplex2D ? (Simplex2D)this.link : null;
    }

    public HashSet<Simplex2D> getSimplices() {
        HashSet<Simplex2D> simplices = new HashSet<Simplex2D>();
        if (this.link instanceof Simplex2D) {
            if (this.link != null) {
                this.getSimplices((Simplex2D)this.link, simplices);
            }
        } else {
            Edge2D[] edges = (Edge2D[])this.link;
            for (int i = 0; i < edges.length; ++i) {
                Edge2D edge = edges[i];
                Simplex2D simplex = edge.getRightSimplex();
                if (simplex != null) {
                    this.getSimplices(simplex, simplices);
                }
                if ((simplex = edge.getLeftSimplex()) == null) continue;
                this.getSimplices(simplex, simplices);
            }
        }
        return simplices;
    }

    private void getSimplices(Simplex2D simplex, HashSet<Simplex2D> simplices) {
        int[] side;
        Simplex2D s0;
        if (simplex != null) {
            simplices.add(simplex);
        }
        if ((s0 = simplex.getNeighbourSimplex((side = simplex.getSides(this))[0])) != null && !simplices.contains(s0)) {
            this.getSimplices(s0, simplices);
        }
        if ((s0 = simplex.getNeighbourSimplex(side[1])) != null && !simplices.contains(s0)) {
            this.getSimplices(s0, simplices);
        }
    }

    public void linkSimplex(Simplex2D s) {
        this.link = s;
    }

    public void linkEdge(Edge2D e) {
        if (this.link instanceof Edge2D[]) {
            int length = ((Edge2D[])this.link).length;
            Edge2D[] newLink = new Edge2D[length + 1];
            System.arraycopy(this.link, 0, newLink, 0, length);
            newLink[length] = e;
            this.link = newLink;
        } else {
            this.link = new Edge2D[1];
            ((Edge2D[])this.link)[0] = e;
        }
    }

    public void unlinkEdge(Edge2D e) {
        if (!(this.link instanceof Simplex2D) && this.link != null) {
            Edge2D[] edges = (Edge2D[])this.link;
            Vector<Edge2D> vec = new Vector<Edge2D>(edges.length);
            for (int i = 0; i < edges.length; ++i) {
                if (edges[i] == e) continue;
                vec.add(edges[i]);
            }
            edges = new Edge2D[vec.size()];
            this.link = vec.toArray(edges);
        }
    }

    public void appendEdges(Edge2D[] edges) {
        if (this.link instanceof Simplex2D) {
            this.link = edges;
        } else {
            Edge2D e;
            int i;
            Vector<Edge2D> vec = new Vector<Edge2D>(20);
            Edge2D[] ee = this.getEdges();
            for (i = 0; i < ee.length; ++i) {
                e = ee[i];
                if (vec.contains(e)) continue;
                vec.add(e);
            }
            for (i = 0; i < edges.length; ++i) {
                e = edges[i];
                if (vec.contains(e)) continue;
                vec.add(e);
            }
            this.link = vec.toArray(new Edge2D[vec.size()]);
        }
    }

    public boolean hasEdge(Edge2D edge) {
        Edge2D[] edges = this.getEdges();
        if (edges == null) {
            return false;
        }
        for (int i = 0; i < edges.length; ++i) {
            if (edges[i] != edge) continue;
            return true;
        }
        return false;
    }
}

