/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverageio.jp2k;

import it.geosolutions.imageio.imageioimpl.imagereadmt.DefaultCloneableImageReadParam;
import it.geosolutions.imageio.stream.input.FileImageInputStreamExt;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.geotools.coverageio.jp2k.JP2KFormatFactory;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.metadata.iso.spatial.PixelTranslation;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;

class Utils {
    static final IOFileFilter FILEFILTER = Utils.createFilter();
    static final Logger LOGGER = Logging.getLogger((String)Utils.class.toString());
    static final AffineTransform CENTER_TO_CORNER = AffineTransform.getTranslateInstance(PixelTranslation.getPixelTranslation((PixelInCell)PixelInCell.CELL_CORNER), PixelTranslation.getPixelTranslation((PixelInCell)PixelInCell.CELL_CORNER));
    static final AffineTransform CORNER_TO_CENTER = AffineTransform.getTranslateInstance(-PixelTranslation.getPixelTranslation((PixelInCell)PixelInCell.CELL_CORNER), -PixelTranslation.getPixelTranslation((PixelInCell)PixelInCell.CELL_CORNER));
    public static final int DEFAULT_PRIORITY = 5;

    Utils() {
    }

    static URL checkSource(Object source) throws MalformedURLException, DataSourceException {
        URL sourceURL = null;
        if (source instanceof URL) {
            sourceURL = (URL)source;
            source = DataUtilities.urlToFile((URL)sourceURL);
        } else if (source instanceof String) {
            String tempSource = (String)source;
            File tempFile = new File(tempSource);
            if (!tempFile.exists()) {
                try {
                    sourceURL = new URL(tempSource);
                    source = DataUtilities.urlToFile((URL)sourceURL);
                }
                catch (MalformedURLException e) {
                    sourceURL = null;
                    source = null;
                }
            } else {
                sourceURL = DataUtilities.fileToURL((File)tempFile);
                source = tempFile;
            }
        } else if (source instanceof FileImageInputStreamExt) {
            File inputFile = ((FileImageInputStreamExt)source).getFile();
            source = inputFile;
        }
        if (source instanceof File) {
            File sourceFile = (File)source;
            if (!sourceFile.isDirectory()) {
                sourceURL = ((File)source).toURI().toURL();
            }
        } else {
            sourceURL = null;
        }
        return sourceURL;
    }

    static ReferencedEnvelope getReferencedEnvelopeFromGeographicBoundingBox(GeographicBoundingBox geographicBBox) {
        Utilities.ensureNonNull((String)"GeographicBoundingBox", (Object)geographicBBox);
        return new ReferencedEnvelope(geographicBBox.getEastBoundLongitude(), geographicBBox.getWestBoundLongitude(), geographicBBox.getSouthBoundLatitude(), geographicBBox.getNorthBoundLatitude(), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    }

    static ImageReadParam cloneImageReadParam(ImageReadParam param) {
        DefaultCloneableImageReadParam newParam = new DefaultCloneableImageReadParam();
        if (param.hasController()) {
            newParam.setController(param.getController());
        }
        newParam.setDestination(param.getDestination());
        if (param.getDestinationType() != null) {
            newParam.setDestinationType(param.getDestinationType());
        }
        newParam.setDestinationBands(param.getDestinationBands());
        newParam.setDestinationOffset(param.getDestinationOffset());
        newParam.setSourceBands(param.getSourceBands());
        newParam.setSourceRegion(param.getSourceRegion());
        if (param.getSourceMaxProgressivePass() != Integer.MAX_VALUE) {
            newParam.setSourceProgressivePasses(param.getSourceMinProgressivePass(), param.getSourceNumProgressivePasses());
        }
        if (param.canSetSourceRenderSize()) {
            newParam.setSourceRenderSize(param.getSourceRenderSize());
        }
        newParam.setSourceSubsampling(param.getSourceXSubsampling(), param.getSourceYSubsampling(), param.getSubsamplingXOffset(), param.getSubsamplingYOffset());
        return newParam;
    }

    static ImageReader getReader(ImageInputStream inStream) {
        Utilities.ensureNonNull((String)"inStream", (Object)inStream);
        try {
            File file;
            if (inStream instanceof FileImageInputStreamExt && FILEFILTER.accept(file = ((FileImageInputStreamExt)inStream).getFile())) {
                return JP2KFormatFactory.getCachedSpi().createReaderInstance();
            }
            return null;
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning(e.getLocalizedMessage());
            }
            return null;
        }
    }

    static Rectangle getDimension(int imageIndex, ImageInputStream inStream, ImageReader reader) throws IOException {
        Utilities.ensureNonNull((String)"inStream", (Object)inStream);
        Utilities.ensureNonNull((String)"reader", (Object)reader);
        if (imageIndex < 0) {
            throw new IllegalArgumentException(Errors.format((int)79, (Object)imageIndex));
        }
        inStream.reset();
        reader.setInput(inStream);
        return new Rectangle(0, 0, reader.getWidth(imageIndex), reader.getHeight(imageIndex));
    }

    static ImageInputStream getInputStream(File file) throws IOException {
        ImageInputStream inStream = ImageIO.createImageInputStream(file);
        if (inStream == null) {
            return null;
        }
        return inStream;
    }

    public static double bytes2double(byte[] bytes, int start) {
        int i = 0;
        int length = 8;
        int count = 0;
        byte[] tmp = new byte[8];
        i = start;
        while (i < start + 8) {
            tmp[count] = bytes[i];
            ++count;
            ++i;
        }
        long accum = 0L;
        i = 0;
        int shiftBy = 0;
        while (shiftBy < 64) {
            accum |= (long)(tmp[i] & 0xFF) << shiftBy;
            ++i;
            shiftBy += 8;
        }
        return Double.longBitsToDouble(accum);
    }

    public static long bytes2long(byte[] bytes, int start) {
        int i = 0;
        int length = 4;
        int count = 0;
        byte[] tmp = new byte[4];
        i = start;
        while (i < start + 4) {
            tmp[count] = bytes[i];
            ++count;
            ++i;
        }
        long accum = 0L;
        i = 0;
        int shiftBy = 0;
        while (shiftBy < 32) {
            accum |= (long)(tmp[i] & 0xFF) << shiftBy;
            ++i;
            shiftBy += 8;
        }
        return accum;
    }

    private static IOFileFilter createFilter() {
        IOFileFilter fileFilter = Utils.includeFilters(FileFilterUtils.suffixFileFilter((String)"jp2"), FileFilterUtils.suffixFileFilter((String)"JP2"), FileFilterUtils.suffixFileFilter((String)"j2c"), FileFilterUtils.suffixFileFilter((String)"J2C"), FileFilterUtils.suffixFileFilter((String)"jpx"), FileFilterUtils.suffixFileFilter((String)"JPX"), FileFilterUtils.suffixFileFilter((String)"jp2k"), FileFilterUtils.suffixFileFilter((String)"JP2K"), FileFilterUtils.nameFileFilter((String)"jpeg2000"));
        return fileFilter;
    }

    static IOFileFilter excludeFilters(IOFileFilter inputFilter, IOFileFilter ... filters) {
        IOFileFilter retFilter = inputFilter;
        IOFileFilter[] iOFileFilterArray = filters;
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            IOFileFilter filter = iOFileFilterArray[n2];
            retFilter = FileFilterUtils.andFileFilter((IOFileFilter)retFilter, (IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)filter));
            ++n2;
        }
        return retFilter;
    }

    static IOFileFilter includeFilters(IOFileFilter inputFilter, IOFileFilter ... filters) {
        IOFileFilter retFilter = inputFilter;
        IOFileFilter[] iOFileFilterArray = filters;
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            IOFileFilter filter = iOFileFilterArray[n2];
            retFilter = FileFilterUtils.orFileFilter((IOFileFilter)retFilter, (IOFileFilter)filter);
            ++n2;
        }
        return retFilter;
    }
}

