/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts.spatialschema;

import java.util.List;
import org.geotools.geometry.jts.spatialschema.geometry.DirectPositionImpl;
import org.geotools.geometry.jts.spatialschema.geometry.geometry.PointArrayImpl;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.geometry.PositionFactory;
import org.opengis.geometry.Precision;
import org.opengis.geometry.coordinate.PointArray;
import org.opengis.geometry.coordinate.Position;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class PositionFactoryImpl
implements PositionFactory {
    private CoordinateReferenceSystem crs;

    public PositionFactoryImpl() {
        this((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    }

    public PositionFactoryImpl(CoordinateReferenceSystem crs) {
        this.crs = crs;
    }

    public DirectPosition createDirectPosition(double[] ordiantes) throws MismatchedDimensionException {
        return new DirectPositionImpl(this.crs, ordiantes);
    }

    public Position createPosition(Position position) {
        return new DirectPositionImpl(position.getPosition());
    }

    public List createPositionList() {
        return new PointArrayImpl(this.crs);
    }

    public List createPositionList(double[] coordinates, int start, int end) {
        PointArrayImpl array = new PointArrayImpl(this.crs);
        int N = this.crs.getCoordinateSystem().getDimension();
        int i = start;
        while (i < end) {
            double[] ords = new double[N];
            System.arraycopy(coordinates, i, ords, 0, N);
            array.add(this.createDirectPosition(ords));
            i += N;
        }
        return array;
    }

    public List createPositionList(float[] coordinates, int start, int end) {
        PointArrayImpl array = new PointArrayImpl(this.crs);
        int N = this.crs.getCoordinateSystem().getDimension();
        int i = start;
        while (i < end) {
            double[] ords = new double[N];
            System.arraycopy(coordinates, i, ords, 0, N);
            array.add(this.createDirectPosition(ords));
            i += N;
        }
        return array;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public Precision getPrecision() {
        return null;
    }

    public PointArray createPointArray(float[] array, int start, int end) {
        PointArray pointArray = this.createPointArray();
        int D = this.crs.getCoordinateSystem().getDimension();
        if (D == 2) {
            int i = start;
            while (i < end) {
                double[] ordinates = new double[]{array[i], array[i + 1]};
                pointArray.add((Object)new DirectPositionImpl(this.crs, ordinates));
                i += D;
            }
        } else if (D == 3) {
            int i = start;
            while (i < end) {
                double[] ordinates = new double[]{array[i], array[i + 1], array[i + 2]};
                pointArray.add((Object)new DirectPositionImpl(this.crs, ordinates));
                i += D;
            }
        } else {
            int i = start;
            while (i < end) {
                double[] ordinates = new double[D];
                int o = 0;
                while (i < D) {
                    ordinates[o] = array[i + o];
                    ++i;
                }
                pointArray.add((Object)new DirectPositionImpl(this.crs, ordinates));
                i += D;
            }
        }
        return pointArray;
    }

    public PointArray createPointArray(double[] array, int start, int end) {
        PointArray pointArray = this.createPointArray();
        int n = this.crs.getCoordinateSystem().getDimension();
        double[] ordinates = new double[n];
        int i = start;
        while (i < array.length && i <= end) {
            int j = i;
            while (j < i + n) {
                ordinates[j - i] = array[j];
                ++j;
            }
            pointArray.add((Object)this.createDirectPosition(ordinates));
            i += n;
        }
        return pointArray;
    }

    public PointArray createPointArray() {
        return new PointArrayImpl(this.crs);
    }
}

