/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts.spatialschema.geometry.primitive;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.geotools.geometry.jts.JTSGeometry;
import org.geotools.geometry.jts.JTSUtils;
import org.geotools.geometry.jts.spatialschema.geometry.GeometryImpl;
import org.geotools.geometry.jts.spatialschema.geometry.NotifyingArrayList;
import org.geotools.geometry.jts.spatialschema.geometry.geometry.LineStringImpl;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.complex.CompositeCurve;
import org.opengis.geometry.coordinate.ParamForPoint;
import org.opengis.geometry.coordinate.Position;
import org.opengis.geometry.primitive.Curve;
import org.opengis.geometry.primitive.CurveBoundary;
import org.opengis.geometry.primitive.CurveSegment;
import org.opengis.geometry.primitive.OrientableCurve;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CurveImpl
extends GeometryImpl
implements Curve {
    private List curveSegments = new NotifyingArrayList(this);

    public CurveImpl() {
        this(null);
    }

    public CurveImpl(CoordinateReferenceSystem crs) {
        super(crs);
    }

    public CurveBoundary getBoundary() {
        return (CurveBoundary)super.getBoundary();
    }

    public final List<CurveSegment> getSegments() {
        return this.curveSegments;
    }

    public final DirectPosition getStartPoint() {
        return ((CurveSegment)this.curveSegments.get(0)).getStartPoint();
    }

    public final DirectPosition getEndPoint() {
        return ((CurveSegment)this.curveSegments.get(this.curveSegments.size() - 1)).getEndPoint();
    }

    public double[] getTangent(double s) {
        return new double[0];
    }

    public final double getStartParam() {
        return 0.0;
    }

    public final double getEndParam() {
        return this.length(0.0, this.getEndConstructiveParam());
    }

    public final double getStartConstructiveParam() {
        return 0.0;
    }

    public final double getEndConstructiveParam() {
        return this.curveSegments.size();
    }

    public final DirectPosition forConstructiveParam(double cp) {
        int n = this.curveSegments.size();
        int i = (int)cp;
        if (i < 0) {
            i = 0;
        } else if (i > n) {
            i = n;
        }
        if (i == n) {
            return ((CurveSegment)this.curveSegments.get(n - 1)).getEndPoint();
        }
        CurveSegment cs = (CurveSegment)this.curveSegments.get(i);
        double d = cp - (double)i;
        return cs.forConstructiveParam((1.0 - d) * cs.getStartConstructiveParam() + d * cs.getEndConstructiveParam());
    }

    public final DirectPosition forParam(double s) {
        return null;
    }

    public ParamForPoint getParamForPoint(DirectPosition p) {
        return null;
    }

    public double length(Position point1, Position point2) {
        return 0.0;
    }

    public double length(double cparam1, double cparam2) {
        return 0.0;
    }

    public org.opengis.geometry.coordinate.LineString asLineString(double maxSpacing, double maxOffset) {
        int count = this.curveSegments.size();
        if (count == 1) {
            Object segment1 = this.curveSegments.get(0);
            if (segment1 instanceof org.opengis.geometry.coordinate.LineString) {
                return (org.opengis.geometry.coordinate.LineString)segment1;
            }
        } else if (count > 0) {
            boolean allLineString = true;
            LineStringImpl lsi = new LineStringImpl();
            Object ls = null;
            List retList = lsi.getControlPoints().positions();
            Object lastPoint = null;
            List segList = null;
            int i = 0;
            while (i < count && allLineString) {
                Object segment = this.curveSegments.get(0);
                if (segment instanceof org.opengis.geometry.coordinate.LineString) {
                    segList = ((org.opengis.geometry.coordinate.LineString)segment).getControlPoints().positions();
                    if (segList.get(0).equals(lastPoint)) {
                        retList.remove(retList.size() - 1);
                    }
                    retList.addAll(segList);
                    lastPoint = retList.get(retList.size() - 1);
                } else {
                    allLineString = false;
                }
                ++i;
            }
            if (allLineString) {
                return lsi;
            }
        }
        return null;
    }

    public CompositeCurve getComposite() {
        return null;
    }

    public int getOrientation() {
        return 1;
    }

    public Curve getPrimitive() {
        return this;
    }

    public Set getContainedPrimitives() {
        return Collections.EMPTY_SET;
    }

    public Set getContainingPrimitives() {
        return Collections.EMPTY_SET;
    }

    public Set getComplexes() {
        return Collections.EMPTY_SET;
    }

    public OrientableCurve[] getProxy() {
        return null;
    }

    @Override
    protected Geometry computeJTSPeer() {
        int n = this.curveSegments.size();
        ArrayList<Coordinate> allCoords = new ArrayList<Coordinate>();
        int i = 0;
        while (i < n) {
            JTSGeometry g = (JTSGeometry)this.curveSegments.get(i);
            LineString jts = (LineString)g.getJTSGeometry();
            int m = jts.getNumPoints();
            int j = 0;
            while (j < m) {
                allCoords.add(jts.getCoordinateN(j));
                ++j;
            }
            if (i != n - 1) {
                allCoords.remove(allCoords.size() - 1);
            }
            ++i;
        }
        Coordinate[] coords = new Coordinate[allCoords.size()];
        allCoords.toArray(coords);
        return JTSUtils.GEOMETRY_FACTORY.createLineString(coords);
    }
}

