/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts.spatialschema.geometry.geometry;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.factory.Hints;
import org.geotools.geometry.jts.spatialschema.geometry.DirectPositionImpl;
import org.geotools.geometry.jts.spatialschema.geometry.EnvelopeImpl;
import org.geotools.geometry.jts.spatialschema.geometry.geometry.LineSegmentImpl;
import org.geotools.geometry.jts.spatialschema.geometry.geometry.LineStringImpl;
import org.geotools.geometry.jts.spatialschema.geometry.geometry.PolygonImpl;
import org.geotools.geometry.jts.spatialschema.geometry.primitive.PolyhedralSurfaceImpl;
import org.geotools.geometry.jts.spatialschema.geometry.primitive.SurfaceBoundaryImpl;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.geometry.MismatchedReferenceSystemException;
import org.opengis.geometry.aggregate.MultiPrimitive;
import org.opengis.geometry.coordinate.Arc;
import org.opengis.geometry.coordinate.ArcByBulge;
import org.opengis.geometry.coordinate.ArcString;
import org.opengis.geometry.coordinate.ArcStringByBulge;
import org.opengis.geometry.coordinate.BSplineCurve;
import org.opengis.geometry.coordinate.BSplineSurface;
import org.opengis.geometry.coordinate.Geodesic;
import org.opengis.geometry.coordinate.GeodesicString;
import org.opengis.geometry.coordinate.GeometryFactory;
import org.opengis.geometry.coordinate.KnotType;
import org.opengis.geometry.coordinate.LineSegment;
import org.opengis.geometry.coordinate.LineString;
import org.opengis.geometry.coordinate.PointArray;
import org.opengis.geometry.coordinate.Polygon;
import org.opengis.geometry.coordinate.PolyhedralSurface;
import org.opengis.geometry.coordinate.Position;
import org.opengis.geometry.coordinate.Tin;
import org.opengis.geometry.primitive.Ring;
import org.opengis.geometry.primitive.Surface;
import org.opengis.geometry.primitive.SurfaceBoundary;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTSGeometryFactory
implements GeometryFactory {
    private CoordinateReferenceSystem crs;
    private final Map usedHints = new LinkedHashMap();

    public JTSGeometryFactory() {
        this((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    }

    public JTSGeometryFactory(Hints hints) {
        this((CoordinateReferenceSystem)hints.get((Object)Hints.CRS));
    }

    public JTSGeometryFactory(CoordinateReferenceSystem crs) {
        this.crs = crs;
        this.usedHints.put(Hints.CRS, crs);
    }

    public Map getImplementationHints() {
        return this.usedHints;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public Position createPosition(DirectPosition point) {
        return new DirectPositionImpl(point);
    }

    public DirectPosition createDirectPosition() {
        return new DirectPositionImpl(this.crs);
    }

    public DirectPosition createDirectPosition(double[] coordinates) {
        return new DirectPositionImpl(this.crs, coordinates);
    }

    public Envelope createEnvelope(DirectPosition lowerCorner, DirectPosition upperCorner) {
        return new EnvelopeImpl(lowerCorner, upperCorner);
    }

    public LineSegment createLineSegment(Position startPoint, Position endPoint) {
        LineSegmentImpl line = new LineSegmentImpl();
        line.getControlPoints().add((Object)startPoint);
        line.getControlPoints().add((Object)endPoint);
        return line;
    }

    public LineString createLineString(List points) {
        PointArray pa;
        LineStringImpl result = new LineStringImpl();
        PointArray list = pa = result.getControlPoints();
        for (Position position : points) {
            DirectPosition directPosition = position.getPosition();
            list.add(directPosition);
        }
        return result;
    }

    public Geodesic createGeodesic(Position startPoint, Position endPoint) {
        return null;
    }

    public GeodesicString createGeodesicString(List points) {
        return null;
    }

    public Arc createArc(Position startPoint, Position midPoint, Position endPoint) {
        return null;
    }

    public Arc createArc(Position startPoint, Position endPoint, double bulge, double[] normal) {
        return null;
    }

    public ArcString createArcString(List points) {
        return null;
    }

    public ArcByBulge createArcByBulge(Position startPoint, Position endPoint, double bulge, double[] normal) {
        return null;
    }

    public ArcStringByBulge createArcStringByBulge(List points, double[] bulges, List normals) {
        return null;
    }

    public BSplineCurve createBSplineCurve(int arg0, PointArray arg1, List arg2, KnotType arg3) throws MismatchedReferenceSystemException, MismatchedDimensionException {
        return null;
    }

    public Polygon createPolygon(SurfaceBoundary boundary) throws MismatchedReferenceSystemException, MismatchedDimensionException {
        PolygonImpl result = new PolygonImpl(boundary);
        return result;
    }

    public Polygon createPolygon(SurfaceBoundary boundary, Surface spanningSurface) throws MismatchedReferenceSystemException, MismatchedDimensionException {
        PolygonImpl result = new PolygonImpl(boundary, Collections.singletonList(spanningSurface));
        return result;
    }

    public Tin createTin(Set arg0, Set arg1, Set arg2, double arg3) throws MismatchedReferenceSystemException, MismatchedDimensionException {
        return null;
    }

    public SurfaceBoundary createSurfaceBoundary(Ring exterior, List interiors) throws MismatchedReferenceSystemException {
        return new SurfaceBoundaryImpl(this.crs, exterior, interiors.toArray(new Ring[interiors.size()]));
    }

    public MultiPrimitive createMultiPrimitive() {
        throw new UnsupportedOperationException("This is the JTS Wrapper Factory which only supports implementations that align with the Simple Feature for SQL Specification.");
    }

    public PolyhedralSurface createPolyhedralSurface(List<Polygon> polygons) throws MismatchedReferenceSystemException, MismatchedDimensionException {
        PolyhedralSurfaceImpl result = new PolyhedralSurfaceImpl(this.crs);
        List<Polygon> cast = polygons;
        result.getPatches().addAll(cast);
        return result;
    }

    public BSplineSurface createBSplineSurface(List arg0, int[] arg1, List[] arg2, KnotType arg3) throws MismatchedReferenceSystemException, MismatchedDimensionException {
        throw new UnsupportedOperationException("This is the JTS Wrapper Factory which only supports implementations that align with the Simple Feature for SQL Specification.");
    }
}

