/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverageio.matfile5;

import it.geosolutions.imageio.matfile5.sas.SASTileImageReaderSpi;
import java.util.Collections;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.spi.ImageReaderSpi;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.imageio.GeoToolsWriteParams;
import org.geotools.coverageio.matfile5.BaseMatFileGridFormat;
import org.geotools.coverageio.matfile5.MatFile5Reader;
import org.geotools.data.DataSourceException;
import org.geotools.factory.Hints;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.parameter.ParameterGroup;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.Format;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;

public class MatFile5Format
extends BaseMatFileGridFormat
implements Format {
    private static final Logger LOGGER = Logging.getLogger((String)MatFile5Format.class.toString());

    public MatFile5Format() {
        super((ImageReaderSpi)new SASTileImageReaderSpi());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Creating a new MatFile5Format.");
        }
        this.setInfo();
    }

    public GeoToolsWriteParams getDefaultImageIOWriteParameters() {
        throw new UnsupportedOperationException("This plugin does not support writing parameters");
    }

    public AbstractGridCoverage2DReader getReader(Object source, Hints hints) {
        try {
            return new MatFile5Reader(source, hints);
        }
        catch (DataSourceException e) {
            RuntimeException re = new RuntimeException();
            re.initCause(e);
            throw re;
        }
    }

    protected void setInfo() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("name", "MatFile5");
        info.put("description", "MatFile5 generated Format");
        info.put("vendor", "Geotools");
        info.put("docURL", "");
        info.put("version", "1.0");
        this.mInfo = Collections.unmodifiableMap(info);
        this.writeParameters = null;
        this.readParameters = new ParameterGroup((ParameterDescriptorGroup)new DefaultParameterDescriptorGroup(this.mInfo, new GeneralParameterDescriptor[]{READ_GRIDGEOMETRY2D}));
    }
}

