/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mysql;

import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.data.jdbc.GeoAPISQLBuilder;
import org.geotools.data.jdbc.fidmapper.FIDMapper;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;

public class MySQLSQLBuilder
extends GeoAPISQLBuilder {
    private boolean wkbEnabled;

    public MySQLSQLBuilder(FilterToSQL encoder) {
        super(encoder, null, null);
    }

    public MySQLSQLBuilder(FilterToSQL encoder, SimpleFeatureType ft) {
        super(encoder, ft, null);
    }

    public void sqlColumns(StringBuffer sql, FIDMapper mapper, AttributeDescriptor[] attributes) {
        int i;
        for (i = 0; i < mapper.getColumnCount(); ++i) {
            sql.append(mapper.getColumnName(i));
            if (attributes.length <= 0 && i >= mapper.getColumnCount() - 1) continue;
            sql.append(", ");
        }
        for (i = 0; i < attributes.length; ++i) {
            String colName = attributes[i].getLocalName();
            if (attributes[i] instanceof GeometryDescriptor) {
                if (this.wkbEnabled) {
                    sql.append("AsBinary(");
                } else {
                    sql.append("AsText(");
                }
                sql.append(attributes[i].getLocalName() + ") AS " + attributes[i].getLocalName());
            } else {
                sql.append(colName);
            }
            if (i >= attributes.length - 1) continue;
            sql.append(", ");
        }
    }

    public boolean isWKBEnabled() {
        return this.wkbEnabled;
    }

    public void setWKBEnabled(boolean enabled) {
        this.wkbEnabled = enabled;
    }
}

