/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.WKTWriter;
import java.io.IOException;
import java.util.logging.Logger;
import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.filter.DefaultExpression;
import org.geotools.filter.FilterCapabilities;
import org.geotools.util.logging.Logging;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.spatial.BBOX;

public class SQLEncoderMySQL
extends FilterToSQL
implements FilterVisitor {
    private static Logger LOGGER = Logging.getLogger((String)"org.geotools.filter");
    private static WKTWriter wkt = new WKTWriter();
    private static final String SQL_WILD_MULTI = "%";
    private static final String SQL_WILD_SINGLE = "_";
    private int srid;
    private String defaultGeom;
    private String escapedWildcardMulti = "\\.\\*";
    private String escapedWildcardSingle = "\\.\\?";

    public SQLEncoderMySQL() {
        this.capabilities = this.createFilterCapabilities();
        this.setSqlNameEscape("");
    }

    public SQLEncoderMySQL(int srid) {
        this.srid = srid;
    }

    protected FilterCapabilities createFilterCapabilities() {
        FilterCapabilities capabilities = new FilterCapabilities();
        capabilities.addType(0x2000000L);
        capabilities.addType(0x800000L);
        capabilities.addType(0x1000000L);
        capabilities.addAll(FilterCapabilities.LOGICAL_OPENGIS);
        capabilities.addType(65536L);
        capabilities.addType(0x200000L);
        capabilities.addType(524288L);
        capabilities.addType(131072L);
        capabilities.addType(0x100000L);
        capabilities.addType(262144L);
        capabilities.addAll(FilterCapabilities.SIMPLE_COMPARISONS_OPENGIS);
        capabilities.addType(8192L);
        capabilities.addType(PropertyIsNull.class);
        capabilities.addType(4096L);
        capabilities.addType(PropertyIsBetween.class);
        capabilities.addType(0x40000000L);
        capabilities.addType(Integer.MIN_VALUE);
        capabilities.addType(1L);
        capabilities.addType(BBOX.class);
        capabilities.addType(0x400000L);
        capabilities.addType(Id.class);
        capabilities.addType(2048L);
        capabilities.addType(PropertyIsLike.class);
        return capabilities;
    }

    public void setSRID(int srid) {
        this.srid = srid;
    }

    public void setDefaultGeometry(String name) {
        this.defaultGeom = name;
    }

    public Object visit(BBOX filter, Object extra) {
        DefaultExpression left = (DefaultExpression)filter.getExpression1();
        DefaultExpression right = (DefaultExpression)filter.getExpression2();
        try {
            this.out.write("MBRIntersects(");
            if (left == null) {
                this.out.write(this.defaultGeom);
            } else {
                left.accept((ExpressionVisitor)this, Geometry.class);
            }
            this.out.write(", ");
            if (right == null) {
                this.out.write(this.defaultGeom);
            } else {
                right.accept((ExpressionVisitor)this, Geometry.class);
            }
            this.out.write(")");
        }
        catch (IOException ioe) {
            LOGGER.warning("Unable to export filter" + ioe);
        }
        return extra;
    }

    public void visitLiteralGeometry(Literal expression) throws IOException {
        Geometry bbox = (Geometry)expression.getValue();
        String geomText = wkt.write(bbox);
        this.out.write("GeometryFromText('" + geomText + "', " + this.srid + ")");
    }

    public void visit(PropertyIsLike filter) {
        try {
            String pattern = filter.getLiteral();
            pattern = pattern.replaceAll(this.escapedWildcardMulti, SQL_WILD_MULTI);
            pattern = pattern.replaceAll(this.escapedWildcardSingle, SQL_WILD_SINGLE);
            this.out.write("UPPER(");
            filter.getExpression().accept((ExpressionVisitor)this, null);
            this.out.write(") LIKE ");
            this.out.write("UPPER('" + pattern + "')");
            String esc = filter.getEscape();
            if (pattern.indexOf(esc) != -1) {
                this.out.write(" ESCAPE '" + esc + "'");
            }
        }
        catch (IOException ioe) {
            LOGGER.warning("Unable to export filter" + ioe);
        }
    }
}

