/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.oracle.sdo.SDO;
import org.geotools.filter.AttributeExpression;
import org.geotools.filter.CompareFilter;
import org.geotools.filter.DefaultExpression;
import org.geotools.filter.Expression;
import org.geotools.filter.FidFilter;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.GeometryDistanceFilter;
import org.geotools.filter.GeometryFilter;
import org.geotools.filter.LikeFilter;
import org.geotools.filter.LiteralExpression;
import org.geotools.filter.SQLEncoder;
import org.geotools.util.logging.Logging;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.Id;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;

public class SQLEncoderOracle
extends SQLEncoder {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.filter.SQLEncoderOracle");
    private static final Map SDO_RELATE_MASK_MAP = new HashMap();
    private static final String SQL_WILD_MULTI = "%";
    private static final String SQL_WILD_SINGLE = "_";
    private static final String TOLERANCE = "0.001";
    private Map srids;
    private String fidColumn;
    private String currentGeomColumnName = null;
    boolean inGeomFilter = false;

    public SQLEncoderOracle(String fidColumn, int defaultSRID) {
        this(new HashMap());
        this.fidColumn = fidColumn;
        this.srids.put(null, new Integer(defaultSRID));
        this.setSqlNameEscape("\"");
    }

    public SQLEncoderOracle(int defaultSRID) {
        this(null, new HashMap());
        this.srids.put(null, new Integer(defaultSRID));
    }

    public SQLEncoderOracle(String fidColumn, Map srids) {
        this.fidColumn = fidColumn;
        this.srids = srids;
        Set geomCols = srids.keySet();
        if (geomCols.size() > 0) {
            this.currentGeomColumnName = (String)geomCols.iterator().next();
        }
        LOGGER.fine("SQLEncoderOracle: Geometric Column is: " + this.currentGeomColumnName);
        this.setSqlNameEscape("\"");
    }

    public SQLEncoderOracle(Map srids) {
        this(null, srids);
    }

    protected FilterCapabilities createFilterCapabilities() {
        FilterCapabilities capabilities = new FilterCapabilities();
        capabilities.addType(0x3800000L);
        capabilities.addAll(FilterCapabilities.LOGICAL_OPENGIS);
        capabilities.addType(0x3F0000L);
        capabilities.addAll(FilterCapabilities.SIMPLE_COMPARISONS_OPENGIS);
        capabilities.addType(8192L);
        capabilities.addType(PropertyIsNull.class);
        capabilities.addType(4096L);
        capabilities.addType(PropertyIsBetween.class);
        capabilities.addType(0x400000L);
        capabilities.addType(Id.class);
        capabilities.addType(0x40000000L);
        capabilities.addType(IncludeFilter.class);
        capabilities.addType(Integer.MIN_VALUE);
        capabilities.addType(ExcludeFilter.class);
        capabilities.addType(2048L);
        capabilities.addType(PropertyIsLike.class);
        capabilities.addType(1L);
        capabilities.addType(BBOX.class);
        capabilities.addType(128L);
        capabilities.addType(Contains.class);
        capabilities.addType(32L);
        capabilities.addType(Crosses.class);
        capabilities.addType(4L);
        capabilities.addType(Disjoint.class);
        capabilities.addType(2L);
        capabilities.addType(Equals.class);
        capabilities.addType(8L);
        capabilities.addType(Intersects.class);
        capabilities.addType(256L);
        capabilities.addType(Overlaps.class);
        capabilities.addType(16L);
        capabilities.addType(Touches.class);
        capabilities.addType(64L);
        capabilities.addType(Within.class);
        capabilities.addType(1024L);
        capabilities.addType(DWithin.class);
        capabilities.addType(512L);
        capabilities.addType(Beyond.class);
        return capabilities;
    }

    private void doSdoRelate(GeometryFilter geomFilter) throws IOException {
        LiteralExpression geomExpr;
        AttributeExpression attExpr;
        String mask = (String)SDO_RELATE_MASK_MAP.get(new Short(geomFilter.getFilterType()));
        Expression left = geomFilter.getLeftGeometry();
        Expression right = geomFilter.getRightGeometry();
        if (left instanceof AttributeExpression && right instanceof LiteralExpression) {
            attExpr = (AttributeExpression)left;
            geomExpr = (LiteralExpression)right;
        } else if (right instanceof AttributeExpression && left instanceof LiteralExpression) {
            attExpr = (AttributeExpression)right;
            geomExpr = (LiteralExpression)left;
        } else {
            String err = "Oracle currently supports one geometry and one attribute expr.  You gave: " + left + ", " + right;
            throw new DataSourceException(err);
        }
        if ((attExpr != null || this.currentGeomColumnName != null) && geomExpr != null && mask != null) {
            this.inGeomFilter = true;
            this.out.write("SDO_RELATE(");
            if (attExpr != null) {
                attExpr.accept((FilterVisitor)this);
            } else {
                this.out.write("\"" + this.currentGeomColumnName + "\"");
            }
            this.out.write(",");
            geomExpr.accept((FilterVisitor)this);
            if (geomFilter.getFilterType() == 6) {
                this.out.write(",'mask=" + mask + " querytype=WINDOW') <> 'TRUE' ");
            } else {
                this.out.write(",'mask=" + mask + " querytype=WINDOW') = 'TRUE' ");
            }
            this.inGeomFilter = false;
        } else {
            LOGGER.warning("Invalid filter. Cannot have a Geometry filter with only one expression.");
        }
    }

    private void doSdoDistance(GeometryDistanceFilter geomFilter) throws IOException {
        String boolValue;
        Expression left = geomFilter.getLeftGeometry();
        Expression right = geomFilter.getRightGeometry();
        double distance = geomFilter.getDistance();
        boolean isDWithin = geomFilter.getFilterType() == 24;
        String string = boolValue = isDWithin ? "TRUE" : "FALSE";
        if (left != null && right != null) {
            this.inGeomFilter = true;
            this.out.write("SDO_WITHIN_DISTANCE(");
            left.accept((FilterVisitor)this);
            this.out.write(",");
            right.accept((FilterVisitor)this);
            this.out.write(",'distance=" + distance + "') = '" + boolValue + "' ");
            this.inGeomFilter = false;
        } else {
            LOGGER.warning("Invalid filter for DWithin. Cannot have a Geometry filter with only one expression.");
        }
    }

    public static String toSDOGeom(Geometry geometry, int srid) {
        if (Point.class.isAssignableFrom(geometry.getClass())) {
            return SQLEncoderOracle.toSDOGeom((Point)geometry, srid);
        }
        if (LineString.class.isAssignableFrom(geometry.getClass())) {
            return SQLEncoderOracle.toSDOGeom((LineString)geometry, srid);
        }
        if (Polygon.class.isAssignableFrom(geometry.getClass())) {
            if (geometry.equals(geometry.getEnvelope())) {
                return SQLEncoderOracle.toSDOGeom(geometry.getEnvelopeInternal(), srid);
            }
            return SQLEncoderOracle.toSDOGeom((Polygon)geometry, srid);
        }
        if (MultiLineString.class.isAssignableFrom(geometry.getClass())) {
            return SQLEncoderOracle.toSDOGeom((MultiLineString)geometry, srid);
        }
        if (MultiPolygon.class.isAssignableFrom(geometry.getClass())) {
            return SQLEncoderOracle.toSDOGeom((MultiPolygon)geometry, srid);
        }
        LOGGER.warning("Got a literal geometry that I can't handle: " + geometry.getClass().getName());
        return "";
    }

    private static String toSDOGeom(MultiLineString line, int srid) {
        if (line.getNumGeometries() == 1) {
            return SQLEncoderOracle.toSDOGeom(line.getGeometryN(0), srid);
        }
        throw new UnsupportedOperationException("Cannot encode MultiLineString (yet)");
    }

    private static String toSDOGeom(MultiPolygon polygon, int srid) {
        if (polygon.getNumGeometries() == 1) {
            return SQLEncoderOracle.toSDOGeom(polygon.getGeometryN(0), srid);
        }
        throw new UnsupportedOperationException("Cannot encode MultiPolygon (yet)");
    }

    private static String toSDOGeom(LineString line, int srid) {
        if (SDO.D((Geometry)line) > 2) {
            LOGGER.warning("" + SDO.D((Geometry)line) + " dimensioned geometry provided." + " This encoder only supports 2D geometries. The query will be constructed as" + " a 2D query.");
        }
        StringBuffer buffer = new StringBuffer("MDSYS.SDO_GEOMETRY(");
        buffer.append(SDO.D((Geometry)line));
        buffer.append("002,");
        if (srid > 0) {
            LOGGER.fine("Using layer SRID: " + srid);
            buffer.append(srid);
        } else {
            LOGGER.fine("Using NULL SRID: ");
            buffer.append("NULL");
        }
        buffer.append(",NULL,MDSYS.SDO_ELEM_INFO_ARRAY(1,2,1),");
        buffer.append("MDSYS.SDO_ORDINATE_ARRAY(");
        Coordinate[] coordinates = line.getCoordinates();
        for (int i = 0; i < coordinates.length; ++i) {
            buffer.append(coordinates[i].x);
            buffer.append(",");
            buffer.append(coordinates[i].y);
            if (i == coordinates.length - 1) continue;
            buffer.append(",");
        }
        buffer.append("))");
        return buffer.toString();
    }

    private static String toSDOGeom(Point point, int srid) {
        if (SDO.D((Geometry)point) > 2) {
            LOGGER.warning("" + SDO.D((Geometry)point) + " dimensioned geometry provided." + " This encoder only supports 2D geometries. The query will be constructed as" + " a 2D query.");
        }
        StringBuffer buffer = new StringBuffer("MDSYS.SDO_GEOMETRY(");
        buffer.append(SDO.D((Geometry)point));
        buffer.append("001,");
        if (srid > 0) {
            LOGGER.fine("Using layer SRID: " + srid);
            buffer.append(srid);
        } else {
            LOGGER.fine("Using NULL SRID: ");
            buffer.append("NULL");
        }
        buffer.append(",MDSYS.SDO_POINT_TYPE(");
        buffer.append(point.getX());
        buffer.append(",");
        buffer.append(point.getY());
        buffer.append(",NULL),NULL,NULL)");
        return buffer.toString();
    }

    private static String toSDOGeom(Polygon polygon, int srid) {
        StringBuffer buffer = new StringBuffer();
        if (SDO.D((Geometry)polygon) > 2) {
            LOGGER.warning("" + SDO.D((Geometry)polygon) + " dimensioned geometry provided." + " This encoder only supports 2D geometries. The query will be constructed as" + " a 2D query.");
        }
        if (polygon.getExteriorRing() != null) {
            buffer.append("MDSYS.SDO_GEOMETRY(");
            buffer.append(SDO.D((Geometry)polygon));
            buffer.append("003,");
            if (srid > 0) {
                LOGGER.fine("Using layer SRID: " + srid);
                buffer.append(srid);
            } else {
                LOGGER.fine("Using NULL SRID: ");
                buffer.append("NULL");
            }
            buffer.append(",NULL,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,1),");
            buffer.append("MDSYS.SDO_ORDINATE_ARRAY(");
            CoordinateSequenceFactory fact = polygon.getFactory().getCoordinateSequenceFactory();
            CoordinateSequence exterior = polygon.getExteriorRing().getCoordinateSequence();
            CoordinateSequence coordSeq = SDO.counterClockWise(fact, exterior);
            int size = coordSeq.size();
            for (int i = 0; i < size; ++i) {
                Coordinate cur = coordSeq.getCoordinate(i);
                buffer.append(cur.x);
                buffer.append(",");
                buffer.append(cur.y);
                if (i == size - 1) continue;
                buffer.append(",");
            }
            buffer.append("))");
        } else {
            LOGGER.warning("No Exterior ring on polygon.  This encode only supports Polygons with exterior rings.");
        }
        if (polygon.getNumInteriorRing() > 0) {
            LOGGER.warning("Polygon contains Interior Rings. These rings will not be included in the query.");
        }
        return buffer.toString();
    }

    private static String toSDOGeom(Envelope envelope, int srid) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("MDSYS.SDO_GEOMETRY(");
        buffer.append("2003,");
        if (srid > 0) {
            LOGGER.fine("Using layer SRID: " + srid);
            buffer.append(srid);
        } else {
            LOGGER.fine("Using NULL SRID: ");
            buffer.append("NULL");
        }
        buffer.append(",NULL,MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,3),");
        buffer.append("MDSYS.SDO_ORDINATE_ARRAY(");
        buffer.append(envelope.getMinX());
        buffer.append(",");
        buffer.append(envelope.getMinY());
        buffer.append(",");
        buffer.append(envelope.getMaxX());
        buffer.append(",");
        buffer.append(envelope.getMaxY());
        buffer.append("))");
        return buffer.toString();
    }

    public void visit(GeometryFilter geomFilter) {
        LOGGER.finer("Visiting a Geometry filter");
        try {
            short filterType = geomFilter.getFilterType();
            if (filterType == 24 || filterType == 13) {
                this.doSdoDistance((GeometryDistanceFilter)geomFilter);
            } else if (SDO_RELATE_MASK_MAP.get(new Short(geomFilter.getFilterType())) != null) {
                this.doSdoRelate(geomFilter);
            } else {
                LOGGER.warning("Unknown filter type: " + geomFilter.getFilterType());
            }
        }
        catch (IOException e) {
            LOGGER.warning("IO Error exporting geometry filter");
        }
    }

    public void visit(LikeFilter filter) {
        try {
            String pattern = filter.getPattern();
            String multi = "\\Q" + filter.getWildcardMulti() + "\\E";
            pattern = pattern.replaceAll(multi, SQL_WILD_MULTI);
            String single = "\\Q" + filter.getWildcardSingle() + "\\E";
            pattern = pattern.replaceAll(single, SQL_WILD_SINGLE);
            this.out.write("UPPER(");
            filter.getValue().accept((FilterVisitor)this);
            this.out.write(") LIKE ");
            this.out.write("UPPER('" + pattern + "')");
            String esc = filter.getEscape();
            if (pattern.indexOf(esc) != -1) {
                this.out.write(" ESCAPE '" + esc + "'");
            }
        }
        catch (IOException ioe) {
            LOGGER.warning("Unable to export filter" + ioe);
        }
    }

    public void visit(LiteralExpression literal) {
        if (literal.getType() == 104) {
            Geometry geometry = (Geometry)literal.getLiteral();
            try {
                int srid = -1;
                Integer sridO = (Integer)this.srids.get(this.currentGeomColumnName);
                if (sridO == null) {
                    sridO = (Integer)this.srids.get(null);
                }
                if (sridO != null) {
                    srid = sridO;
                }
                this.out.write(SQLEncoderOracle.toSDOGeom(geometry, srid));
            }
            catch (IOException e) {
                LOGGER.warning("IO Error exporting Literal Geometry");
            }
        } else {
            super.visit(literal);
        }
    }

    public void visit(FidFilter filter) {
        if (this.fidColumn != null) {
            String[] fids = filter.getFids();
            LOGGER.finer("Exporting FID=" + Arrays.asList(fids));
            for (int i = 0; i < fids.length; ++i) {
                try {
                    this.out.write(this.fidColumn);
                    this.out.write(" = '");
                    int pos = fids[i].indexOf(46);
                    if (pos != -1) {
                        this.out.write(fids[i].substring(pos + 1));
                    } else {
                        this.out.write(fids[i]);
                    }
                    this.out.write("'");
                    if (i >= fids.length - 1) continue;
                    this.out.write(" OR ");
                    continue;
                }
                catch (IOException e) {
                    LOGGER.warning("IO Error exporting FID Filter.");
                }
            }
        } else {
            super.visit(filter);
        }
    }

    public void visit(AttributeExpression ae) throws RuntimeException {
        super.visit(ae);
        if (this.inGeomFilter) {
            if (this.featureType != null) {
                AttributeDescriptor attributeType = (AttributeDescriptor)ae.evaluate((Object)this.featureType);
                this.currentGeomColumnName = attributeType.getLocalName();
            } else {
                this.currentGeomColumnName = ae.getAttributePath();
            }
        }
    }

    public void visit(IncludeFilter filter) {
        try {
            this.out.write("1 = 1");
        }
        catch (IOException ioe) {
            throw new RuntimeException("io problem writing filter", ioe);
        }
    }

    public void visit(ExcludeFilter filter) {
        try {
            this.out.write("1 = 0");
        }
        catch (IOException ioe) {
            throw new RuntimeException("io problem writing filter", ioe);
        }
    }

    public void visit(CompareFilter filter) throws RuntimeException {
        DefaultExpression left = (DefaultExpression)filter.getLeftValue();
        DefaultExpression right = (DefaultExpression)filter.getRightValue();
        String type = (String)comparisions.get(new Integer(filter.getFilterType()));
        if (!(filter.isMatchingCase() || filter.getFilterType() != 14 && filter.getFilterType() != 23 || left.getType() != 103 && right.getType() != 103)) {
            try {
                this.out.write("lower(");
                left.accept((FilterVisitor)this);
                this.out.write(")");
                this.out.write(" " + type + " ");
                this.out.write("lower(");
                right.accept((FilterVisitor)this);
                this.out.write(")");
                return;
            }
            catch (IOException e) {
                throw new RuntimeException("Error occurred writing filter", e);
            }
        }
        super.visit(filter);
    }

    static {
        SDO_RELATE_MASK_MAP.put(new Short(11), "contains");
        SDO_RELATE_MASK_MAP.put(new Short(9), "overlapbydisjoint");
        SDO_RELATE_MASK_MAP.put(new Short(5), "equal");
        SDO_RELATE_MASK_MAP.put(new Short(12), "overlapbyintersect");
        SDO_RELATE_MASK_MAP.put(new Short(8), "touch");
        SDO_RELATE_MASK_MAP.put(new Short(10), "inside");
        SDO_RELATE_MASK_MAP.put(new Short(6), "anyinteract");
        SDO_RELATE_MASK_MAP.put(new Short(4), "anyinteract");
        SDO_RELATE_MASK_MAP.put(new Short(7), "anyinteract");
    }
}

