/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import java.io.IOException;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.postgis.FeatureDiff;
import org.geotools.data.postgis.ModifiedFeatureIds;
import org.geotools.data.postgis.RevisionInfo;
import org.geotools.data.postgis.VersionedPostgisDataStore;
import org.geotools.data.postgis.fidmapper.VersionedFIDMapper;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureDiffReader {
    protected static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.postgis");
    private FeatureReader<SimpleFeatureType, SimpleFeature> fvReader;
    private FeatureReader<SimpleFeatureType, SimpleFeature> tvReader;
    private RevisionInfo fromVersion;
    private RevisionInfo toVersion;
    private VersionedFIDMapper mapper;
    private Transaction transaction;
    private VersionedPostgisDataStore store;
    private FeatureReader<SimpleFeatureType, SimpleFeature> deletedReader;
    private FeatureReader<SimpleFeatureType, SimpleFeature> createdReader;
    private SimpleFeatureType externalFeatureType;
    private FeatureDiff lastDiff;
    private ModifiedFeatureIds modifiedIds;

    public FeatureDiffReader(VersionedPostgisDataStore store, Transaction transaction, SimpleFeatureType externalFeatureType, RevisionInfo fromVersion, RevisionInfo toVersion, VersionedFIDMapper mapper, ModifiedFeatureIds modifiedIds) throws IOException {
        this.store = store;
        this.transaction = transaction;
        this.fromVersion = fromVersion;
        this.toVersion = toVersion;
        this.externalFeatureType = externalFeatureType;
        this.mapper = mapper;
        this.modifiedIds = modifiedIds;
        this.initReaders();
    }

    public FeatureDiffReader(FeatureDiffReader other) throws IOException {
        this.store = other.store;
        this.transaction = other.transaction;
        this.fromVersion = other.fromVersion;
        this.toVersion = other.toVersion;
        this.externalFeatureType = other.externalFeatureType;
        this.mapper = other.mapper;
        this.modifiedIds = other.modifiedIds;
        this.initReaders();
    }

    void initReaders() throws IOException {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        if (this.fromVersion.revision > this.toVersion.revision) {
            this.createdReader = this.readerFromIdsRevision(ff, null, this.modifiedIds.deleted, this.modifiedIds.fromRevision);
            this.deletedReader = this.readerFromIdsRevision(ff, null, this.modifiedIds.created, this.modifiedIds.toRevision);
            this.fvReader = this.readerFromIdsRevision(ff, this.mapper, this.modifiedIds.modified, this.modifiedIds.toRevision);
            this.tvReader = this.readerFromIdsRevision(ff, this.mapper, this.modifiedIds.modified, this.modifiedIds.fromRevision);
        } else {
            this.createdReader = this.readerFromIdsRevision(ff, null, this.modifiedIds.created, this.modifiedIds.toRevision);
            this.deletedReader = this.readerFromIdsRevision(ff, null, this.modifiedIds.deleted, this.modifiedIds.fromRevision);
            this.fvReader = this.readerFromIdsRevision(ff, this.mapper, this.modifiedIds.modified, this.modifiedIds.fromRevision);
            this.tvReader = this.readerFromIdsRevision(ff, this.mapper, this.modifiedIds.modified, this.modifiedIds.toRevision);
        }
    }

    FeatureReader<SimpleFeatureType, SimpleFeature> readerFromIdsRevision(FilterFactory ff, VersionedFIDMapper mapper, Set fids, RevisionInfo ri) throws IOException {
        if (fids != null && !fids.isEmpty()) {
            Filter fidFilter = this.store.buildFidFilter(fids);
            Filter versionFilter = this.store.buildVersionedFilter(this.externalFeatureType.getTypeName(), fidFilter, ri);
            DefaultQuery query = new DefaultQuery(this.externalFeatureType.getTypeName(), versionFilter);
            if (mapper != null) {
                ArrayList<SortBy> sort = new ArrayList<SortBy>(mapper.getColumnCount() - 1);
                for (int i = 0; i < mapper.getColumnCount(); ++i) {
                    String colName = mapper.getColumnName(i);
                    if ("revision".equals(colName)) continue;
                    sort.add(ff.sort(colName, SortOrder.DESCENDING));
                }
                query.setSortBy(sort.toArray(new SortBy[sort.size()]));
            }
            return this.store.wrapped.getFeatureReader((Query)query, this.transaction);
        }
        return null;
    }

    public String getFromVersion() {
        return this.fromVersion.getVersion();
    }

    public String getToVersion() {
        return this.toVersion.getVersion();
    }

    public SimpleFeatureType getSchema() {
        return this.externalFeatureType;
    }

    public FeatureDiff next() throws IOException, NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more diffs in this reader");
        }
        if (this.createdReader != null) {
            return new FeatureDiff(null, this.gatherNextUnversionedFeature(this.createdReader));
        }
        if (this.deletedReader != null) {
            return new FeatureDiff(this.gatherNextUnversionedFeature(this.deletedReader), null);
        }
        FeatureDiff diff = this.lastDiff;
        this.lastDiff = null;
        return diff;
    }

    private SimpleFeature gatherNextUnversionedFeature(FeatureReader<SimpleFeatureType, SimpleFeature> fr) throws IOException {
        try {
            SimpleFeature f = (SimpleFeature)fr.next();
            Object[] attributes = new Object[this.externalFeatureType.getAttributeCount()];
            for (int i = 0; i < this.externalFeatureType.getAttributeCount(); ++i) {
                attributes[i] = f.getAttribute(this.externalFeatureType.getDescriptor(i).getLocalName());
            }
            String id = this.mapper.getUnversionedFid(f.getID());
            return SimpleFeatureBuilder.build((SimpleFeatureType)this.externalFeatureType, (Object[])attributes, (String)id);
        }
        catch (IllegalAttributeException e) {
            throw new DataSourceException("Could not properly load the fetures to diff: " + (Object)((Object)e));
        }
    }

    public boolean hasNext() throws IOException {
        if (this.createdReader != null) {
            if (this.createdReader.hasNext()) {
                return true;
            }
            this.createdReader.close();
            this.createdReader = null;
        }
        if (this.deletedReader != null) {
            if (this.deletedReader.hasNext()) {
                return true;
            }
            this.deletedReader.close();
            this.deletedReader = null;
        }
        if (this.lastDiff != null) {
            return true;
        }
        if (this.fvReader != null && this.tvReader != null) {
            SimpleFeature to;
            SimpleFeature from;
            FeatureDiff diff;
            do {
                if (this.fvReader.hasNext()) continue;
                this.lastDiff = null;
                this.fvReader.close();
                this.tvReader.close();
                return false;
            } while ((diff = new FeatureDiff(from = this.gatherNextUnversionedFeature(this.fvReader), to = this.gatherNextUnversionedFeature(this.tvReader))).getChangedAttributes().size() == 0);
            this.lastDiff = diff;
            return true;
        }
        return false;
    }

    public void reset() throws IOException {
        this.close();
        this.initReaders();
    }

    public void close() throws IOException {
        if (this.createdReader != null) {
            this.createdReader.close();
            this.createdReader = null;
        }
        if (this.deletedReader != null) {
            this.deletedReader.close();
            this.deletedReader = null;
        }
        if (this.fvReader != null) {
            this.fvReader.close();
            this.fvReader = null;
        }
        if (this.tvReader != null) {
            this.tvReader.close();
            this.tvReader = null;
        }
    }

    protected void finalize() throws Throwable {
        if (this.createdReader != null || this.deletedReader != null || this.fvReader != null || this.tvReader != null) {
            LOGGER.warning("There's code leaaving the feature diff readers open!");
            this.close();
        }
    }
}

