/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis.fidmapper;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import org.geotools.data.jdbc.JDBCDataStoreConfig;
import org.geotools.data.jdbc.fidmapper.DefaultFIDMapperFactory;
import org.geotools.data.jdbc.fidmapper.FIDMapper;
import org.geotools.data.postgis.PostgisSQLBuilder;
import org.geotools.data.postgis.fidmapper.OIDFidMapper;
import org.geotools.data.postgis.fidmapper.PostGISAutoIncrementFIDMapper;
import org.geotools.data.postgis.fidmapper.UUIDFIDMapper;
import org.geotools.filter.SQLEncoderPostgis;

public class PostgisFIDMapperFactory
extends DefaultFIDMapperFactory {
    JDBCDataStoreConfig config;

    public PostgisFIDMapperFactory(JDBCDataStoreConfig config) {
        this.config = config;
    }

    protected FIDMapper buildNoPKMapper(String schema, String tableName, Connection connection) {
        if (this.getDatabaseMajorVersion(connection) <= 7) {
            return new OIDFidMapper();
        }
        PostgisSQLBuilder sqlb = new PostgisSQLBuilder(new SQLEncoderPostgis(), this.config);
        String sql = "SELECT " + sqlb.encodeColumnName("oid") + " FROM " + sqlb.encodeTableName(tableName) + " LIMIT 1";
        Statement st = null;
        try {
            st = connection.createStatement();
            st.execute(sql);
            OIDFidMapper oIDFidMapper = new OIDFidMapper();
            return oIDFidMapper;
        }
        catch (SQLException sQLException) {
        }
        finally {
            try {
                st.close();
            }
            catch (SQLException sQLException) {}
        }
        return super.buildNoPKMapper(schema, tableName, connection);
    }

    private int getDatabaseMajorVersion(Connection connection) {
        int major;
        try {
            major = connection.getMetaData().getDatabaseMajorVersion();
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Failed to retrieve Postgres database version number, assuming 7. Error is: " + e.getMessage(), e);
            major = 7;
        }
        return major;
    }

    protected FIDMapper buildLastResortFidMapper(String schema, String tableName, Connection connection, DefaultFIDMapperFactory.ColumnInfo[] colInfos) {
        if (this.getDatabaseMajorVersion(connection) > 7) {
            throw new IllegalArgumentException("Tables for postgis 8+ must have a primary key defined");
        }
        return new OIDFidMapper();
    }

    protected FIDMapper buildSingleColumnFidMapper(String schema, String tableName, Connection connection, DefaultFIDMapperFactory.ColumnInfo ci) {
        if (ci.isAutoIncrement()) {
            return new PostGISAutoIncrementFIDMapper(schema, tableName, ci.getColName(), ci.getDataType());
        }
        if ("uuid".equals(ci.getTypeName())) {
            return new UUIDFIDMapper(ci.getColName(), ci.dataType);
        }
        return super.buildSingleColumnFidMapper(schema, tableName, connection, ci);
    }

    protected boolean isAutoIncrement(String catalog, String schema, String tableName, Connection conn, ResultSet tableInfo, String columnName, int dataType) throws SQLException {
        String schemaName = null;
        if (schema != null) {
            schemaName = "\"" + schema + "\"";
        }
        return super.isAutoIncrement(catalog, schemaName, "\"" + tableName + "\"", conn, tableInfo, "\"" + columnName + "\"", dataType);
    }
}

