/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.property;

import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.io.WKTReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.NoSuchElementException;
import org.geotools.data.AttributeReader;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.feature.SchemaException;
import org.geotools.util.Converters;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

public class PropertyAttributeReader
implements AttributeReader {
    private static final WKTReader wktReader = new WKTReader(new GeometryFactory());
    BufferedReader reader;
    SimpleFeatureType type;
    String line;
    String next;
    String[] text;
    String fid;

    public PropertyAttributeReader(File file) throws IOException {
        String typeName = PropertyAttributeReader.typeName(file);
        String namespace = PropertyAttributeReader.namespace(file);
        this.reader = new BufferedReader(new FileReader(file));
        while ((this.line = this.reader.readLine()) != null && !this.line.startsWith("_=")) {
        }
        if (this.line == null || !this.line.startsWith("_=")) {
            throw new IOException(typeName + " schema not available");
        }
        String typeSpec = this.line.substring(2);
        try {
            this.type = DataUtilities.createType((String)namespace, (String)typeName, (String)typeSpec);
        }
        catch (SchemaException e) {
            throw new DataSourceException(typeName + " schema not available", (Throwable)e);
        }
        this.line = null;
        this.next = null;
    }

    private static String typeName(File file) {
        String name = file.getName();
        int split = name.lastIndexOf(46);
        return split == -1 ? name : name.substring(0, split);
    }

    private static String namespace(File file) {
        File parent = file.getParentFile();
        return parent == null ? "" : parent.getName() + ".";
    }

    public int getAttributeCount() {
        return this.type.getAttributeCount();
    }

    public AttributeDescriptor getAttributeType(int index) throws ArrayIndexOutOfBoundsException {
        return this.type.getDescriptor(index);
    }

    public void close() throws IOException {
        this.reader.close();
        this.reader = null;
    }

    public boolean hasNext() throws IOException {
        if (this.next != null) {
            return true;
        }
        this.next = this.reader.readLine();
        return this.next != null;
    }

    public void next() throws IOException {
        if (this.hasNext()) {
            this.line = this.next;
            this.next = null;
            int split = this.line.indexOf(61);
            this.fid = this.line.substring(0, split);
            this.text = this.line.substring(split + 1).split("\\|");
            if (this.type.getAttributeCount() != this.text.length) {
                throw new DataSourceException("format error: expected " + this.type.getAttributeCount() + " attributes, but found " + this.text.length + ". [" + this.line + "]");
            }
        } else {
            throw new NoSuchElementException();
        }
    }

    public String getFeatureID() {
        if (this.line == null) {
            return null;
        }
        return this.fid;
    }

    public Object read(int index) throws IOException, ArrayIndexOutOfBoundsException {
        if (this.line == null) {
            throw new IOException("No content available - did you remeber to call next?");
        }
        AttributeDescriptor attType = this.type.getDescriptor(index);
        String stringValue = null;
        try {
            stringValue = this.text[index];
            if (stringValue != null) {
                stringValue = stringValue.trim();
            }
            if ("".equals(stringValue)) {
                stringValue = null;
            }
        }
        catch (RuntimeException e1) {
            e1.printStackTrace();
            stringValue = null;
        }
        if ("<null>".equals(stringValue)) {
            stringValue = null;
        }
        if (stringValue == null && attType.isNillable()) {
            return null;
        }
        return Converters.convert((Object)stringValue, (Class)attType.getType().getBinding());
    }
}

