/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.parameter;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.measure.unit.Unit;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.parameter.MatrixParameters;
import org.geotools.parameter.Parameters;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.operation.matrix.MatrixFactory;
import org.geotools.referencing.operation.matrix.XMatrix;
import org.geotools.resources.UnmodifiableArrayList;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.Utilities;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.InvalidParameterNameException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.Matrix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatrixParameterDescriptors
extends DefaultParameterDescriptorGroup {
    private static final long serialVersionUID = -7386537348359343836L;
    public static final int DEFAULT_MATRIX_SIZE = 3;
    private static final int CACHE_SIZE = 8;
    private final ParameterDescriptor<Double>[] parameters = new ParameterDescriptor[64];
    protected final ParameterDescriptor<Integer> numRow;
    protected final ParameterDescriptor<Integer> numCol;
    protected final String prefix;
    protected final char separator;

    public MatrixParameterDescriptors(Map<String, ?> properties) {
        this(properties, new ParameterDescriptor[]{DefaultParameterDescriptor.create("num_row", 3, 2, 50), DefaultParameterDescriptor.create("num_col", 3, 2, 50)}, "elt_", '_');
    }

    public MatrixParameterDescriptors(Map<String, ?> properties, ParameterDescriptor<?>[] parameters, String prefix, char separator) {
        super(properties, (GeneralParameterDescriptor[])parameters);
        if (parameters.length < 2) {
            throw new IllegalArgumentException();
        }
        this.numRow = Parameters.cast(parameters[0], Integer.class);
        this.numCol = Parameters.cast(parameters[1], Integer.class);
        MatrixParameterDescriptors.ensureNonNull("prefix", prefix);
        this.prefix = prefix;
        this.separator = separator;
    }

    static void checkIndice(String name, int index, int upper) throws IndexOutOfBoundsException {
        if (index < 0 || index >= upper) {
            throw new IndexOutOfBoundsException(Errors.format((int)42, (Object)name, (Object)index));
        }
    }

    @Override
    public final GeneralParameterDescriptor descriptor(String name) throws ParameterNotFoundException {
        return this.descriptor(name, ((Number)((Object)this.numRow.getMaximumValue())).intValue(), ((Number)((Object)this.numCol.getMaximumValue())).intValue());
    }

    final GeneralParameterDescriptor descriptor(String name, int numRow, int numCol) throws ParameterNotFoundException {
        int split;
        MatrixParameterDescriptors.ensureNonNull("name", name);
        name = name.trim();
        RuntimeException cause = null;
        if (name.regionMatches(true, 0, this.prefix, 0, this.prefix.length()) && (split = name.indexOf(this.separator, this.prefix.length())) >= 0) {
            try {
                int row = Integer.parseInt(name.substring(this.prefix.length(), split));
                int col = Integer.parseInt(name.substring(split + 1));
                return this.descriptor(row, col, numRow, numCol);
            }
            catch (NumberFormatException exception) {
                cause = exception;
            }
            catch (IndexOutOfBoundsException exception) {
                cause = exception;
            }
        }
        try {
            return super.descriptor(name);
        }
        catch (ParameterNotFoundException exception) {
            if (cause != null) {
                try {
                    exception.initCause(cause);
                }
                catch (IllegalStateException ignore) {
                    // empty catch block
                }
            }
            throw exception;
        }
    }

    public final ParameterDescriptor<Double> descriptor(int row, int column) throws IndexOutOfBoundsException {
        return this.descriptor(row, column, ((Number)((Object)this.numRow.getMaximumValue())).intValue(), ((Number)((Object)this.numCol.getMaximumValue())).intValue());
    }

    final ParameterDescriptor<Double> descriptor(int row, int column, int numRow, int numCol) throws IndexOutOfBoundsException {
        ParameterDescriptor<Double> param;
        MatrixParameterDescriptors.checkIndice("row", row, numRow);
        MatrixParameterDescriptors.checkIndice("column", column, numCol);
        int index = -1;
        if (row < 8 && column < 8 && (param = this.parameters[index = row * 8 + column]) != null) {
            return param;
        }
        param = new DefaultParameterDescriptor<Double>(Collections.singletonMap("name", this.prefix + row + this.separator + column), Double.class, null, row == column ? 1.0 : 0.0, null, null, Unit.ONE, true);
        if (index >= 0) {
            this.parameters[index] = param;
        }
        return param;
    }

    @Override
    public final List<GeneralParameterDescriptor> descriptors() {
        return this.descriptors((Integer)this.numRow.getDefaultValue(), (Integer)this.numCol.getDefaultValue());
    }

    final List<GeneralParameterDescriptor> descriptors(int numRow, int numCol) {
        Object[] parameters = new GeneralParameterDescriptor[numRow * numCol + 2];
        int k = 0;
        parameters[k++] = this.numRow;
        parameters[k++] = this.numCol;
        for (int j = 0; j < numRow; ++j) {
            for (int i = 0; i < numCol; ++i) {
                parameters[k++] = this.descriptor(j, i, numRow, numCol);
            }
        }
        assert (k == parameters.length) : k;
        return UnmodifiableArrayList.wrap((Object[])parameters);
    }

    @Override
    public ParameterValueGroup createValue() {
        return new MatrixParameters(this);
    }

    public Matrix getMatrix(ParameterValueGroup parameters) throws InvalidParameterNameException {
        if (parameters instanceof MatrixParameters) {
            return ((MatrixParameters)parameters).getMatrix();
        }
        ParameterValue numRowParam = parameters.parameter(this.numRow.getName().toString());
        ParameterValue numColParam = parameters.parameter(this.numCol.getName().toString());
        int numRow = numRowParam.intValue();
        int numCol = numColParam.intValue();
        XMatrix matrix = MatrixFactory.create(numRow, numCol);
        List params = parameters.values();
        if (params != null) {
            for (GeneralParameterValue param : params) {
                int split;
                if (param == numRowParam || param == numColParam) continue;
                RuntimeException cause = null;
                String name = param.getDescriptor().getName().toString();
                if (name.regionMatches(true, 0, this.prefix, 0, this.prefix.length()) && (split = name.indexOf(this.separator, this.prefix.length())) >= 0) {
                    try {
                        int row = Integer.parseInt(name.substring(this.prefix.length(), split));
                        int col = Integer.parseInt(name.substring(split + 1));
                        matrix.setElement(row, col, ((ParameterValue)param).doubleValue());
                        continue;
                    }
                    catch (NumberFormatException exception) {
                        cause = exception;
                    }
                    catch (IndexOutOfBoundsException exception) {
                        cause = exception;
                    }
                }
                InvalidParameterNameException exception = new InvalidParameterNameException(Errors.format((int)129, (Object)name), name);
                if (cause != null) {
                    exception.initCause(cause);
                }
                throw exception;
            }
        }
        return matrix;
    }

    @Override
    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (super.equals(object, compareMetadata)) {
            MatrixParameterDescriptors that = (MatrixParameterDescriptors)object;
            return this.separator == that.separator && Utilities.equals((Object)this.prefix, (Object)that.prefix);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.prefix.hashCode() ^ 37 * this.separator;
    }
}

