/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.util.Collections;
import java.util.Set;
import javax.measure.unit.Unit;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.factory.IdentifiedObjectFinder;
import org.geotools.referencing.factory.ReferencingFactory;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.NameFactory;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.Extent;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.CylindricalCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.PolarCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAuthorityFactory
extends ReferencingFactory
implements AuthorityFactory {
    protected AbstractAuthorityFactory(int priority) {
        super(priority);
    }

    boolean isAvailable() {
        return true;
    }

    boolean sameAuthorityCodes(AuthorityFactory factory) {
        return factory == this;
    }

    public abstract Citation getAuthority();

    public String getBackingStoreDescription() throws FactoryException {
        return null;
    }

    public IdentifiedObject createObject(String code) throws NoSuchAuthorityCodeException, FactoryException {
        AbstractAuthorityFactory.ensureNonNull("code", code);
        throw this.noSuchAuthorityCode(IdentifiedObject.class, code);
    }

    public Datum createDatum(String code) throws NoSuchAuthorityCodeException, FactoryException {
        IdentifiedObject object = this.createObject(code);
        try {
            return (Datum)object;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(Datum.class, code, exception);
        }
    }

    public EngineeringDatum createEngineeringDatum(String code) throws NoSuchAuthorityCodeException, FactoryException {
        Datum datum = this.createDatum(code);
        try {
            return (EngineeringDatum)datum;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(EngineeringDatum.class, code, exception);
        }
    }

    public ImageDatum createImageDatum(String code) throws NoSuchAuthorityCodeException, FactoryException {
        Datum datum = this.createDatum(code);
        try {
            return (ImageDatum)datum;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(ImageDatum.class, code, exception);
        }
    }

    public VerticalDatum createVerticalDatum(String code) throws NoSuchAuthorityCodeException, FactoryException {
        Datum datum = this.createDatum(code);
        try {
            return (VerticalDatum)datum;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(VerticalDatum.class, code, exception);
        }
    }

    public TemporalDatum createTemporalDatum(String code) throws NoSuchAuthorityCodeException, FactoryException {
        Datum datum = this.createDatum(code);
        try {
            return (TemporalDatum)datum;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(TemporalDatum.class, code, exception);
        }
    }

    public GeodeticDatum createGeodeticDatum(String code) throws NoSuchAuthorityCodeException, FactoryException {
        Datum datum = this.createDatum(code);
        try {
            return (GeodeticDatum)datum;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(GeodeticDatum.class, code, exception);
        }
    }

    public Ellipsoid createEllipsoid(String code) throws NoSuchAuthorityCodeException, FactoryException {
        IdentifiedObject object = this.createObject(code);
        try {
            return (Ellipsoid)object;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(Ellipsoid.class, code, exception);
        }
    }

    public PrimeMeridian createPrimeMeridian(String code) throws NoSuchAuthorityCodeException, FactoryException {
        IdentifiedObject object = this.createObject(code);
        try {
            return (PrimeMeridian)object;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(PrimeMeridian.class, code, exception);
        }
    }

    public Extent createExtent(String code) throws NoSuchAuthorityCodeException, FactoryException {
        IdentifiedObject object = this.createObject(code);
        try {
            return (Extent)object;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(Extent.class, code, exception);
        }
    }

    public CoordinateSystem createCoordinateSystem(String code) throws NoSuchAuthorityCodeException, FactoryException {
        IdentifiedObject object = this.createObject(code);
        try {
            return (CoordinateSystem)object;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(CoordinateSystem.class, code, exception);
        }
    }

    public CartesianCS createCartesianCS(String code) throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateSystem cs = this.createCoordinateSystem(code);
        try {
            return (CartesianCS)cs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(CartesianCS.class, code, exception);
        }
    }

    public PolarCS createPolarCS(String code) throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateSystem cs = this.createCoordinateSystem(code);
        try {
            return (PolarCS)cs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(PolarCS.class, code, exception);
        }
    }

    public CylindricalCS createCylindricalCS(String code) throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateSystem cs = this.createCoordinateSystem(code);
        try {
            return (CylindricalCS)cs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(CylindricalCS.class, code, exception);
        }
    }

    public SphericalCS createSphericalCS(String code) throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateSystem cs = this.createCoordinateSystem(code);
        try {
            return (SphericalCS)cs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(SphericalCS.class, code, exception);
        }
    }

    public EllipsoidalCS createEllipsoidalCS(String code) throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateSystem cs = this.createCoordinateSystem(code);
        try {
            return (EllipsoidalCS)cs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(EllipsoidalCS.class, code, exception);
        }
    }

    public VerticalCS createVerticalCS(String code) throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateSystem cs = this.createCoordinateSystem(code);
        try {
            return (VerticalCS)cs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(VerticalCS.class, code, exception);
        }
    }

    public TimeCS createTimeCS(String code) throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateSystem cs = this.createCoordinateSystem(code);
        try {
            return (TimeCS)cs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(TimeCS.class, code, exception);
        }
    }

    public CoordinateSystemAxis createCoordinateSystemAxis(String code) throws NoSuchAuthorityCodeException, FactoryException {
        IdentifiedObject object = this.createObject(code);
        try {
            return (CoordinateSystemAxis)object;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(CoordinateSystemAxis.class, code, exception);
        }
    }

    public Unit<?> createUnit(String code) throws NoSuchAuthorityCodeException, FactoryException {
        IdentifiedObject object = this.createObject(code);
        try {
            return (Unit)object;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(Unit.class, code, exception);
        }
    }

    public CoordinateReferenceSystem createCoordinateReferenceSystem(String code) throws NoSuchAuthorityCodeException, FactoryException {
        IdentifiedObject object = this.createObject(code);
        try {
            return (CoordinateReferenceSystem)object;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(CoordinateReferenceSystem.class, code, exception);
        }
    }

    public CompoundCRS createCompoundCRS(String code) throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateReferenceSystem crs = this.createCoordinateReferenceSystem(code);
        try {
            return (CompoundCRS)crs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(CompoundCRS.class, code, exception);
        }
    }

    public DerivedCRS createDerivedCRS(String code) throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateReferenceSystem crs = this.createCoordinateReferenceSystem(code);
        try {
            return (DerivedCRS)crs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(DerivedCRS.class, code, exception);
        }
    }

    public EngineeringCRS createEngineeringCRS(String code) throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateReferenceSystem crs = this.createCoordinateReferenceSystem(code);
        try {
            return (EngineeringCRS)crs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(EngineeringCRS.class, code, exception);
        }
    }

    public GeographicCRS createGeographicCRS(String code) throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateReferenceSystem crs = this.createCoordinateReferenceSystem(code);
        try {
            return (GeographicCRS)crs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(GeographicCRS.class, code, exception);
        }
    }

    public GeocentricCRS createGeocentricCRS(String code) throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateReferenceSystem crs = this.createCoordinateReferenceSystem(code);
        try {
            return (GeocentricCRS)crs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(GeocentricCRS.class, code, exception);
        }
    }

    public ImageCRS createImageCRS(String code) throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateReferenceSystem crs = this.createCoordinateReferenceSystem(code);
        try {
            return (ImageCRS)crs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(ImageCRS.class, code, exception);
        }
    }

    public ProjectedCRS createProjectedCRS(String code) throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateReferenceSystem crs = this.createCoordinateReferenceSystem(code);
        try {
            return (ProjectedCRS)crs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(ProjectedCRS.class, code, exception);
        }
    }

    public TemporalCRS createTemporalCRS(String code) throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateReferenceSystem crs = this.createCoordinateReferenceSystem(code);
        try {
            return (TemporalCRS)crs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(TemporalCRS.class, code, exception);
        }
    }

    public VerticalCRS createVerticalCRS(String code) throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateReferenceSystem crs = this.createCoordinateReferenceSystem(code);
        try {
            return (VerticalCRS)crs;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(VerticalCRS.class, code, exception);
        }
    }

    public ParameterDescriptor createParameterDescriptor(String code) throws NoSuchAuthorityCodeException, FactoryException {
        IdentifiedObject operation = this.createObject(code);
        try {
            return (ParameterDescriptor)operation;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(ParameterDescriptor.class, code, exception);
        }
    }

    public OperationMethod createOperationMethod(String code) throws NoSuchAuthorityCodeException, FactoryException {
        IdentifiedObject operation = this.createObject(code);
        try {
            return (OperationMethod)operation;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(OperationMethod.class, code, exception);
        }
    }

    public CoordinateOperation createCoordinateOperation(String code) throws NoSuchAuthorityCodeException, FactoryException {
        IdentifiedObject operation = this.createObject(code);
        try {
            return (CoordinateOperation)operation;
        }
        catch (ClassCastException exception) {
            throw this.noSuchAuthorityCode(CoordinateOperation.class, code, exception);
        }
    }

    public Set<CoordinateOperation> createFromCoordinateReferenceSystemCodes(String sourceCRS, String targetCRS) throws NoSuchAuthorityCodeException, FactoryException {
        return Collections.emptySet();
    }

    public IdentifiedObjectFinder getIdentifiedObjectFinder(Class<? extends IdentifiedObject> type) throws FactoryException {
        return new IdentifiedObjectFinder(this, type);
    }

    public void dispose() throws FactoryException {
    }

    private NoSuchAuthorityCodeException noSuchAuthorityCode(Class type, String code, ClassCastException cause) {
        NoSuchAuthorityCodeException exception = this.noSuchAuthorityCode(type, code);
        exception.initCause((Throwable)cause);
        return exception;
    }

    protected String trimAuthority(String code) {
        GenericName name = NameFactory.create((String)(code = code.trim()));
        GenericName scope = name.scope().name();
        if (scope == null) {
            return code;
        }
        if (Citations.identifierMatches((Citation)this.getAuthority(), (String)scope.toString())) {
            return name.tip().toString().trim();
        }
        return code;
    }

    protected final NoSuchAuthorityCodeException noSuchAuthorityCode(Class type, String code) {
        InternationalString authority = this.getAuthority().getTitle();
        return new NoSuchAuthorityCodeException(Errors.format((int)162, (Object)code, (Object)authority, (Object)type), authority.toString(), code);
    }
}

