/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import org.geotools.renderer.lite.MetaBufferEstimator;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.styling.Style;
import org.geotools.styling.StyleVisitor;
import org.junit.Assert;
import org.junit.Test;

public class MetaBufferEstimatorTest {
    @Test
    public void testExternalGraphic() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "externalGraphic.sld");
        MetaBufferEstimator estimator = new MetaBufferEstimator();
        style.accept((StyleVisitor)estimator);
        Assert.assertTrue((boolean)estimator.isEstimateAccurate());
        Assert.assertEquals((long)48L, (long)estimator.getBuffer());
    }

    @Test
    public void testExternalGraphicNoSize() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "externalGraphicNoSize.sld");
        MetaBufferEstimator estimator = new MetaBufferEstimator();
        style.accept((StyleVisitor)estimator);
        Assert.assertTrue((boolean)estimator.isEstimateAccurate());
        Assert.assertEquals((long)64L, (long)estimator.getBuffer());
    }

    @Test
    public void testMark() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "markCircle.sld");
        MetaBufferEstimator estimator = new MetaBufferEstimator();
        style.accept((StyleVisitor)estimator);
        Assert.assertTrue((boolean)estimator.isEstimateAccurate());
        Assert.assertEquals((long)32L, (long)estimator.getBuffer());
    }

    @Test
    public void testThinLine() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "lineGray.sld");
        MetaBufferEstimator estimator = new MetaBufferEstimator();
        style.accept((StyleVisitor)estimator);
        Assert.assertTrue((boolean)estimator.isEstimateAccurate());
        Assert.assertEquals((long)1L, (long)estimator.getBuffer());
    }

    @Test
    public void testThickLine() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "lineThick.sld");
        MetaBufferEstimator estimator = new MetaBufferEstimator();
        style.accept((StyleVisitor)estimator);
        Assert.assertTrue((boolean)estimator.isEstimateAccurate());
        Assert.assertEquals((long)4L, (long)estimator.getBuffer());
    }

    @Test
    public void testGraphicStroke() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "lineRailway.sld");
        MetaBufferEstimator estimator = new MetaBufferEstimator();
        style.accept((StyleVisitor)estimator);
        Assert.assertTrue((boolean)estimator.isEstimateAccurate());
        Assert.assertEquals((long)8L, (long)estimator.getBuffer());
    }

    @Test
    public void testPolygon() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "polygon.sld");
        MetaBufferEstimator estimator = new MetaBufferEstimator();
        style.accept((StyleVisitor)estimator);
        Assert.assertTrue((boolean)estimator.isEstimateAccurate());
        Assert.assertEquals((long)1L, (long)estimator.getBuffer());
    }

    @Test
    public void testLabelShields() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "textLabelShield.sld");
        MetaBufferEstimator estimator = new MetaBufferEstimator();
        style.accept((StyleVisitor)estimator);
        Assert.assertTrue((boolean)estimator.isEstimateAccurate());
        Assert.assertEquals((long)32L, (long)estimator.getBuffer());
    }
}

