/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Collections;
import junit.framework.TestCase;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureCollections;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.DefaultMapContext;
import org.geotools.map.MapContext;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.RenderListener;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.Symbolizer;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ReprojectionTest
extends TestCase {
    private SimpleFeatureType pointFeautureType;
    private GeometryFactory gf = new GeometryFactory();
    protected int errors;

    protected void setUp() throws Exception {
        super.setUp();
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("Lines");
        builder.add("geom", LineString.class, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        this.pointFeautureType = builder.buildFeatureType();
    }

    public SimpleFeatureCollection createLineCollection() throws Exception {
        SimpleFeatureCollection fc = FeatureCollections.newCollection();
        fc.add((Feature)this.createLine(-177.0, 0.0, -177.0, 10.0));
        fc.add((Feature)this.createLine(-177.0, 0.0, -200.0, 0.0));
        fc.add((Feature)this.createLine(-177.0, 0.0, -177.0, 100.0));
        return fc;
    }

    private SimpleFeature createLine(double x1, double y1, double x2, double y2) throws IllegalAttributeException {
        Coordinate[] coords = new Coordinate[]{new Coordinate(x1, y1), new Coordinate(x2, y2)};
        return SimpleFeatureBuilder.build((SimpleFeatureType)this.pointFeautureType, (Object[])new Object[]{this.gf.createLineString(coords)}, null);
    }

    private Style createLineStyle() {
        StyleBuilder sb = new StyleBuilder();
        return sb.createStyle((Symbolizer)sb.createLineSymbolizer());
    }

    public void testSkipProjectionErrors() throws Exception {
        DefaultMapContext mapContext = new DefaultMapContext((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        mapContext.addLayer((FeatureCollection)this.createLineCollection(), this.createLineStyle());
        ReferencedEnvelope reWgs = new ReferencedEnvelope(new Envelope(-180.0, -170.0, 20.0, 40.0), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        CoordinateReferenceSystem utm1N = CRS.decode((String)"EPSG:32601");
        System.out.println(CRS.getGeographicBoundingBox((CoordinateReferenceSystem)utm1N));
        ReferencedEnvelope reUtm = reWgs.transform(utm1N, true);
        BufferedImage image = new BufferedImage(200, 200, 6);
        StreamingRenderer sr = new StreamingRenderer();
        sr.setRendererHints(Collections.singletonMap("optimizedDataLoadingEnabled", Boolean.FALSE));
        sr.setContext((MapContext)mapContext);
        sr.addRenderListener(new RenderListener(){

            public void featureRenderer(SimpleFeature feature) {
            }

            public void errorOccurred(Exception e) {
                e.printStackTrace();
                ++ReprojectionTest.this.errors;
            }
        });
        this.errors = 0;
        sr.paint((Graphics2D)image.getGraphics(), new Rectangle(200, 200), reUtm);
        ReprojectionTest.assertEquals((int)2, (int)this.errors);
    }
}

