/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Canvas;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.geometry.jts.Decimator;
import org.geotools.geometry.jts.GeomCollectionIterator;
import org.geotools.geometry.jts.LiteShape2;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.renderer.lite.LabelCache;
import org.geotools.renderer.style.GlyphStyle2D;
import org.geotools.renderer.style.GraphicStyle2D;
import org.geotools.renderer.style.LineStyle2D;
import org.geotools.renderer.style.MarkStyle2D;
import org.geotools.renderer.style.PolygonStyle2D;
import org.geotools.renderer.style.Style2D;
import org.geotools.util.logging.Logging;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public final class StyledShapePainter {
    private static final AffineTransform IDENTITY_TRANSFORM = new AffineTransform();
    private static final Canvas imgObserver = new Canvas();
    private static final Logger LOGGER = Logging.getLogger((String)StyledShapePainter.class.getName());
    LabelCache labelCache;

    public StyledShapePainter(LabelCache labelCache) {
        this.labelCache = labelCache;
    }

    public void paint(Graphics2D graphics, LiteShape2 shape, Style2D style, double scale) throws TransformException, FactoryException {
        if (style == null) {
            LOGGER.severe("ShapePainter has been asked to paint a null style!!");
            return;
        }
        if (!style.isScaleInRange(scale)) {
            LOGGER.fine("Out of scale");
            return;
        }
        if (style instanceof GlyphStyle2D) {
            GlyphStyle2D gs2d = (GlyphStyle2D)style;
            gs2d.render(graphics, shape, scale);
        } else if (style instanceof MarkStyle2D) {
            GeometryCollection gc;
            if (shape.getGeometry() instanceof GeometryCollection) {
                gc = (GeometryCollection)shape.getGeometry();
            } else {
                Geometry[] gs = new Geometry[]{shape.getGeometry()};
                gc = shape.getGeometry().getFactory().createGeometryCollection(gs);
            }
            GeomCollectionIterator citer = new GeomCollectionIterator(gc, IDENTITY_TRANSFORM, false, 1.0);
            float[] coords = new float[2];
            MarkStyle2D ms2d = (MarkStyle2D)style;
            while (!citer.isDone()) {
                citer.currentSegment(coords);
                Shape transformedShape = ms2d.getTransformedShape(coords[0], coords[1]);
                if (transformedShape == null) continue;
                if (ms2d.getFill() != null) {
                    graphics.setPaint(ms2d.getFill());
                    graphics.setComposite(ms2d.getFillComposite());
                    graphics.fill(transformedShape);
                }
                if (ms2d.getContour() != null) {
                    graphics.setPaint(ms2d.getContour());
                    graphics.setStroke(ms2d.getStroke());
                    graphics.setComposite(ms2d.getContourComposite());
                    graphics.draw(transformedShape);
                }
                citer.next();
            }
        } else if (style instanceof GraphicStyle2D) {
            float[] coords = new float[2];
            PathIterator iter = shape.getPathIterator(IDENTITY_TRANSFORM);
            iter.currentSegment(coords);
            GraphicStyle2D gs2d = (GraphicStyle2D)style;
            this.renderImage(graphics, coords[0], coords[1], gs2d.getImage(), gs2d.getRotation(), gs2d.getOpacity(), false);
        } else {
            LineStyle2D ls2d;
            Paint paint;
            if (style instanceof PolygonStyle2D) {
                PolygonStyle2D ps2d = (PolygonStyle2D)style;
                if (ps2d.getFill() != null) {
                    paint = ps2d.getFill();
                    if (paint instanceof TexturePaint) {
                        paint = (TexturePaint)paint;
                    }
                    graphics.setPaint(paint);
                    graphics.setComposite(ps2d.getFillComposite());
                    graphics.fill((Shape)shape);
                }
                if (ps2d.getGraphicFill() != null) {
                    this.paintGraphicFill(graphics, (Shape)shape, ps2d.getGraphicFill(), scale);
                }
            }
            if (style instanceof LineStyle2D && (ls2d = (LineStyle2D)style).getStroke() != null) {
                if (ls2d.getGraphicStroke() != null) {
                    this.drawWithGraphicsStroke(graphics, (Shape)shape, ls2d.getGraphicStroke());
                } else {
                    paint = ls2d.getContour();
                    if (paint instanceof TexturePaint) {
                        TexturePaint tp = (TexturePaint)paint;
                        BufferedImage image = tp.getImage();
                        Rectangle2D rect = tp.getAnchorRect();
                        AffineTransform at = graphics.getTransform();
                        double width = rect.getWidth() * at.getScaleX();
                        double height = rect.getHeight() * at.getScaleY();
                        Rectangle2D.Double scaledRect = new Rectangle2D.Double(0.0, 0.0, width, height);
                        paint = new TexturePaint(image, scaledRect);
                    }
                    Stroke stroke = ls2d.getStroke();
                    if (graphics.getRenderingHint(RenderingHints.KEY_ANTIALIASING) == RenderingHints.VALUE_ANTIALIAS_ON && stroke instanceof BasicStroke) {
                        BasicStroke bs = (BasicStroke)stroke;
                        stroke = new BasicStroke(bs.getLineWidth() + 0.5f, bs.getEndCap(), bs.getLineJoin(), bs.getMiterLimit(), bs.getDashArray(), bs.getDashPhase());
                    }
                    graphics.setPaint(paint);
                    graphics.setStroke(stroke);
                    graphics.setComposite(ls2d.getContourComposite());
                    graphics.draw((Shape)shape);
                }
            }
        }
    }

    public void debugShape(Shape shape) {
        float[] pt = new float[2];
        PathIterator iter = shape.getPathIterator(null);
        while (!iter.isDone()) {
            int type = iter.currentSegment(pt);
            String event = "unknown";
            if (type == 4) {
                event = "SEG_CLOSE";
            }
            if (type == 3) {
                event = "SEG_CUBIC";
            }
            if (type == 1) {
                event = "SEG_LINETO";
            }
            if (type == 0) {
                event = "SEG_MOVETO";
            }
            if (type == 2) {
                event = "SEG_QUADTO";
            }
            System.out.println(event + " " + pt[0] + "," + pt[1]);
            iter.next();
        }
    }

    private void drawWithGraphicsStroke(Graphics2D graphics, Shape shape, BufferedImage image) {
        PathIterator pi = shape.getPathIterator(null, 10.0);
        double[] coords = new double[4];
        int imageSize = image.getWidth();
        double[] first = new double[2];
        double[] previous = new double[2];
        int type = pi.currentSegment(coords);
        first[0] = coords[0];
        first[1] = coords[1];
        previous[0] = coords[0];
        previous[1] = coords[1];
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("starting at " + first[0] + "," + first[1]);
        }
        pi.next();
        while (!pi.isDone()) {
            type = pi.currentSegment(coords);
            switch (type) {
                case 0: {
                    if (!LOGGER.isLoggable(Level.FINEST)) break;
                    LOGGER.finest("moving to " + coords[0] + "," + coords[1]);
                    break;
                }
                case 4: {
                    coords[0] = first[0];
                    coords[1] = first[1];
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("closing from " + previous[0] + "," + previous[1] + " to " + coords[0] + "," + coords[1]);
                    }
                }
                case 1: {
                    double remainder;
                    int remainingWidth;
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("drawing from " + previous[0] + "," + previous[1] + " to " + coords[0] + "," + coords[1]);
                    }
                    double dx = coords[0] - previous[0];
                    double dy = coords[1] - previous[1];
                    double len = Math.sqrt(dx * dx + dy * dy);
                    double theta = Math.atan2(dx, dy);
                    dx = Math.sin(theta) * (double)imageSize;
                    dy = Math.cos(theta) * (double)imageSize;
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("dx = " + dx + " dy " + dy + " step = " + Math.sqrt(dx * dx + dy * dy));
                    }
                    double rotation = -(theta - 1.5707963267948966);
                    double x = previous[0];
                    double y = previous[1];
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("len =" + len + " imageSize " + imageSize);
                    }
                    double dist = 0.0;
                    for (dist = 0.0; dist < len - (double)imageSize; dist += (double)imageSize) {
                        this.renderImage(graphics, x, y, image, rotation, 1.0f, true);
                        x += dx;
                        y += dy;
                    }
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("loop end dist " + dist + " len " + len + " " + (len - dist));
                    }
                    if ((remainingWidth = (int)Math.round(remainder = len - dist)) <= 0) break;
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("about to use clipped image " + remainder);
                    }
                    BufferedImage img = new BufferedImage(remainingWidth + 2, image.getHeight(), image.getType());
                    Graphics2D ig = img.createGraphics();
                    ig.drawImage((Image)image, 0, 0, imgObserver);
                    this.renderImage(graphics, x, y, img, rotation, 1.0f, true);
                    break;
                }
                default: {
                    LOGGER.warning("default branch reached in drawWithGraphicStroke");
                }
            }
            previous[0] = coords[0];
            previous[1] = coords[1];
            pi.next();
        }
    }

    private void renderImage(Graphics2D graphics, double x, double y, Image image, double rotation, float opacity, boolean leftMiddle) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("drawing Image @" + x + "," + y);
        }
        AffineTransform temp = graphics.getTransform();
        AffineTransform markAT = graphics.getTransform();
        markAT.translate(x, y);
        double shearY = markAT.getShearY();
        double scaleY = markAT.getScaleY();
        double originalRotation = Math.atan(shearY / scaleY);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("originalRotation " + originalRotation);
        }
        markAT.rotate(rotation);
        graphics.setTransform(markAT);
        graphics.setComposite(AlphaComposite.getInstance(3, opacity));
        if (leftMiddle) {
            graphics.drawImage(image, 0, -image.getHeight(imgObserver) / 2, imgObserver);
        } else {
            graphics.drawImage(image, -image.getWidth(imgObserver) / 2, -image.getHeight(imgObserver) / 2, imgObserver);
        }
        graphics.setTransform(temp);
    }

    private void paintGraphicFill(Graphics2D graphics, Shape shape, Style2D graphicFill, double scale) throws TransformException, FactoryException {
        Rectangle2D boundsShape = shape.getBounds2D();
        Rectangle2D.Double stippleSize = null;
        if (!(graphicFill instanceof MarkStyle2D)) {
            return;
        }
        Rectangle2D boundsFill = ((MarkStyle2D)graphicFill).getShape().getBounds2D();
        double size = ((MarkStyle2D)graphicFill).getSize();
        double aspect = boundsFill.getHeight() > 0.0 && boundsFill.getWidth() > 0.0 ? boundsFill.getWidth() / boundsFill.getHeight() : 1.0;
        stippleSize = new Rectangle2D.Double(0.0, 0.0, size * aspect, size);
        int nStippleX = (int)Math.ceil(boundsShape.getWidth() / ((RectangularShape)stippleSize).getWidth());
        int nStippleY = (int)Math.ceil(boundsShape.getHeight() / ((RectangularShape)stippleSize).getHeight());
        Graphics2D g = (Graphics2D)graphics.create();
        g.clip(shape);
        Shape clipShape = g.getClip();
        for (int i = 0; i < nStippleX; ++i) {
            for (int j = 0; j < nStippleY; ++j) {
                double translateY;
                double translateX = boundsShape.getMinX() + (double)i * ((RectangularShape)stippleSize).getWidth();
                if (!clipShape.intersects(translateX, translateY = boundsShape.getMinY() + (double)j * ((RectangularShape)stippleSize).getHeight(), ((RectangularShape)stippleSize).getWidth(), ((RectangularShape)stippleSize).getHeight())) continue;
                LiteShape2 stippleShape = this.createStippleShape(stippleSize, translateX, translateY);
                this.paint(g, stippleShape, graphicFill, scale);
            }
        }
    }

    private LiteShape2 createStippleShape(Rectangle2D stippleSize, double translateX, double translateY) throws TransformException, FactoryException {
        GeometryFactory geomFactory = new GeometryFactory();
        Coordinate coord = new Coordinate(stippleSize.getCenterX() + translateX, stippleSize.getCenterY() + translateY);
        Point geom = geomFactory.createPoint(coord);
        AffineTransform2D identityTransf = new AffineTransform2D(new AffineTransform());
        Decimator nullDecimator = new Decimator(-1.0, -1.0);
        LiteShape2 stippleShape = new LiteShape2((Geometry)geom, (MathTransform)identityTransf, nullDecimator, false);
        return stippleShape;
    }
}

