/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.geotools.factory.CommonFactoryFinder;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategorizeFunction
implements Function {
    public static final String SUCCEEDING = "succeeding";
    public static final String PRECEDING = "preceding";
    public static final String RASTER_DATA = "Rasterdata";
    private final List<Expression> parameters;
    private final Literal fallback;
    public static final FunctionName NAME = new Name();

    public CategorizeFunction() {
        this(new ArrayList<Expression>(), null);
    }

    public CategorizeFunction(List<Expression> parameters, Literal fallback) {
        this.parameters = parameters;
        this.fallback = fallback;
    }

    public String getName() {
        return NAME.getName();
    }

    public List<Expression> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public Object accept(ExpressionVisitor visitor, Object extraData) {
        return visitor.visit((Function)this, extraData);
    }

    public Object evaluate(Object object) {
        return this.evaluate(object, Object.class);
    }

    public <T> T evaluate(Object object, Class<T> context) {
        Expression lookupExp = this.parameters.get(0);
        String belongsTo = this.queryThreshdoldBelongsTo(object);
        Expression currentExp = this.parameters.get(1);
        if (this.parameters.size() == 2) {
            return (T)currentExp.evaluate(object, context);
        }
        List<Expression> splits = this.parameters.size() % 2 == 0 ? this.parameters.subList(2, this.parameters.size()) : this.parameters.subList(2, this.parameters.size() - 1);
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
        for (int i = 0; i < splits.size(); i += 2) {
            Expression threshholdExp = splits.get(i);
            Expression rangedExp = splits.get(i + 1);
            String lookupValue = (String)lookupExp.evaluate(object, String.class);
            if (lookupValue.equalsIgnoreCase(RASTER_DATA)) {
                Double bandValue = new Double(object.toString());
                Double threshholdValue = (Double)threshholdExp.evaluate(object, Double.class);
                if (PRECEDING.equals(belongsTo)) {
                    if (!(bandValue > threshholdValue)) break;
                    currentExp = rangedExp;
                    continue;
                }
                if (!(bandValue >= threshholdValue)) break;
                currentExp = rangedExp;
                continue;
            }
            Object isIncludedInThreshold = PRECEDING.equals(belongsTo) ? ff.greater(lookupExp, threshholdExp) : ff.greaterOrEqual(lookupExp, threshholdExp);
            if (!isIncludedInThreshold.evaluate(object)) break;
            currentExp = rangedExp;
        }
        return (T)currentExp.evaluate(object, context);
    }

    private String queryThreshdoldBelongsTo(Object object) {
        if (this.parameters.size() == 2 && this.parameters.size() % 2 == 0) {
            return SUCCEEDING;
        }
        Expression lastParameter = this.parameters.get(this.parameters.size() - 1);
        String lastValue = (String)lastParameter.evaluate(object, String.class);
        if (PRECEDING.equalsIgnoreCase(lastValue)) {
            return PRECEDING;
        }
        if (SUCCEEDING.equalsIgnoreCase(lastValue)) {
            return SUCCEEDING;
        }
        return SUCCEEDING;
    }

    public Literal getFallbackValue() {
        return this.fallback;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Name
    implements FunctionName {
        public int getArgumentCount() {
            return 2;
        }

        public List<String> getArgumentNames() {
            return Arrays.asList("LookupValue", "Value", "Threshold 1", "Value 1", "Threshold 2", "Value 2", "succeeding or preceding");
        }

        public String getName() {
            return "Categorize";
        }
    }
}

