/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.map;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import javax.swing.event.EventListenerList;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureEvent;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.memory.CollectionSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.MapLayer;
import org.geotools.map.event.MapLayerEvent;
import org.geotools.map.event.MapLayerListener;
import org.geotools.styling.Style;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureSourceMapLayer
implements MapLayer {
    protected FeatureSource<? extends FeatureType, ? extends Feature> featureSource;
    protected Style style;
    protected Query query = Query.ALL;
    protected String title;
    protected boolean visible;
    protected boolean selected;
    protected EventListenerList listenerList = null;
    protected FeatureListener sourceListener = new FeatureListener(){

        public void changed(FeatureEvent featureEvent) {
            FeatureSourceMapLayer.this.fireMapLayerListenerLayerChanged(new MapLayerEvent(FeatureSourceMapLayer.this, 3));
        }
    };

    public FeatureSourceMapLayer(FeatureSource<? extends FeatureType, ? extends Feature> featureSource, Style style, String title) {
        if (featureSource == null || style == null || title == null) {
            throw new NullPointerException();
        }
        this.featureSource = featureSource;
        this.style = style;
        this.title = title;
        this.visible = true;
        this.selected = false;
    }

    public FeatureSourceMapLayer(FeatureSource<? extends FeatureType, ? extends Feature> featureSource, Style style) {
        this(featureSource, style, "");
    }

    @Override
    public FeatureSource<? extends FeatureType, ? extends Feature> getFeatureSource() {
        return this.featureSource;
    }

    @Override
    public CollectionSource getSource() {
        return null;
    }

    @Override
    public Style getStyle() {
        return this.style;
    }

    @Override
    public void setStyle(Style style) {
        if (style == null) {
            throw new NullPointerException();
        }
        this.style = style;
        this.fireMapLayerListenerLayerChanged(new MapLayerEvent(this, 4));
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        if (title == null) {
            throw new NullPointerException();
        }
        this.title = title;
        this.fireMapLayerListenerLayerChanged(new MapLayerEvent(this, 2));
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.visible == visible) {
            return;
        }
        this.visible = visible;
        MapLayerEvent event = new MapLayerEvent(this, 1);
        if (visible) {
            this.fireMapLayerListenerLayerShown(event);
        } else {
            this.fireMapLayerListenerLayerHidden(event);
        }
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean selected) {
        if (this.selected == selected) {
            return;
        }
        this.selected = selected;
        MapLayerEvent event = new MapLayerEvent(this, 6);
        if (selected) {
            this.fireMapLayerListenerLayerSelected(event);
        } else {
            this.fireMapLayerListenerLayerDeselected(event);
        }
    }

    @Override
    public Query getQuery() {
        return this.query == Query.ALL ? this.query : new DefaultQuery(this.query);
    }

    @Override
    public void setQuery(Query query) {
        if (query == null) {
            throw new NullPointerException("must provide a Query. Do you mean Query.ALL?");
        }
        this.query = new DefaultQuery(query);
        this.fireMapLayerListenerLayerChanged(new MapLayerEvent(this, 5));
    }

    @Override
    public ReferencedEnvelope getBounds() {
        CoordinateReferenceSystem sourceCrs = this.featureSource.getSchema().getCoordinateReferenceSystem();
        try {
            ReferencedEnvelope env = new ReferencedEnvelope((Envelope)this.featureSource.getBounds(), sourceCrs);
            return env;
        }
        catch (MismatchedDimensionException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public synchronized void addMapLayerListener(MapLayerListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        if (this.listenerList.getListenerCount() == 0 && this.featureSource != null) {
            this.featureSource.addFeatureListener(this.sourceListener);
        }
        this.listenerList.add(MapLayerListener.class, listener);
    }

    @Override
    public synchronized void removeMapLayerListener(MapLayerListener listener) {
        this.listenerList.remove(MapLayerListener.class, listener);
        if (this.listenerList.getListenerCount() == 0 && this.featureSource != null) {
            this.featureSource.removeFeatureListener(this.sourceListener);
        }
    }

    protected void fireMapLayerListenerLayerChanged(MapLayerEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        int length = listeners.length;
        for (int i = length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MapLayerListener.class) continue;
            ((MapLayerListener)listeners[i + 1]).layerChanged(event);
        }
    }

    protected void fireMapLayerListenerLayerShown(MapLayerEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        int length = listeners.length;
        for (int i = length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MapLayerListener.class) continue;
            ((MapLayerListener)listeners[i + 1]).layerShown(event);
        }
    }

    protected void fireMapLayerListenerLayerHidden(MapLayerEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        int length = listeners.length;
        for (int i = length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MapLayerListener.class) continue;
            ((MapLayerListener)listeners[i + 1]).layerHidden(event);
        }
    }

    protected void fireMapLayerListenerLayerSelected(MapLayerEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        int length = listeners.length;
        for (int i = length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MapLayerListener.class) continue;
            ((MapLayerListener)listeners[i + 1]).layerSelected(event);
        }
    }

    protected void fireMapLayerListenerLayerDeselected(MapLayerEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        int length = listeners.length;
        for (int i = length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MapLayerListener.class) continue;
            ((MapLayerListener)listeners[i + 1]).layerDeselected(event);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("FeatureCollectionMapLayer[ ");
        if (this.title == null || this.title.length() == 0) {
            buf.append("UNNAMED");
        } else {
            buf.append(this.title);
        }
        if (this.visible) {
            buf.append(", VISIBLE");
        } else {
            buf.append(", HIDDEN");
        }
        if (this.selected) {
            buf.append(", SELECTED");
        } else {
            buf.append(", UNSELECTED");
        }
        buf.append(", style=");
        buf.append(this.style);
        buf.append(", data=");
        buf.append(this.featureSource);
        if (this.query != Query.ALL) {
            buf.append(", query=");
            buf.append(this.query);
        }
        buf.append("]");
        return buf.toString();
    }
}

