/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.shape;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.util.Stack;
import org.geotools.filter.visitor.AbstractFilterVisitor;

public class BoundsExtractor
extends AbstractFilterVisitor {
    private Stack envelopeStack = new Stack();
    private final Envelope original;
    private Envelope notEnvelope;
    private static final GeometryFactory factory = new GeometryFactory();

    public BoundsExtractor(Envelope bbox) {
        this.original = bbox;
    }

    public BoundsExtractor(int minx, int maxx, int miny, int maxy) {
        this(new Envelope((double)minx, (double)maxx, (double)miny, (double)maxy));
    }

    public Envelope getIntersection() {
        Envelope bbox = null;
        if (!this.envelopeStack.isEmpty()) {
            bbox = (Envelope)this.envelopeStack.peek();
        }
        if (this.original == null) {
            return bbox == null ? new Envelope() : bbox;
        }
        if (bbox != null) {
            return bbox.intersection(this.original);
        }
        if (this.notEnvelope != null) {
            return this.intersectionWithNotEnvelope(this.original);
        }
        return this.original;
    }

    public Envelope getFilterEnvelope() {
        if (this.envelopeStack.isEmpty()) {
            return new Envelope();
        }
        return (Envelope)this.envelopeStack.peek();
    }

    public Envelope getNotEnvelope() {
        return this.notEnvelope == null ? new Envelope() : this.notEnvelope;
    }

    private Envelope intersectionWithNotEnvelope(Envelope bbox) {
        Envelope envelopeInternal;
        Geometry notGeom = factory.toGeometry(this.notEnvelope);
        Geometry andGeom = factory.toGeometry(bbox);
        bbox = envelopeInternal = andGeom.difference(notGeom).getEnvelopeInternal();
        return bbox;
    }
}

