/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditorManager;
import java.beans.PropertyEditorSupport;
import java.beans.SimpleBeanInfo;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.geotools.validation.Validation;

public class ValidationBeanInfo
extends SimpleBeanInfo {
    public ValidationBeanInfo() {
        PropertyEditorManager.registerEditor(URL.class, URLPropertyEditor.class);
    }

    public PropertyDescriptor[] getPropertyDescriptors() {
        try {
            PropertyDescriptor[] pd = new PropertyDescriptor[2];
            ResourceBundle resourceBundle = this.getResourceBundle(Validation.class);
            pd[0] = this.createPropertyDescriptor("name", Validation.class, resourceBundle);
            pd[0].setExpert(false);
            pd[1] = this.createPropertyDescriptor("description", Validation.class, resourceBundle);
            pd[1].setExpert(false);
            return pd;
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
            return new PropertyDescriptor[0];
        }
    }

    protected Class beanType() {
        Class<?> type = this.getClass();
        String typeName = type.getName();
        if (typeName.endsWith("BeanInfo")) {
            typeName = typeName.substring(0, typeName.length() - 8);
            try {
                return Class.forName(typeName);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        return null;
    }

    protected ResourceBundle getResourceBundle() {
        return this.getResourceBundle(this.beanType());
    }

    protected ResourceBundle getResourceBundle(Class cls) {
        Locale locale = Locale.getDefault();
        try {
            return ResourceBundle.getBundle(cls.getName(), locale);
        }
        catch (MissingResourceException mre) {
            return ResourceBundle.getBundle(cls.getName());
        }
    }

    protected PropertyDescriptor createPropertyDescriptor(String name, ResourceBundle bundle) throws IntrospectionException {
        return this.createPropertyDescriptor(name, this.beanType(), bundle);
    }

    protected PropertyDescriptor createPropertyDescriptor(String name, Class cls, ResourceBundle resourceBundle) throws IntrospectionException {
        PropertyDescriptor pd = new PropertyDescriptor(name, cls);
        String s = resourceBundle.getString(String.valueOf(pd.getName()) + ".DisplayName");
        if (s == null || s == "") {
            s = pd.getDisplayName();
        }
        pd.setDisplayName(s);
        s = resourceBundle.getString(String.valueOf(pd.getName()) + ".Description");
        if (s == null || s == "") {
            s = pd.getShortDescription();
        }
        pd.setShortDescription(s);
        return pd;
    }

    class URLPropertyEditor
    extends PropertyEditorSupport {
        URL url;

        URLPropertyEditor() {
        }

        public String getAsText() {
            return this.url.toString();
        }

        public void setAsText(String text) throws IllegalArgumentException {
            try {
                this.url = new URL(text);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Invalid URL: " + text);
            }
        }

        public boolean supportsCustomEditor() {
            return false;
        }

        public String getJavaInitializationString() {
            return "new URL(\"" + this.url.toString() + "\")";
        }

        public boolean isPaintable() {
            return false;
        }

        public String toString() {
            return this.url.toString();
        }

        public void setValue(Object value) {
            try {
                this.url = new URL(value.toString());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }

        public Object getValue() {
            return this.url;
        }
    }
}

