/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation.dto;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.geotools.validation.dto.TestDTO;

public class TestSuiteDTO {
    private String name;
    private String description;
    private Map tests;

    public TestSuiteDTO() {
    }

    public TestSuiteDTO(TestSuiteDTO ts) {
        this.name = ts.getName();
        this.description = ts.getDescription();
        this.tests = new HashMap();
        Iterator i = ts.getTests().keySet().iterator();
        while (i.hasNext()) {
            TestDTO t = (TestDTO)ts.getTests().get(i.next());
            this.tests.put(t.getName(), new TestDTO(t));
        }
    }

    public Object clone() {
        return new TestSuiteDTO(this);
    }

    public int hashCode() {
        int r = 1;
        if (this.tests != null) {
            r *= this.tests.hashCode();
        }
        if (this.name != null) {
            r *= this.name.hashCode();
        }
        if (this.description != null) {
            r *= this.description.hashCode();
        }
        return r;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof TestSuiteDTO)) {
            return false;
        }
        boolean r = true;
        TestSuiteDTO ts = (TestSuiteDTO)obj;
        if (this.name != null) {
            boolean bl = r = r && this.name.equals(ts.getName());
        }
        if (this.description != null) {
            boolean bl = r = r && this.description.equals(ts.getDescription());
        }
        if (this.tests == null) {
            if (ts.getTests() != null) {
                return false;
            }
        } else if (ts.getTests() != null) {
            r = r && this.tests.equals(ts.getTests());
        } else {
            return false;
        }
        return r;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map getTests() {
        return this.tests;
    }

    public void setTests(Map tests) {
        this.tests = tests;
    }
}

