/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation.relate;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.feature.FeatureIterator;
import org.geotools.filter.IllegalFilterException;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.geotools.validation.ValidationResults;
import org.geotools.validation.relate.RelationIntegrity;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.Disjoint;

public class OverlapsIntegrity
extends RelationIntegrity {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.validation");
    private static HashSet usedIDs;
    private boolean showPrintLines = true;

    public OverlapsIntegrity() {
        usedIDs = new HashSet();
    }

    public boolean validate(Map layers, ReferencedEnvelope envelope, ValidationResults results) throws Exception {
        LOGGER.finer("Starting test " + this.getName() + " (" + this.getClass().getName() + ")");
        String typeRef1 = this.getGeomTypeRefA();
        LOGGER.finer(String.valueOf(typeRef1) + ": looking up FeatureSource");
        SimpleFeatureSource geomSource1 = (SimpleFeatureSource)layers.get(typeRef1);
        LOGGER.finer(String.valueOf(typeRef1) + ": found " + ((SimpleFeatureType)geomSource1.getSchema()).getTypeName());
        String typeRef2 = this.getGeomTypeRefB();
        if (typeRef2 == "" || typeRef1.equals(typeRef2)) {
            return this.validateSingleLayer(geomSource1, this.isExpected(), results, envelope);
        }
        LOGGER.warning(String.valueOf(typeRef2) + ": looking up SimpleFeatureSource ");
        SimpleFeatureSource geomSource2 = (SimpleFeatureSource)layers.get(typeRef2);
        LOGGER.finer(String.valueOf(typeRef2) + ": found " + ((SimpleFeatureType)geomSource2.getSchema()).getTypeName());
        return this.validateMultipleLayers(geomSource1, geomSource2, this.isExpected(), results, envelope);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean validateMultipleLayers(SimpleFeatureSource featureSourceA, SimpleFeatureSource featureSourceB, boolean expected, ValidationResults results, ReferencedEnvelope bBox) throws Exception {
        block9: {
            success = true;
            errors = 0;
            countInterval = 100;
            counter = 0;
            ft = (SimpleFeatureType)featureSourceA.getSchema();
            filter = OverlapsIntegrity.filterBBox((Envelope)bBox, ft);
            collectionA = featureSourceA.getFeatures();
            fr1 = null;
            fr2 = null;
            try {
                fr1 = collectionA.features();
                if (fr1 != null) ** GOTO lbl-1000
                var23_15 = success;
            }
            catch (Throwable var22_23) {
                collectionA.close((FeatureIterator)fr1);
                throw var22_23;
            }
lbl-1000:
            // 3 sources

            {
                block6: while (fr1.hasNext()) {
                    ++counter;
                    f1 = (SimpleFeature)fr1.next();
                    g1 = (Geometry)f1.getDefaultGeometry();
                    filter2 = OverlapsIntegrity.filterBBox((Envelope)ReferencedEnvelope.reference((Envelope)g1.getEnvelope().getEnvelopeInternal()), ft);
                    collectionB = featureSourceB.getFeatures(filter2);
                    fr2 = collectionB.features();
                    try {
                        while (true) {
                            if (fr2 == null || !fr2.hasNext()) {
                                OverlapsIntegrity.usedIDs.add(f1.getID());
                                if (counter % countInterval != 0 || !this.showPrintLines) continue block6;
                                System.out.println("count: " + counter);
                                continue block6;
                            }
                            f2 = (SimpleFeature)fr2.next();
                            g2 = (Geometry)f2.getDefaultGeometry();
                            if (OverlapsIntegrity.usedIDs.contains(f2.getID()) || f1.getID().equals(f2.getID()) || g1.overlaps(g2) == expected && g1.contains(g2) == expected) continue;
                            results.error(f1, String.valueOf(this.getGeomTypeRefA()) + "(" + f1.getID() + ")" + " overlapped " + this.getGeomTypeRefB() + "(" + f2.getID() + ")");
                            success = false;
                            ++errors;
                        }
                    }
                    finally {
                        collectionB.close((FeatureIterator)fr2);
                    }
                }
                break block9;
            }
            collectionA.close((FeatureIterator)fr1);
            return var23_15;
        }
        collectionA.close((FeatureIterator)fr1);
        return success;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean validateSingleLayer(SimpleFeatureSource featureSourceA, boolean expected, ValidationResults results, ReferencedEnvelope bBox) throws Exception {
        block15: {
            success = true;
            errors = 0;
            date1 = new Date();
            countInterval = 100;
            counter = 0;
            ft = (SimpleFeatureType)featureSourceA.getSchema();
            System.out.println("---------------- In Overlaps Integrity ----------------");
            collectionA = null;
            if (bBox != null && !bBox.isNull() && bBox.getHeight() != 0.0 && bBox.getWidth() != 0.0) {
                filter = OverlapsIntegrity.filterBBox((Envelope)bBox, ft);
                collectionA = featureSourceA.getFeatures(filter);
            } else {
                collectionA = featureSourceA.getFeatures();
            }
            fr1 = null;
            fr2 = null;
            try {
                fr1 = collectionA.features();
                if (fr1 != null) ** GOTO lbl-1000
                var22_14 = success;
                date2 = new Date();
            }
            catch (Throwable var21_28) {
                date2 = new Date();
                dt = date2.getTime() - date1.getTime();
                if (this.showPrintLines) {
                    System.out.println("########## Validation duration: " + dt);
                    System.out.println("########## Validation errors: " + errors);
                }
                collectionA.close((FeatureIterator)fr1);
                throw var21_28;
            }
lbl-1000:
            // 2 sources

            {
                block6: while (fr1.hasNext()) {
                    ++counter;
                    f1 = (SimpleFeature)fr1.next();
                    g1 = (Geometry)f1.getDefaultGeometry();
                    filter2 = OverlapsIntegrity.filterBBox((Envelope)ReferencedEnvelope.reference((Envelope)g1.getEnvelope().getEnvelopeInternal()), ft);
                    collectionB = featureSourceA.getFeatures(filter2);
                    fr2 = collectionB.features();
                    try {
                        while (true) {
                            if (fr2 == null || !fr2.hasNext()) {
                                OverlapsIntegrity.usedIDs.add(f1.getID());
                                continue block6;
                            }
                            f2 = (SimpleFeature)fr2.next();
                            g2 = (Geometry)f2.getDefaultGeometry();
                            if (OverlapsIntegrity.usedIDs.contains(f2.getID()) || f1.getID().equals(f2.getID()) || g1.relate(g2, "1********") == expected) continue;
                            if (results != null) {
                                results.error(f1, this.getGeomTypeRefA() + "(" + f1.getID() + ")" + " overlapped " + this.getGeomTypeRefA() + "(" + f2.getID() + ")");
                            }
                            success = false;
                            ++errors;
                        }
                    }
                    finally {
                        collectionB.close((FeatureIterator)fr2);
                    }
                }
                break block15;
            }
            dt = date2.getTime() - date1.getTime();
            if (this.showPrintLines) {
                System.out.println("########## Validation duration: " + dt);
                System.out.println("########## Validation errors: " + errors);
            }
            collectionA.close((FeatureIterator)fr1);
            return var22_14;
        }
        date2 = new Date();
        dt = date2.getTime() - date1.getTime();
        if (this.showPrintLines) {
            System.out.println("########## Validation duration: " + dt);
            System.out.println("########## Validation errors: " + errors);
        }
        collectionA.close((FeatureIterator)fr1);
        return success;
    }

    public static Filter filterBBox(Envelope bBox, SimpleFeatureType ft) throws FactoryRegistryException, IllegalFilterException {
        if (bBox == null) {
            return Filter.INCLUDE;
        }
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
        PropertyName geomExpr = ff.property(ft.getGeometryDescriptor().getLocalName());
        Literal bboxExpr = ff.literal((Object)JTS.toGeometry((Envelope)bBox));
        Disjoint disjointFilter = ff.disjoint((Expression)geomExpr, (Expression)bboxExpr);
        return ff.not((Filter)disjointFilter);
    }
}

