/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation.spatial;

import com.vividsolutions.jts.geom.LineString;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.geotools.validation.DefaultFeatureValidation;
import org.geotools.validation.ValidationResults;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class LineMustBeASinglePartValidation
extends DefaultFeatureValidation {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.validation");

    public int getPriority() {
        return 200;
    }

    public boolean validate(SimpleFeature feature, SimpleFeatureType type, ValidationResults results) {
        LOGGER.setLevel(Level.ALL);
        LineString line = null;
        try {
            line = this.getDefaultLineString(feature);
        }
        catch (ClassCastException wrongType) {
            results.warning(feature, wrongType.getMessage());
            return true;
        }
        if (line == null) {
            return true;
        }
        int NUMBER_OF_POINTS = line.getNumPoints();
        if (NUMBER_OF_POINTS < 2) {
            results.error(feature, "LineString contains too few points");
            return false;
        }
        if (NUMBER_OF_POINTS > 2) {
            String message = "LineString is not single part (contains " + (NUMBER_OF_POINTS - 1) + " segments)";
            results.error(feature, message);
            LOGGER.log(Level.FINEST, String.valueOf(this.getName()) + "(" + feature.getID() + "):" + message);
            return false;
        }
        LOGGER.log(Level.FINEST, String.valueOf(this.getName()) + "(" + feature.getID() + ") passed");
        return true;
    }
}

