/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation.spatial;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.geotools.validation.DefaultFeatureValidation;
import org.geotools.validation.ValidationResults;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class LineNoSelfOverlappingValidation
extends DefaultFeatureValidation {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.validation");

    public LineNoSelfOverlappingValidation() {
        System.out.println("***************** LineNoSelfOverlappingValidation *************");
    }

    public int getPriority() {
        return 1000;
    }

    public boolean validate(SimpleFeature feature, SimpleFeatureType type, ValidationResults results) {
        LOGGER.setLevel(Level.ALL);
        LineString line = null;
        try {
            line = this.getDefaultLineString(feature);
        }
        catch (ClassCastException unLine) {
            results.error(feature, "Geometry is required to be a LineString");
            System.out.println(String.valueOf(feature.getID()) + "  name: " + this.getName());
            System.out.println(String.valueOf(feature.getID()) + "   ref: " + this.getTypeRef());
            System.out.println(String.valueOf(feature.getID()) + "   ref: " + this.getTypeRefs());
        }
        if (line == null) {
            return true;
        }
        if (line.getNumPoints() < 2) {
            results.warning(feature, "LineString contains too few points");
            return false;
        }
        GeometryFactory gf = new GeometryFactory();
        int numPoints = line.getNumPoints();
        LineString[] segments = new LineString[numPoints - 1];
        int i = 0;
        while (i < numPoints - 1) {
            Coordinate[] coords = new Coordinate[]{line.getCoordinateN(i), line.getCoordinateN(i + 1)};
            segments[i] = gf.createLineString(coords);
            ++i;
        }
        i = 0;
        while (i < segments.length) {
            int j = 0;
            while (j < segments.length) {
                if (i != j && segments[i].relate((Geometry)segments[j], "1********")) {
                    results.error(feature, "LineString overlapped itself.");
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    private boolean touchesSegment(LineString[] segments, Point p1) {
        int i = 0;
        while (i < segments.length) {
            if (p1.intersects((Geometry)segments[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

