/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation.spatial;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.util.Map;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.validation.ValidationResults;
import org.geotools.validation.spatial.LineLineAbstractValidation;
import org.opengis.feature.simple.SimpleFeature;

public class LinesNotOverlapValidation
extends LineLineAbstractValidation {
    public boolean validate(Map layers, Envelope envelope, ValidationResults results) throws Exception {
        SimpleFeatureSource lineSource1 = (SimpleFeatureSource)layers.get(this.getLineTypeRef());
        SimpleFeatureSource lineSource2 = (SimpleFeatureSource)layers.get(this.getRestrictedLineTypeRef());
        Object[] lines1 = lineSource1.getFeatures().toArray();
        Object[] lines2 = lineSource2.getFeatures().toArray();
        if (!envelope.contains((Envelope)lineSource1.getBounds())) {
            results.error((SimpleFeature)lines1[0], "Point Feature Source is not contained within the Envelope provided.");
            return false;
        }
        if (!envelope.contains((Envelope)lineSource2.getBounds())) {
            results.error((SimpleFeature)lines2[0], "Line Feature Source is not contained within the Envelope provided.");
            return false;
        }
        boolean r = true;
        int i = 0;
        while (i < lines2.length) {
            SimpleFeature tmp = (SimpleFeature)lines2[i];
            Geometry gt = (Geometry)tmp.getDefaultGeometry();
            int j = 0;
            while (j < lines1.length) {
                SimpleFeature tmp2 = (SimpleFeature)lines1[j];
                Geometry gt2 = (Geometry)tmp2.getDefaultGeometry();
                if (gt.overlaps(gt2)) {
                    results.error(tmp, "Overlaps with another line specified. Id=" + tmp2.getID());
                    r = false;
                }
                ++j;
            }
            ++i;
        }
        return r;
    }
}

