/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation.spatial;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import java.util.Map;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.validation.ValidationResults;
import org.geotools.validation.spatial.PointLineAbstractValidation;
import org.opengis.feature.simple.SimpleFeature;

public class PointCoveredByEndPointOfLineValidation
extends PointLineAbstractValidation {
    public boolean validate(Map layers, Envelope envelope, ValidationResults results) throws Exception {
        SimpleFeatureSource lineSource = (SimpleFeatureSource)layers.get(this.getRestrictedLineTypeRef());
        SimpleFeatureSource pointSource = (SimpleFeatureSource)layers.get(this.getPointTypeRef());
        Object[] points = pointSource.getFeatures().toArray();
        Object[] lines = lineSource.getFeatures().toArray();
        if (!envelope.contains((Envelope)pointSource.getBounds())) {
            results.error((SimpleFeature)points[0], "Point Feature Source is not contained within the Envelope provided.");
            return false;
        }
        if (!envelope.contains((Envelope)lineSource.getBounds())) {
            results.error((SimpleFeature)lines[0], "Line Feature Source is not contained within the Envelope provided.");
            return false;
        }
        int i = 0;
        while (i < lines.length) {
            SimpleFeature tmp = (SimpleFeature)lines[i];
            Geometry gt = (Geometry)tmp.getDefaultGeometry();
            if (gt instanceof LineString) {
                LineString ls = (LineString)gt;
                Point str = ls.getStartPoint();
                Point end = ls.getEndPoint();
                int j = 0;
                while (j < points.length) {
                    Point pt;
                    SimpleFeature tmp2 = (SimpleFeature)points[j];
                    Geometry gt2 = (Geometry)tmp2.getDefaultGeometry();
                    if (gt2 instanceof Point && ((pt = (Point)gt2).equalsExact((Geometry)str) || pt.equalsExact((Geometry)end))) {
                        return true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return false;
    }
}

