/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation.spatial;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.Map;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.validation.ValidationResults;
import org.geotools.validation.spatial.PointPolygonAbstractValidation;
import org.opengis.feature.simple.SimpleFeature;

public class PointCoveredByPolygonBoundaryValidation
extends PointPolygonAbstractValidation {
    public boolean validate(Map layers, Envelope envelope, ValidationResults results) throws Exception {
        SimpleFeatureSource pointSource = (SimpleFeatureSource)layers.get(this.getPointTypeRef());
        SimpleFeatureSource polySource = (SimpleFeatureSource)layers.get(this.getRestrictedPolygonTypeRef());
        Object[] polys = polySource.getFeatures().toArray();
        Object[] points = pointSource.getFeatures().toArray();
        if (!envelope.contains((Envelope)polySource.getBounds())) {
            results.error((SimpleFeature)polys[0], "Point Feature Source is not contained within the Envelope provided.");
            return false;
        }
        if (!envelope.contains((Envelope)pointSource.getBounds())) {
            results.error((SimpleFeature)points[0], "Line Feature Source is not contained within the Envelope provided.");
            return false;
        }
        int i = 0;
        while (i < points.length) {
            SimpleFeature tmp = (SimpleFeature)points[i];
            Geometry gt = (Geometry)tmp.getDefaultGeometry();
            if (gt instanceof Polygon) {
                Polygon ls = (Polygon)gt;
                boolean r = false;
                int j = 0;
                while (j < polys.length && !r) {
                    SimpleFeature tmp2 = (SimpleFeature)polys[j];
                    Geometry gt2 = (Geometry)tmp2.getDefaultGeometry();
                    if (gt2 instanceof Point) {
                        Point pt = (Point)gt2;
                        if (!ls.getBoundary().contains((Geometry)pt)) {
                            r = true;
                        }
                    }
                    ++j;
                }
                if (!r) {
                    results.error(tmp, "Polygon does not contained one of the specified points.");
                    return false;
                }
            }
            ++i;
        }
        return true;
    }
}

